/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import java.util.ArrayList;
import org.opencds.cqf.cql.engine.elm.executing.DistinctEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.GreaterEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.InEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.LessEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.OverlapsEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.State;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.Interval;

public class IntersectEvaluator {
    public static Object intersect(Object left, Object right, State state) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Interval) {
            Object max;
            Boolean overlaps;
            Interval leftInterval = (Interval)left;
            Interval rightInterval = (Interval)right;
            Object leftStart = leftInterval.getStart();
            Object leftEnd = leftInterval.getEnd();
            Object rightStart = rightInterval.getStart();
            Object rightEnd = rightInterval.getEnd();
            String precision = null;
            if (leftStart instanceof BaseTemporal && rightStart instanceof BaseTemporal) {
                precision = BaseTemporal.getHighestPrecision((BaseTemporal)leftStart, (BaseTemporal)leftEnd, (BaseTemporal)rightStart, (BaseTemporal)rightEnd);
            }
            if ((overlaps = OverlapsEvaluator.overlaps(leftInterval, rightInterval, precision, state)) != null && !overlaps.booleanValue()) {
                return null;
            }
            Boolean leftStartGtRightStart = GreaterEvaluator.greater(leftStart, rightStart, state);
            Boolean leftEndLtRightEnd = LessEvaluator.less(leftEnd, rightEnd, state);
            if (leftStart == null || rightStart == null) {
                max = null;
            } else if (leftStartGtRightStart == null && precision != null) {
                max = ((BaseTemporal)leftStart).getPrecision().toString().equals(precision) ? leftStart : rightStart;
            } else {
                Object object = leftStartGtRightStart == null ? null : (max = leftStartGtRightStart != false ? leftStart : rightStart);
            }
            Object min = leftEnd == null || rightEnd == null ? null : (leftEndLtRightEnd == null && precision != null ? (((BaseTemporal)leftEnd).getPrecision().toString().equals(precision) ? leftEnd : rightEnd) : (leftEndLtRightEnd == null ? null : (leftEndLtRightEnd != false ? leftEnd : rightEnd)));
            return new Interval(max, max != null, min, min != null);
        }
        if (left instanceof Iterable) {
            Iterable leftArr = (Iterable)left;
            Iterable rightArr = (Iterable)right;
            ArrayList result = new ArrayList();
            for (Object leftItem : leftArr) {
                Boolean in = InEvaluator.in(leftItem, rightArr, null, state);
                if (in == null || !in.booleanValue()) continue;
                result.add(leftItem);
            }
            return DistinctEvaluator.distinct(result, state);
        }
        throw new InvalidOperatorArgument("Intersect(Interval<T>, Interval<T>) or Intersect(List<T>, List<T>)", String.format("Intersect(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }
}

