/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import java.math.BigDecimal;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.runtime.Quantity;

public class FloorEvaluator {
    public static Object floor(Object operand) {
        if (operand == null) {
            return null;
        }
        if (operand instanceof BigDecimal) {
            return BigDecimal.valueOf(Math.floor(((BigDecimal)operand).doubleValue())).intValue();
        }
        if (operand instanceof Quantity) {
            return BigDecimal.valueOf(Math.floor(((Quantity)operand).getValue().doubleValue())).intValue();
        }
        throw new InvalidOperatorArgument("Floor(Decimal)", String.format("Floor(%s)", operand.getClass().getName()));
    }
}

