/*
 * Decompiled with CFR 0.152.
 */
package info.androidhive.barcode;

import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Tracker;
import com.google.android.gms.vision.barcode.Barcode;
import info.androidhive.barcode.BarcodeGraphic;
import info.androidhive.barcode.camera.GraphicOverlay;
import java.util.ArrayList;
import java.util.List;

class BarcodeGraphicTracker
extends Tracker<Barcode> {
    private GraphicOverlay<BarcodeGraphic> mOverlay;
    private BarcodeGraphic mGraphic;
    private BarcodeGraphicTrackerListener listener;

    BarcodeGraphicTracker(GraphicOverlay<BarcodeGraphic> overlay, BarcodeGraphic graphic, BarcodeGraphicTrackerListener listener) {
        this.mOverlay = overlay;
        this.mGraphic = graphic;
        this.listener = listener;
    }

    public void onNewItem(int id, Barcode item) {
        this.mGraphic.setId(id);
        Log.e((String)"XX", (String)("barcode detected: " + item.displayValue + ", listener: " + this.listener));
        if (this.listener != null) {
            this.listener.onScanned(item);
        }
    }

    public void onUpdate(Detector.Detections<Barcode> detectionResults, Barcode item) {
        this.mOverlay.add(this.mGraphic);
        this.mGraphic.updateItem(item);
        if (detectionResults != null && detectionResults.getDetectedItems().size() > 1) {
            Log.e((String)"XX", (String)"Multiple items detected");
            Log.e((String)"XX", (String)("onUpdate: " + detectionResults.getDetectedItems().size()));
            if (this.listener != null) {
                List<Barcode> barcodes = BarcodeGraphicTracker.asList(detectionResults.getDetectedItems());
                this.listener.onScannedMultiple(barcodes);
            }
        }
    }

    public static <C> List<C> asList(SparseArray<C> sparseArray) {
        if (sparseArray == null) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(sparseArray.size());
        for (int i = 0; i < sparseArray.size(); ++i) {
            arrayList.add(sparseArray.valueAt(i));
        }
        return arrayList;
    }

    public void onMissing(Detector.Detections<Barcode> detectionResults) {
        this.mOverlay.remove(this.mGraphic);
    }

    public void onDone() {
        this.mOverlay.remove(this.mGraphic);
    }

    public static interface BarcodeGraphicTrackerListener {
        public void onScanned(Barcode var1);

        public void onScannedMultiple(List<Barcode> var1);

        public void onBitmapScanned(SparseArray<Barcode> var1);

        public void onScanError(String var1);
    }
}

