/*
 * Decompiled with CFR 0.152.
 */
package info.androidhive.barcode.camera;

import android.content.Context;
import android.support.annotation.RequiresPermission;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.common.images.Size;
import info.androidhive.barcode.camera.CameraSource;
import info.androidhive.barcode.camera.GraphicOverlay;
import java.io.IOException;

public class CameraSourcePreview
extends ViewGroup {
    private static final String TAG = "CameraSourcePreview";
    private Context mContext;
    private SurfaceView mSurfaceView;
    private boolean mStartRequested;
    private boolean mSurfaceAvailable;
    private CameraSource mCameraSource;
    private GraphicOverlay mOverlay;

    public CameraSourcePreview(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.mStartRequested = false;
        this.mSurfaceAvailable = false;
        this.mSurfaceView = new SurfaceView(context);
        this.mSurfaceView.getHolder().addCallback((SurfaceHolder.Callback)new SurfaceCallback());
        this.addView((View)this.mSurfaceView);
    }

    @RequiresPermission(value="android.permission.CAMERA")
    public void start(CameraSource cameraSource) throws IOException, SecurityException {
        if (cameraSource == null) {
            this.stop();
        }
        this.mCameraSource = cameraSource;
        if (this.mCameraSource != null) {
            this.mStartRequested = true;
            this.startIfReady();
        }
    }

    @RequiresPermission(value="android.permission.CAMERA")
    public void start(CameraSource cameraSource, GraphicOverlay overlay) throws IOException, SecurityException {
        this.mOverlay = overlay;
        this.start(cameraSource);
    }

    public void stop() {
        if (this.mCameraSource != null) {
            this.mCameraSource.stop();
        }
    }

    public void release() {
        if (this.mCameraSource != null) {
            this.mCameraSource.release();
            this.mCameraSource = null;
        }
    }

    @RequiresPermission(value="android.permission.CAMERA")
    private void startIfReady() throws IOException, SecurityException {
        if (this.mStartRequested && this.mSurfaceAvailable) {
            this.mCameraSource.start(this.mSurfaceView.getHolder());
            if (this.mOverlay != null) {
                Size size = this.mCameraSource.getPreviewSize();
                int min = Math.min(size.getWidth(), size.getHeight());
                int max = Math.max(size.getWidth(), size.getHeight());
                if (this.isPortraitMode()) {
                    this.mOverlay.setCameraInfo(min, max, this.mCameraSource.getCameraFacing());
                } else {
                    this.mOverlay.setCameraInfo(max, min, this.mCameraSource.getCameraFacing());
                }
                this.mOverlay.clear();
            }
            this.mStartRequested = false;
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        Size size;
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.mCameraSource != null && (size = this.mCameraSource.getPreviewSize()) != null) {
            width = size.getWidth();
            height = size.getHeight();
        }
        int layoutWidth = right - left;
        int layoutHeight = bottom - top;
        if (this.isPortraitMode()) {
            int tmp = width;
            width = height;
            height = tmp;
        }
        int childWidth = layoutWidth;
        int childHeight = (int)((float)layoutWidth / (float)width * (float)height);
        if (this.isPortraitMode()) {
            childHeight = layoutHeight;
            childWidth = (int)((float)layoutHeight / (float)height * (float)width);
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).layout(0, 0, childWidth, childHeight);
        }
        try {
            this.startIfReady();
        }
        catch (SecurityException se) {
            Log.e((String)TAG, (String)"Do not have permission to start the camera", (Throwable)se);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Could not start camera source.", (Throwable)e);
        }
    }

    private boolean isPortraitMode() {
        int orientation = this.mContext.getResources().getConfiguration().orientation;
        if (orientation == 2) {
            return false;
        }
        if (orientation == 1) {
            return true;
        }
        Log.d((String)TAG, (String)"isPortraitMode returning false by default");
        return false;
    }

    private class SurfaceCallback
    implements SurfaceHolder.Callback {
        private SurfaceCallback() {
        }

        public void surfaceCreated(SurfaceHolder surface) {
            CameraSourcePreview.this.mSurfaceAvailable = true;
            try {
                CameraSourcePreview.this.startIfReady();
            }
            catch (SecurityException se) {
                Log.e((String)CameraSourcePreview.TAG, (String)"Do not have permission to start the camera", (Throwable)se);
            }
            catch (IOException e) {
                Log.e((String)CameraSourcePreview.TAG, (String)"Could not start camera source.", (Throwable)e);
            }
        }

        public void surfaceDestroyed(SurfaceHolder surface) {
            CameraSourcePreview.this.mSurfaceAvailable = false;
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        }
    }
}

