/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dht;

import edu.emory.mathcs.jtransforms.dht.FloatDHT_1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class FloatDHT_2D {
    private int rows;
    private int columns;
    private float[] t;
    private FloatDHT_1D dhtColumns;
    private FloatDHT_1D dhtRows;
    private int oldNthreads;
    private int nt;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public FloatDHT_2D(int n, int n2) {
        if (n <= 1 || n2 <= 1) {
            throw new IllegalArgumentException("rows and columns must be greater than 1");
        }
        this.rows = n;
        this.columns = n2;
        if (n * n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.useThreads = true;
        }
        if (ConcurrencyUtils.isPowerOf2((int)n) && ConcurrencyUtils.isPowerOf2((int)n2)) {
            this.isPowerOfTwo = true;
            this.oldNthreads = ConcurrencyUtils.getNumberOfThreads();
            this.nt = 4 * this.oldNthreads * n;
            if (n2 == 2 * this.oldNthreads) {
                this.nt >>= 1;
            } else if (n2 < 2 * this.oldNthreads) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
        }
        this.dhtColumns = new FloatDHT_1D(n2);
        this.dhtRows = n2 == n ? this.dhtColumns : new FloatDHT_1D(n);
    }

    public void forward(final float[] fArray) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n != this.oldNthreads) {
                this.nt = 4 * n * this.rows;
                if (this.columns == 2 * n) {
                    this.nt >>= 1;
                } else if (this.columns < 2 * n) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = n;
            }
            if (n > 1 && this.useThreads) {
                this.ddxt2d_subth(-1, fArray, true);
                this.ddxt2d0_subth(-1, fArray, true);
            } else {
                this.ddxt2d_sub(-1, fArray, true);
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.forward(fArray, i * this.columns);
                }
            }
            this.yTransform(fArray);
        } else {
            if (n > 1 && this.useThreads && this.rows >= n && this.columns >= n) {
                int n2;
                int n3;
                int n4;
                Future[] futureArray = new Future[n];
                int n5 = this.rows / n;
                for (n4 = 0; n4 < n; ++n4) {
                    n3 = n4 * n5;
                    n2 = n4 == n - 1 ? this.rows : n3 + n5;
                    futureArray[n4] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            for (int i = n3; i < n2; ++i) {
                                FloatDHT_2D.this.dhtColumns.forward(fArray, i * FloatDHT_2D.this.columns);
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futureArray);
                n5 = this.columns / n;
                for (n4 = 0; n4 < n; ++n4) {
                    n3 = n4 * n5;
                    n2 = n4 == n - 1 ? this.columns : n3 + n5;
                    futureArray[n4] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            float[] fArray2 = new float[FloatDHT_2D.this.rows];
                            for (int i = n3; i < n2; ++i) {
                                int n;
                                for (n = 0; n < FloatDHT_2D.this.rows; ++n) {
                                    fArray2[n] = fArray[n * FloatDHT_2D.this.columns + i];
                                }
                                FloatDHT_2D.this.dhtRows.forward(fArray2);
                                for (n = 0; n < FloatDHT_2D.this.rows; ++n) {
                                    fArray[n * ((FloatDHT_2D)FloatDHT_2D.this).columns + i] = fArray2[n];
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futureArray);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.forward(fArray, i * this.columns);
                }
                float[] fArray2 = new float[this.rows];
                for (int i = 0; i < this.columns; ++i) {
                    int n6;
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        fArray2[n6] = fArray[n6 * this.columns + i];
                    }
                    this.dhtRows.forward(fArray2);
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        fArray[n6 * this.columns + i] = fArray2[n6];
                    }
                }
            }
            this.yTransform(fArray);
        }
    }

    public void forward(final float[][] fArray) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n != this.oldNthreads) {
                this.nt = 4 * n * this.rows;
                if (this.columns == 2 * n) {
                    this.nt >>= 1;
                } else if (this.columns < 2 * n) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = n;
            }
            if (n > 1 && this.useThreads) {
                this.ddxt2d_subth(-1, fArray, true);
                this.ddxt2d0_subth(-1, fArray, true);
            } else {
                this.ddxt2d_sub(-1, fArray, true);
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.forward(fArray[i]);
                }
            }
            this.y_transform(fArray);
        } else {
            if (n > 1 && this.useThreads && this.rows >= n && this.columns >= n) {
                int n2;
                int n3;
                int n4;
                Future[] futureArray = new Future[n];
                int n5 = this.rows / n;
                for (n4 = 0; n4 < n; ++n4) {
                    n3 = n4 * n5;
                    n2 = n4 == n - 1 ? this.rows : n3 + n5;
                    futureArray[n4] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            for (int i = n3; i < n2; ++i) {
                                FloatDHT_2D.this.dhtColumns.forward(fArray[i]);
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futureArray);
                n5 = this.columns / n;
                for (n4 = 0; n4 < n; ++n4) {
                    n3 = n4 * n5;
                    n2 = n4 == n - 1 ? this.columns : n3 + n5;
                    futureArray[n4] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            float[] fArray2 = new float[FloatDHT_2D.this.rows];
                            for (int i = n3; i < n2; ++i) {
                                int n;
                                for (n = 0; n < FloatDHT_2D.this.rows; ++n) {
                                    fArray2[n] = fArray[n][i];
                                }
                                FloatDHT_2D.this.dhtRows.forward(fArray2);
                                for (n = 0; n < FloatDHT_2D.this.rows; ++n) {
                                    fArray[n][i] = fArray2[n];
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futureArray);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.forward(fArray[i]);
                }
                float[] fArray2 = new float[this.rows];
                for (int i = 0; i < this.columns; ++i) {
                    int n6;
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        fArray2[n6] = fArray[n6][i];
                    }
                    this.dhtRows.forward(fArray2);
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        fArray[n6][i] = fArray2[n6];
                    }
                }
            }
            this.y_transform(fArray);
        }
    }

    public void inverse(final float[] fArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n != this.oldNthreads) {
                this.nt = 4 * n * this.rows;
                if (this.columns == 2 * n) {
                    this.nt >>= 1;
                } else if (this.columns < 2 * n) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = n;
            }
            if (n > 1 && this.useThreads) {
                this.ddxt2d_subth(1, fArray, bl);
                this.ddxt2d0_subth(1, fArray, bl);
            } else {
                this.ddxt2d_sub(1, fArray, bl);
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.inverse(fArray, i * this.columns, bl);
                }
            }
            this.yTransform(fArray);
        } else {
            if (n > 1 && this.useThreads && this.rows >= n && this.columns >= n) {
                int n2;
                int n3;
                int n4;
                Future[] futureArray = new Future[n];
                int n5 = this.rows / n;
                for (n4 = 0; n4 < n; ++n4) {
                    n3 = n4 * n5;
                    n2 = n4 == n - 1 ? this.rows : n3 + n5;
                    futureArray[n4] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            for (int i = n3; i < n2; ++i) {
                                FloatDHT_2D.this.dhtColumns.inverse(fArray, i * FloatDHT_2D.this.columns, bl);
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futureArray);
                n5 = this.columns / n;
                for (n4 = 0; n4 < n; ++n4) {
                    n3 = n4 * n5;
                    n2 = n4 == n - 1 ? this.columns : n3 + n5;
                    futureArray[n4] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            float[] fArray2 = new float[FloatDHT_2D.this.rows];
                            for (int i = n3; i < n2; ++i) {
                                int n;
                                for (n = 0; n < FloatDHT_2D.this.rows; ++n) {
                                    fArray2[n] = fArray[n * FloatDHT_2D.this.columns + i];
                                }
                                FloatDHT_2D.this.dhtRows.inverse(fArray2, bl);
                                for (n = 0; n < FloatDHT_2D.this.rows; ++n) {
                                    fArray[n * ((FloatDHT_2D)FloatDHT_2D.this).columns + i] = fArray2[n];
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futureArray);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.inverse(fArray, i * this.columns, bl);
                }
                float[] fArray2 = new float[this.rows];
                for (int i = 0; i < this.columns; ++i) {
                    int n6;
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        fArray2[n6] = fArray[n6 * this.columns + i];
                    }
                    this.dhtRows.inverse(fArray2, bl);
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        fArray[n6 * this.columns + i] = fArray2[n6];
                    }
                }
            }
            this.yTransform(fArray);
        }
    }

    public void inverse(final float[][] fArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n != this.oldNthreads) {
                this.nt = 4 * n * this.rows;
                if (this.columns == 2 * n) {
                    this.nt >>= 1;
                } else if (this.columns < 2 * n) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = n;
            }
            if (n > 1 && this.useThreads) {
                this.ddxt2d_subth(1, fArray, bl);
                this.ddxt2d0_subth(1, fArray, bl);
            } else {
                this.ddxt2d_sub(1, fArray, bl);
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.inverse(fArray[i], bl);
                }
            }
            this.y_transform(fArray);
        } else {
            if (n > 1 && this.useThreads && this.rows >= n && this.columns >= n) {
                int n2;
                int n3;
                int n4;
                Future[] futureArray = new Future[n];
                int n5 = this.rows / n;
                for (n4 = 0; n4 < n; ++n4) {
                    n3 = n4 * n5;
                    n2 = n4 == n - 1 ? this.rows : n3 + n5;
                    futureArray[n4] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            for (int i = n3; i < n2; ++i) {
                                FloatDHT_2D.this.dhtColumns.inverse(fArray[i], bl);
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futureArray);
                n5 = this.columns / n;
                for (n4 = 0; n4 < n; ++n4) {
                    n3 = n4 * n5;
                    n2 = n4 == n - 1 ? this.columns : n3 + n5;
                    futureArray[n4] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            float[] fArray2 = new float[FloatDHT_2D.this.rows];
                            for (int i = n3; i < n2; ++i) {
                                int n;
                                for (n = 0; n < FloatDHT_2D.this.rows; ++n) {
                                    fArray2[n] = fArray[n][i];
                                }
                                FloatDHT_2D.this.dhtRows.inverse(fArray2, bl);
                                for (n = 0; n < FloatDHT_2D.this.rows; ++n) {
                                    fArray[n][i] = fArray2[n];
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futureArray);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.inverse(fArray[i], bl);
                }
                float[] fArray2 = new float[this.rows];
                for (int i = 0; i < this.columns; ++i) {
                    int n6;
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        fArray2[n6] = fArray[n6][i];
                    }
                    this.dhtRows.inverse(fArray2, bl);
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        fArray[n6][i] = fArray2[n6];
                    }
                }
            }
            this.y_transform(fArray);
        }
    }

    private void ddxt2d_subth(final int n, final float[] fArray, final boolean bl) {
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        int n3 = 4 * this.rows;
        if (this.columns == 2 * n2) {
            n3 >>= 1;
        } else if (this.columns < 2 * n2) {
            n2 = this.columns;
            n3 >>= 2;
        }
        final int n4 = n2;
        Future[] futureArray = new Future[n4];
        for (int i = 0; i < n4; ++i) {
            final int n5 = i;
            final int n6 = n3 * i;
            futureArray[i] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                public void run() {
                    block17: {
                        int n11;
                        block18: {
                            int n2;
                            int n3;
                            int n42;
                            block16: {
                                if (FloatDHT_2D.this.columns <= 2 * n4) break block16;
                                if (n == -1) {
                                    for (int i = 4 * n5; i < FloatDHT_2D.this.columns; i += 4 * n4) {
                                        int n52;
                                        int n62;
                                        int n7;
                                        for (n7 = 0; n7 < FloatDHT_2D.this.rows; ++n7) {
                                            n62 = n7 * FloatDHT_2D.this.columns + i;
                                            n52 = n6 + FloatDHT_2D.this.rows + n7;
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[n6 + n7] = fArray[n62];
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[n52] = fArray[n62 + 1];
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[n52 + ((FloatDHT_2D)FloatDHT_2D.this).rows] = fArray[n62 + 2];
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[n52 + 2 * ((FloatDHT_2D)FloatDHT_2D.this).rows] = fArray[n62 + 3];
                                        }
                                        FloatDHT_2D.this.dhtRows.forward(FloatDHT_2D.this.t, n6);
                                        FloatDHT_2D.this.dhtRows.forward(FloatDHT_2D.this.t, n6 + FloatDHT_2D.this.rows);
                                        FloatDHT_2D.this.dhtRows.forward(FloatDHT_2D.this.t, n6 + 2 * FloatDHT_2D.this.rows);
                                        FloatDHT_2D.this.dhtRows.forward(FloatDHT_2D.this.t, n6 + 3 * FloatDHT_2D.this.rows);
                                        for (n7 = 0; n7 < FloatDHT_2D.this.rows; ++n7) {
                                            n62 = n7 * FloatDHT_2D.this.columns + i;
                                            n52 = n6 + FloatDHT_2D.this.rows + n7;
                                            fArray[n62] = FloatDHT_2D.this.t[n6 + n7];
                                            fArray[n62 + 1] = FloatDHT_2D.this.t[n52];
                                            fArray[n62 + 2] = FloatDHT_2D.this.t[n52 + FloatDHT_2D.this.rows];
                                            fArray[n62 + 3] = FloatDHT_2D.this.t[n52 + 2 * FloatDHT_2D.this.rows];
                                        }
                                    }
                                } else {
                                    for (int i = 4 * n5; i < FloatDHT_2D.this.columns; i += 4 * n4) {
                                        int n8;
                                        int n9;
                                        int n10;
                                        for (n10 = 0; n10 < FloatDHT_2D.this.rows; ++n10) {
                                            n9 = n10 * FloatDHT_2D.this.columns + i;
                                            n8 = n6 + FloatDHT_2D.this.rows + n10;
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[n6 + n10] = fArray[n9];
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[n8] = fArray[n9 + 1];
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[n8 + ((FloatDHT_2D)FloatDHT_2D.this).rows] = fArray[n9 + 2];
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[n8 + 2 * ((FloatDHT_2D)FloatDHT_2D.this).rows] = fArray[n9 + 3];
                                        }
                                        FloatDHT_2D.this.dhtRows.inverse(FloatDHT_2D.this.t, n6, bl);
                                        FloatDHT_2D.this.dhtRows.inverse(FloatDHT_2D.this.t, n6 + FloatDHT_2D.this.rows, bl);
                                        FloatDHT_2D.this.dhtRows.inverse(FloatDHT_2D.this.t, n6 + 2 * FloatDHT_2D.this.rows, bl);
                                        FloatDHT_2D.this.dhtRows.inverse(FloatDHT_2D.this.t, n6 + 3 * FloatDHT_2D.this.rows, bl);
                                        for (n10 = 0; n10 < FloatDHT_2D.this.rows; ++n10) {
                                            n9 = n10 * FloatDHT_2D.this.columns + i;
                                            n8 = n6 + FloatDHT_2D.this.rows + n10;
                                            fArray[n9] = FloatDHT_2D.this.t[n6 + n10];
                                            fArray[n9 + 1] = FloatDHT_2D.this.t[n8];
                                            fArray[n9 + 2] = FloatDHT_2D.this.t[n8 + FloatDHT_2D.this.rows];
                                            fArray[n9 + 3] = FloatDHT_2D.this.t[n8 + 2 * FloatDHT_2D.this.rows];
                                        }
                                    }
                                }
                                break block17;
                            }
                            if (FloatDHT_2D.this.columns != 2 * n4) break block18;
                            for (n42 = 0; n42 < FloatDHT_2D.this.rows; ++n42) {
                                n3 = n42 * FloatDHT_2D.this.columns + 2 * n5;
                                n2 = n6 + n42;
                                ((FloatDHT_2D)FloatDHT_2D.this).t[n2] = fArray[n3];
                                ((FloatDHT_2D)FloatDHT_2D.this).t[n2 + ((FloatDHT_2D)FloatDHT_2D.this).rows] = fArray[n3 + 1];
                            }
                            if (n == -1) {
                                FloatDHT_2D.this.dhtRows.forward(FloatDHT_2D.this.t, n6);
                                FloatDHT_2D.this.dhtRows.forward(FloatDHT_2D.this.t, n6 + FloatDHT_2D.this.rows);
                            } else {
                                FloatDHT_2D.this.dhtRows.inverse(FloatDHT_2D.this.t, n6, bl);
                                FloatDHT_2D.this.dhtRows.inverse(FloatDHT_2D.this.t, n6 + FloatDHT_2D.this.rows, bl);
                            }
                            for (n42 = 0; n42 < FloatDHT_2D.this.rows; ++n42) {
                                n3 = n42 * FloatDHT_2D.this.columns + 2 * n5;
                                n2 = n6 + n42;
                                fArray[n3] = FloatDHT_2D.this.t[n2];
                                fArray[n3 + 1] = FloatDHT_2D.this.t[n2 + FloatDHT_2D.this.rows];
                            }
                            break block17;
                        }
                        if (FloatDHT_2D.this.columns != n4) break block17;
                        for (n11 = 0; n11 < FloatDHT_2D.this.rows; ++n11) {
                            ((FloatDHT_2D)FloatDHT_2D.this).t[n6 + n11] = fArray[n11 * FloatDHT_2D.this.columns + n5];
                        }
                        if (n == -1) {
                            FloatDHT_2D.this.dhtRows.forward(FloatDHT_2D.this.t, n6);
                        } else {
                            FloatDHT_2D.this.dhtRows.inverse(FloatDHT_2D.this.t, n6, bl);
                        }
                        for (n11 = 0; n11 < FloatDHT_2D.this.rows; ++n11) {
                            fArray[n11 * ((FloatDHT_2D)FloatDHT_2D.this).columns + n5] = FloatDHT_2D.this.t[n6 + n11];
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion((Future[])futureArray);
    }

    private void ddxt2d_subth(final int n, final float[][] fArray, final boolean bl) {
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        int n3 = 4 * this.rows;
        if (this.columns == 2 * n2) {
            n3 >>= 1;
        } else if (this.columns < 2 * n2) {
            n2 = this.columns;
            n3 >>= 2;
        }
        final int n4 = n2;
        Future[] futureArray = new Future[n4];
        for (int i = 0; i < n4; ++i) {
            final int n5 = i;
            final int n6 = n3 * i;
            futureArray[i] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                public void run() {
                    block17: {
                        int n8;
                        block18: {
                            int n2;
                            int n3;
                            block16: {
                                if (FloatDHT_2D.this.columns <= 2 * n4) break block16;
                                if (n == -1) {
                                    for (int i = 4 * n5; i < FloatDHT_2D.this.columns; i += 4 * n4) {
                                        int n42;
                                        int n52;
                                        for (n52 = 0; n52 < FloatDHT_2D.this.rows; ++n52) {
                                            n42 = n6 + FloatDHT_2D.this.rows + n52;
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[n6 + n52] = fArray[n52][i];
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[n42] = fArray[n52][i + 1];
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[n42 + ((FloatDHT_2D)FloatDHT_2D.this).rows] = fArray[n52][i + 2];
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[n42 + 2 * ((FloatDHT_2D)FloatDHT_2D.this).rows] = fArray[n52][i + 3];
                                        }
                                        FloatDHT_2D.this.dhtRows.forward(FloatDHT_2D.this.t, n6);
                                        FloatDHT_2D.this.dhtRows.forward(FloatDHT_2D.this.t, n6 + FloatDHT_2D.this.rows);
                                        FloatDHT_2D.this.dhtRows.forward(FloatDHT_2D.this.t, n6 + 2 * FloatDHT_2D.this.rows);
                                        FloatDHT_2D.this.dhtRows.forward(FloatDHT_2D.this.t, n6 + 3 * FloatDHT_2D.this.rows);
                                        for (n52 = 0; n52 < FloatDHT_2D.this.rows; ++n52) {
                                            n42 = n6 + FloatDHT_2D.this.rows + n52;
                                            fArray[n52][i] = FloatDHT_2D.this.t[n6 + n52];
                                            fArray[n52][i + 1] = FloatDHT_2D.this.t[n42];
                                            fArray[n52][i + 2] = FloatDHT_2D.this.t[n42 + FloatDHT_2D.this.rows];
                                            fArray[n52][i + 3] = FloatDHT_2D.this.t[n42 + 2 * FloatDHT_2D.this.rows];
                                        }
                                    }
                                } else {
                                    for (int i = 4 * n5; i < FloatDHT_2D.this.columns; i += 4 * n4) {
                                        int n62;
                                        int n7;
                                        for (n7 = 0; n7 < FloatDHT_2D.this.rows; ++n7) {
                                            n62 = n6 + FloatDHT_2D.this.rows + n7;
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[n6 + n7] = fArray[n7][i];
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[n62] = fArray[n7][i + 1];
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[n62 + ((FloatDHT_2D)FloatDHT_2D.this).rows] = fArray[n7][i + 2];
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[n62 + 2 * ((FloatDHT_2D)FloatDHT_2D.this).rows] = fArray[n7][i + 3];
                                        }
                                        FloatDHT_2D.this.dhtRows.inverse(FloatDHT_2D.this.t, n6, bl);
                                        FloatDHT_2D.this.dhtRows.inverse(FloatDHT_2D.this.t, n6 + FloatDHT_2D.this.rows, bl);
                                        FloatDHT_2D.this.dhtRows.inverse(FloatDHT_2D.this.t, n6 + 2 * FloatDHT_2D.this.rows, bl);
                                        FloatDHT_2D.this.dhtRows.inverse(FloatDHT_2D.this.t, n6 + 3 * FloatDHT_2D.this.rows, bl);
                                        for (n7 = 0; n7 < FloatDHT_2D.this.rows; ++n7) {
                                            n62 = n6 + FloatDHT_2D.this.rows + n7;
                                            fArray[n7][i] = FloatDHT_2D.this.t[n6 + n7];
                                            fArray[n7][i + 1] = FloatDHT_2D.this.t[n62];
                                            fArray[n7][i + 2] = FloatDHT_2D.this.t[n62 + FloatDHT_2D.this.rows];
                                            fArray[n7][i + 3] = FloatDHT_2D.this.t[n62 + 2 * FloatDHT_2D.this.rows];
                                        }
                                    }
                                }
                                break block17;
                            }
                            if (FloatDHT_2D.this.columns != 2 * n4) break block18;
                            for (n3 = 0; n3 < FloatDHT_2D.this.rows; ++n3) {
                                n2 = n6 + n3;
                                ((FloatDHT_2D)FloatDHT_2D.this).t[n2] = fArray[n3][2 * n5];
                                ((FloatDHT_2D)FloatDHT_2D.this).t[n2 + ((FloatDHT_2D)FloatDHT_2D.this).rows] = fArray[n3][2 * n5 + 1];
                            }
                            if (n == -1) {
                                FloatDHT_2D.this.dhtRows.forward(FloatDHT_2D.this.t, n6);
                                FloatDHT_2D.this.dhtRows.forward(FloatDHT_2D.this.t, n6 + FloatDHT_2D.this.rows);
                            } else {
                                FloatDHT_2D.this.dhtRows.inverse(FloatDHT_2D.this.t, n6, bl);
                                FloatDHT_2D.this.dhtRows.inverse(FloatDHT_2D.this.t, n6 + FloatDHT_2D.this.rows, bl);
                            }
                            for (n3 = 0; n3 < FloatDHT_2D.this.rows; ++n3) {
                                n2 = n6 + n3;
                                fArray[n3][2 * n5] = FloatDHT_2D.this.t[n2];
                                fArray[n3][2 * n5 + 1] = FloatDHT_2D.this.t[n2 + FloatDHT_2D.this.rows];
                            }
                            break block17;
                        }
                        if (FloatDHT_2D.this.columns != n4) break block17;
                        for (n8 = 0; n8 < FloatDHT_2D.this.rows; ++n8) {
                            ((FloatDHT_2D)FloatDHT_2D.this).t[n6 + n8] = fArray[n8][n5];
                        }
                        if (n == -1) {
                            FloatDHT_2D.this.dhtRows.forward(FloatDHT_2D.this.t, n6);
                        } else {
                            FloatDHT_2D.this.dhtRows.inverse(FloatDHT_2D.this.t, n6, bl);
                        }
                        for (n8 = 0; n8 < FloatDHT_2D.this.rows; ++n8) {
                            fArray[n8][n5] = FloatDHT_2D.this.t[n6 + n8];
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion((Future[])futureArray);
    }

    private void ddxt2d0_subth(final int n, final float[] fArray, final boolean bl) {
        final int n2 = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final int n3 = i;
            futureArray[i] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                public void run() {
                    if (n == -1) {
                        for (int i = n3; i < FloatDHT_2D.this.rows; i += n2) {
                            FloatDHT_2D.this.dhtColumns.forward(fArray, i * FloatDHT_2D.this.columns);
                        }
                    } else {
                        for (int i = n3; i < FloatDHT_2D.this.rows; i += n2) {
                            FloatDHT_2D.this.dhtColumns.inverse(fArray, i * FloatDHT_2D.this.columns, bl);
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion((Future[])futureArray);
    }

    private void ddxt2d0_subth(final int n, final float[][] fArray, final boolean bl) {
        final int n2 = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final int n3 = i;
            futureArray[i] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                public void run() {
                    if (n == -1) {
                        for (int i = n3; i < FloatDHT_2D.this.rows; i += n2) {
                            FloatDHT_2D.this.dhtColumns.forward(fArray[i]);
                        }
                    } else {
                        for (int i = n3; i < FloatDHT_2D.this.rows; i += n2) {
                            FloatDHT_2D.this.dhtColumns.inverse(fArray[i], bl);
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion((Future[])futureArray);
    }

    private void ddxt2d_sub(int n, float[] fArray, boolean bl) {
        block13: {
            int n2;
            int n3;
            block12: {
                if (this.columns <= 2) break block12;
                if (n == -1) {
                    for (int i = 0; i < this.columns; i += 4) {
                        int n4;
                        int n5;
                        int n6;
                        for (n6 = 0; n6 < this.rows; ++n6) {
                            n5 = n6 * this.columns + i;
                            n4 = this.rows + n6;
                            this.t[n6] = fArray[n5];
                            this.t[n4] = fArray[n5 + 1];
                            this.t[n4 + this.rows] = fArray[n5 + 2];
                            this.t[n4 + 2 * this.rows] = fArray[n5 + 3];
                        }
                        this.dhtRows.forward(this.t, 0);
                        this.dhtRows.forward(this.t, this.rows);
                        this.dhtRows.forward(this.t, 2 * this.rows);
                        this.dhtRows.forward(this.t, 3 * this.rows);
                        for (n6 = 0; n6 < this.rows; ++n6) {
                            n5 = n6 * this.columns + i;
                            n4 = this.rows + n6;
                            fArray[n5] = this.t[n6];
                            fArray[n5 + 1] = this.t[n4];
                            fArray[n5 + 2] = this.t[n4 + this.rows];
                            fArray[n5 + 3] = this.t[n4 + 2 * this.rows];
                        }
                    }
                } else {
                    for (int i = 0; i < this.columns; i += 4) {
                        int n7;
                        int n8;
                        int n9;
                        for (n9 = 0; n9 < this.rows; ++n9) {
                            n8 = n9 * this.columns + i;
                            n7 = this.rows + n9;
                            this.t[n9] = fArray[n8];
                            this.t[n7] = fArray[n8 + 1];
                            this.t[n7 + this.rows] = fArray[n8 + 2];
                            this.t[n7 + 2 * this.rows] = fArray[n8 + 3];
                        }
                        this.dhtRows.inverse(this.t, 0, bl);
                        this.dhtRows.inverse(this.t, this.rows, bl);
                        this.dhtRows.inverse(this.t, 2 * this.rows, bl);
                        this.dhtRows.inverse(this.t, 3 * this.rows, bl);
                        for (n9 = 0; n9 < this.rows; ++n9) {
                            n8 = n9 * this.columns + i;
                            n7 = this.rows + n9;
                            fArray[n8] = this.t[n9];
                            fArray[n8 + 1] = this.t[n7];
                            fArray[n8 + 2] = this.t[n7 + this.rows];
                            fArray[n8 + 3] = this.t[n7 + 2 * this.rows];
                        }
                    }
                }
                break block13;
            }
            if (this.columns != 2) break block13;
            for (n3 = 0; n3 < this.rows; ++n3) {
                n2 = n3 * this.columns;
                this.t[n3] = fArray[n2];
                this.t[this.rows + n3] = fArray[n2 + 1];
            }
            if (n == -1) {
                this.dhtRows.forward(this.t, 0);
                this.dhtRows.forward(this.t, this.rows);
            } else {
                this.dhtRows.inverse(this.t, 0, bl);
                this.dhtRows.inverse(this.t, this.rows, bl);
            }
            for (n3 = 0; n3 < this.rows; ++n3) {
                n2 = n3 * this.columns;
                fArray[n2] = this.t[n3];
                fArray[n2 + 1] = this.t[this.rows + n3];
            }
        }
    }

    private void ddxt2d_sub(int n, float[][] fArray, boolean bl) {
        block13: {
            int n2;
            block12: {
                if (this.columns <= 2) break block12;
                if (n == -1) {
                    for (int i = 0; i < this.columns; i += 4) {
                        int n3;
                        int n4;
                        for (n4 = 0; n4 < this.rows; ++n4) {
                            n3 = this.rows + n4;
                            this.t[n4] = fArray[n4][i];
                            this.t[n3] = fArray[n4][i + 1];
                            this.t[n3 + this.rows] = fArray[n4][i + 2];
                            this.t[n3 + 2 * this.rows] = fArray[n4][i + 3];
                        }
                        this.dhtRows.forward(this.t, 0);
                        this.dhtRows.forward(this.t, this.rows);
                        this.dhtRows.forward(this.t, 2 * this.rows);
                        this.dhtRows.forward(this.t, 3 * this.rows);
                        for (n4 = 0; n4 < this.rows; ++n4) {
                            n3 = this.rows + n4;
                            fArray[n4][i] = this.t[n4];
                            fArray[n4][i + 1] = this.t[n3];
                            fArray[n4][i + 2] = this.t[n3 + this.rows];
                            fArray[n4][i + 3] = this.t[n3 + 2 * this.rows];
                        }
                    }
                } else {
                    for (int i = 0; i < this.columns; i += 4) {
                        int n5;
                        int n6;
                        for (n6 = 0; n6 < this.rows; ++n6) {
                            n5 = this.rows + n6;
                            this.t[n6] = fArray[n6][i];
                            this.t[n5] = fArray[n6][i + 1];
                            this.t[n5 + this.rows] = fArray[n6][i + 2];
                            this.t[n5 + 2 * this.rows] = fArray[n6][i + 3];
                        }
                        this.dhtRows.inverse(this.t, 0, bl);
                        this.dhtRows.inverse(this.t, this.rows, bl);
                        this.dhtRows.inverse(this.t, 2 * this.rows, bl);
                        this.dhtRows.inverse(this.t, 3 * this.rows, bl);
                        for (n6 = 0; n6 < this.rows; ++n6) {
                            n5 = this.rows + n6;
                            fArray[n6][i] = this.t[n6];
                            fArray[n6][i + 1] = this.t[n5];
                            fArray[n6][i + 2] = this.t[n5 + this.rows];
                            fArray[n6][i + 3] = this.t[n5 + 2 * this.rows];
                        }
                    }
                }
                break block13;
            }
            if (this.columns != 2) break block13;
            for (n2 = 0; n2 < this.rows; ++n2) {
                this.t[n2] = fArray[n2][0];
                this.t[this.rows + n2] = fArray[n2][1];
            }
            if (n == -1) {
                this.dhtRows.forward(this.t, 0);
                this.dhtRows.forward(this.t, this.rows);
            } else {
                this.dhtRows.inverse(this.t, 0, bl);
                this.dhtRows.inverse(this.t, this.rows, bl);
            }
            for (n2 = 0; n2 < this.rows; ++n2) {
                fArray[n2][0] = this.t[n2];
                fArray[n2][1] = this.t[this.rows + n2];
            }
        }
    }

    private void yTransform(float[] fArray) {
        for (int i = 0; i <= this.rows / 2; ++i) {
            int n = (this.rows - i) % this.rows;
            int n2 = i * this.columns;
            int n3 = n * this.columns;
            for (int j = 0; j <= this.columns / 2; ++j) {
                int n4 = (this.columns - j) % this.columns;
                float f = fArray[n2 + j];
                float f2 = fArray[n3 + j];
                float f3 = fArray[n2 + n4];
                float f4 = fArray[n3 + n4];
                float f5 = (f + f4 - (f2 + f3)) / 2.0f;
                fArray[n2 + j] = f - f5;
                fArray[n3 + j] = f2 + f5;
                fArray[n2 + n4] = f3 + f5;
                fArray[n3 + n4] = f4 - f5;
            }
        }
    }

    private void y_transform(float[][] fArray) {
        for (int i = 0; i <= this.rows / 2; ++i) {
            int n = (this.rows - i) % this.rows;
            for (int j = 0; j <= this.columns / 2; ++j) {
                int n2 = (this.columns - j) % this.columns;
                float f = fArray[i][j];
                float f2 = fArray[n][j];
                float f3 = fArray[i][n2];
                float f4 = fArray[n][n2];
                float f5 = (f + f4 - (f2 + f3)) / 2.0f;
                fArray[i][j] = f - f5;
                fArray[n][j] = f2 + f5;
                fArray[i][n2] = f3 + f5;
                fArray[n][n2] = f4 - f5;
            }
        }
    }
}

