/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dht;

import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class DoubleDHT_1D {
    private int n;
    private DoubleFFT_1D fft;

    public DoubleDHT_1D(int n) {
        this.n = n;
        this.fft = new DoubleFFT_1D(n);
    }

    public void forward(double[] dArray) {
        this.forward(dArray, 0);
    }

    public void forward(final double[] dArray, final int n) {
        if (this.n == 1) {
            return;
        }
        this.fft.realForward(dArray, n);
        final double[] dArray2 = new double[this.n];
        System.arraycopy(dArray, n, dArray2, 0, this.n);
        int n2 = this.n / 2;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && n2 > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            n3 = 2;
            int n4 = n2 / n3;
            Future[] futureArray = new Future[n3];
            for (int i = 0; i < n3; ++i) {
                final int n5 = 1 + i * n4;
                final int n6 = i == n3 - 1 ? n2 : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        for (int i = n5; i < n6; ++i) {
                            int n3 = 2 * i;
                            int n2 = n3 + 1;
                            dArray[n + i] = dArray2[n3] - dArray2[n2];
                            dArray[n + ((DoubleDHT_1D)DoubleDHT_1D.this).n - i] = dArray2[n3] + dArray2[n2];
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futureArray);
        } else {
            for (int i = 1; i < n2; ++i) {
                int n7 = 2 * i;
                int n8 = n7 + 1;
                dArray[n + i] = dArray2[n7] - dArray2[n8];
                dArray[n + this.n - i] = dArray2[n7] + dArray2[n8];
            }
        }
        if (this.n % 2 == 0) {
            dArray[n + n2] = dArray2[1];
        } else {
            dArray[n + n2] = dArray2[this.n - 1] - dArray2[1];
            dArray[n + n2 + 1] = dArray2[this.n - 1] + dArray2[1];
        }
    }

    public void inverse(double[] dArray, boolean bl) {
        this.inverse(dArray, 0, bl);
    }

    public void inverse(double[] dArray, int n, boolean bl) {
        if (this.n == 1) {
            return;
        }
        this.forward(dArray, n);
        if (bl) {
            this.scale(this.n, dArray, n);
        }
    }

    private void scale(double d, final double[] dArray, int n) {
        final double d2 = 1.0 / d;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.n >= ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            n2 = 2;
            int n3 = this.n / n2;
            Future[] futureArray = new Future[n2];
            for (int i = 0; i < n2; ++i) {
                final int n4 = n + i * n3;
                final int n5 = i == n2 - 1 ? n + this.n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        int n = n4;
                        while (n < n5) {
                            int n2 = n++;
                            dArray[n2] = dArray[n2] * d2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futureArray);
        } else {
            int n6 = n + this.n;
            int n7 = n;
            while (n7 < n6) {
                int n8 = n7++;
                dArray[n8] = dArray[n8] * d2;
            }
        }
    }
}

