/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dct;

import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class DoubleDCT_1D {
    private int n;
    private int[] ip;
    private double[] w;
    private int nw;
    private int nc;
    private boolean isPowerOfTwo = false;
    private DoubleFFT_1D fft;
    private static final double PI = Math.PI;

    public DoubleDCT_1D(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("n must be greater than 0");
        }
        this.n = n;
        if (ConcurrencyUtils.isPowerOf2((int)n)) {
            this.isPowerOfTwo = true;
            this.ip = new int[(int)Math.ceil(2 + (1 << (int)(Math.log((double)(n / 2) + 0.5) / Math.log(2.0)) / 2))];
            this.w = new double[n * 5 / 4];
            this.nw = this.ip[0];
            if (n > this.nw << 2) {
                this.nw = n >> 2;
                this.makewt(this.nw);
            }
            this.nc = this.ip[1];
            if (n > this.nc) {
                this.nc = n;
                this.makect(this.nc, this.w, this.nw);
            }
        } else {
            this.w = this.makect(n);
            this.fft = new DoubleFFT_1D(2 * n);
        }
    }

    public void forward(double[] dArray, boolean bl) {
        this.forward(dArray, 0, bl);
    }

    public void forward(final double[] dArray, final int n, boolean bl) {
        if (this.n == 1) {
            return;
        }
        if (this.isPowerOfTwo) {
            double d = dArray[n + this.n - 1];
            for (int i = this.n - 2; i >= 2; i -= 2) {
                dArray[n + i + 1] = dArray[n + i] - dArray[n + i - 1];
                int n2 = n + i;
                dArray[n2] = dArray[n2] + dArray[n + i - 1];
            }
            dArray[n + 1] = dArray[n] - d;
            int n3 = n;
            dArray[n3] = dArray[n3] + d;
            if (this.n > 4) {
                this.rftbsub(this.n, dArray, n, this.nc, this.w, this.nw);
                this.cftbsub(this.n, dArray, n, this.ip, this.nw, this.w);
            } else if (this.n == 4) {
                this.cftbsub(this.n, dArray, n, this.ip, this.nw, this.w);
            }
            this.dctsub(this.n, dArray, n, this.nc, this.w, this.nw);
            if (bl) {
                this.scale(Math.sqrt(2.0 / (double)this.n), dArray, n);
                dArray[n] = dArray[n] / Math.sqrt(2.0);
            }
        } else {
            int n4;
            int n5 = 2 * this.n;
            final double[] dArray2 = new double[n5];
            System.arraycopy(dArray, n, dArray2, 0, this.n);
            int n6 = ConcurrencyUtils.getNumberOfThreads();
            for (n4 = this.n; n4 < n5; ++n4) {
                dArray2[n4] = dArray2[n5 - n4 - 1];
            }
            this.fft.realForward(dArray2);
            if (n6 > 1 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                n6 = 2;
                n4 = this.n / n6;
                Future[] futureArray = new Future[n6];
                for (int i = 0; i < n6; ++i) {
                    final int n7 = i * n4;
                    final int n8 = i == n6 - 1 ? this.n : n7 + n4;
                    futureArray[i] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            for (int i = n7; i < n8; ++i) {
                                int n3 = 2 * i;
                                int n2 = n + i;
                                dArray[n2] = DoubleDCT_1D.this.w[n3] * dArray2[n3] - DoubleDCT_1D.this.w[n3 + 1] * dArray2[n3 + 1];
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futureArray);
            } else {
                for (n4 = 0; n4 < this.n; ++n4) {
                    int n9 = 2 * n4;
                    int n10 = n + n4;
                    dArray[n10] = this.w[n9] * dArray2[n9] - this.w[n9 + 1] * dArray2[n9 + 1];
                }
            }
            if (bl) {
                this.scale(1.0 / Math.sqrt(n5), dArray, n);
                dArray[n] = dArray[n] / Math.sqrt(2.0);
            }
        }
    }

    public void inverse(double[] dArray, boolean bl) {
        this.inverse(dArray, 0, bl);
    }

    public void inverse(final double[] dArray, final int n, boolean bl) {
        if (this.n == 1) {
            return;
        }
        if (this.isPowerOfTwo) {
            if (bl) {
                this.scale(Math.sqrt(2.0 / (double)this.n), dArray, n);
                dArray[n] = dArray[n] / Math.sqrt(2.0);
            }
            this.dctsub(this.n, dArray, n, this.nc, this.w, this.nw);
            if (this.n > 4) {
                this.cftfsub(this.n, dArray, n, this.ip, this.nw, this.w);
                this.rftfsub(this.n, dArray, n, this.nc, this.w, this.nw);
            } else if (this.n == 4) {
                this.cftfsub(this.n, dArray, n, this.ip, this.nw, this.w);
            }
            double d = dArray[n] - dArray[n + 1];
            int n2 = n;
            dArray[n2] = dArray[n2] + dArray[n + 1];
            for (int i = 2; i < this.n; i += 2) {
                dArray[n + i - 1] = dArray[n + i] - dArray[n + i + 1];
                int n3 = n + i;
                dArray[n3] = dArray[n3] + dArray[n + i + 1];
            }
            dArray[n + this.n - 1] = d;
        } else {
            int n4 = 2 * this.n;
            if (bl) {
                this.scale(Math.sqrt(n4), dArray, n);
                dArray[n] = dArray[n] * Math.sqrt(2.0);
            }
            final double[] dArray2 = new double[n4];
            int n5 = ConcurrencyUtils.getNumberOfThreads();
            if (n5 > 1 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                n5 = 2;
                int n6 = this.n / n5;
                Future[] futureArray = new Future[n5];
                for (int i = 0; i < n5; ++i) {
                    final int n7 = i * n6;
                    final int n8 = i == n5 - 1 ? this.n : n7 + n6;
                    futureArray[i] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            for (int i = n7; i < n8; ++i) {
                                int n2 = 2 * i;
                                double d = dArray[n + i];
                                dArray2[n2] = DoubleDCT_1D.this.w[n2] * d;
                                dArray2[n2 + 1] = -DoubleDCT_1D.this.w[n2 + 1] * d;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futureArray);
            } else {
                for (int i = 0; i < this.n; ++i) {
                    int n9 = 2 * i;
                    double d = dArray[n + i];
                    dArray2[n9] = this.w[n9] * d;
                    dArray2[n9 + 1] = -this.w[n9 + 1] * d;
                }
            }
            this.fft.realInverse(dArray2, true);
            System.arraycopy(dArray2, 0, dArray, n, this.n);
        }
    }

    private double[] makect(int n) {
        int n2 = 2 * n;
        double d = Math.PI / (double)n2;
        double[] dArray = new double[n2];
        dArray[0] = 1.0;
        for (int i = 1; i < n; ++i) {
            int n3 = 2 * i;
            double d2 = d * (double)i;
            dArray[n3] = Math.cos(d2);
            dArray[n3 + 1] = -Math.sin(d2);
        }
        return dArray;
    }

    private void makewt(int n) {
        this.ip[0] = n;
        this.ip[1] = 1;
        if (n > 2) {
            int n2;
            int n3 = n >> 1;
            double d = 0.7853981633974483 / (double)n3;
            double d2 = d * 2.0;
            double d3 = Math.cos(d * (double)n3);
            this.w[0] = 1.0;
            this.w[1] = d3;
            if (n3 == 4) {
                this.w[2] = Math.cos(d2);
                this.w[3] = Math.sin(d2);
            } else if (n3 > 4) {
                this.makeipt(n);
                this.w[2] = 0.5 / Math.cos(d2);
                this.w[3] = 0.5 / Math.cos(d * 6.0);
                for (n2 = 4; n2 < n3; n2 += 4) {
                    double d4 = d * (double)n2;
                    double d5 = 3.0 * d4;
                    this.w[n2] = Math.cos(d4);
                    this.w[n2 + 1] = Math.sin(d4);
                    this.w[n2 + 2] = Math.cos(d5);
                    this.w[n2 + 3] = -Math.sin(d5);
                }
            }
            int n4 = 0;
            while (n3 > 2) {
                double d6;
                double d7;
                int n5 = n4 + n3;
                this.w[n5] = 1.0;
                this.w[n5 + 1] = d3;
                if ((n3 >>= 1) == 4) {
                    d7 = this.w[n4 + 4];
                    d6 = this.w[n4 + 5];
                    this.w[n5 + 2] = d7;
                    this.w[n5 + 3] = d6;
                } else if (n3 > 4) {
                    d7 = this.w[n4 + 4];
                    double d8 = this.w[n4 + 6];
                    this.w[n5 + 2] = 0.5 / d7;
                    this.w[n5 + 3] = 0.5 / d8;
                    for (n2 = 4; n2 < n3; n2 += 4) {
                        int n6 = n4 + 2 * n2;
                        int n7 = n5 + n2;
                        d7 = this.w[n6];
                        d6 = this.w[n6 + 1];
                        d8 = this.w[n6 + 2];
                        double d9 = this.w[n6 + 3];
                        this.w[n7] = d7;
                        this.w[n7 + 1] = d6;
                        this.w[n7 + 2] = d8;
                        this.w[n7 + 3] = d9;
                    }
                }
                n4 = n5;
            }
        }
    }

    private void makeipt(int n) {
        this.ip[2] = 0;
        this.ip[3] = 16;
        int n2 = 2;
        for (int i = n; i > 32; i >>= 2) {
            int n3 = n2 << 1;
            int n4 = n3 << 3;
            for (int j = n2; j < n3; ++j) {
                int n5;
                this.ip[n2 + j] = n5 = this.ip[j] << 2;
                this.ip[n3 + j] = n5 + n4;
            }
            n2 = n3;
        }
    }

    private void makect(int n, double[] dArray, int n2) {
        this.ip[1] = n;
        if (n > 1) {
            int n3 = n >> 1;
            double d = 0.7853981633974483 / (double)n3;
            dArray[n2] = Math.cos(d * (double)n3);
            dArray[n2 + n3] = 0.5 * dArray[n2];
            for (int i = 1; i < n3; ++i) {
                double d2 = d * (double)i;
                dArray[n2 + i] = 0.5 * Math.cos(d2);
                dArray[n2 + n - i] = 0.5 * Math.sin(d2);
            }
        }
    }

    private void cftfsub(int n, double[] dArray, int n2, int[] nArray, int n3, double[] dArray2) {
        if (n > 8) {
            if (n > 32) {
                this.cftf1st(n, dArray, n2, dArray2, n3 - (n >> 2));
                if (ConcurrencyUtils.getNumberOfThreads() > 1 && n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                    this.cftrec4_th(n, dArray, n2, n3, dArray2);
                } else if (n > 512) {
                    this.cftrec4(n, dArray, n2, n3, dArray2);
                } else if (n > 128) {
                    this.cftleaf(n, 1, dArray, n2, n3, dArray2);
                } else {
                    this.cftfx41(n, dArray, n2, n3, dArray2);
                }
                this.bitrv2(n, nArray, dArray, n2);
            } else if (n == 32) {
                this.cftf161(dArray, n2, dArray2, n3 - 8);
                this.bitrv216(dArray, n2);
            } else {
                this.cftf081(dArray, n2, dArray2, 0);
                this.bitrv208(dArray, n2);
            }
        } else if (n == 8) {
            this.cftf040(dArray, n2);
        } else if (n == 4) {
            this.cftx020(dArray, n2);
        }
    }

    private void cftbsub(int n, double[] dArray, int n2, int[] nArray, int n3, double[] dArray2) {
        if (n > 8) {
            if (n > 32) {
                this.cftb1st(n, dArray, n2, dArray2, n3 - (n >> 2));
                if (ConcurrencyUtils.getNumberOfThreads() > 1 && n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                    this.cftrec4_th(n, dArray, n2, n3, dArray2);
                } else if (n > 512) {
                    this.cftrec4(n, dArray, n2, n3, dArray2);
                } else if (n > 128) {
                    this.cftleaf(n, 1, dArray, n2, n3, dArray2);
                } else {
                    this.cftfx41(n, dArray, n2, n3, dArray2);
                }
                this.bitrv2conj(n, nArray, dArray, n2);
            } else if (n == 32) {
                this.cftf161(dArray, n2, dArray2, n3 - 8);
                this.bitrv216neg(dArray, n2);
            } else {
                this.cftf081(dArray, n2, dArray2, 0);
                this.bitrv208neg(dArray, n2);
            }
        } else if (n == 8) {
            this.cftb040(dArray, n2);
        } else if (n == 4) {
            this.cftx020(dArray, n2);
        }
    }

    private void bitrv2(int n, int[] nArray, double[] dArray, int n2) {
        int n3;
        int n4 = 1;
        for (n3 = n >> 2; n3 > 8; n3 >>= 2) {
            n4 <<= 1;
        }
        int n5 = n >> 1;
        int n6 = 4 * n4;
        if (n3 == 8) {
            for (int i = 0; i < n4; ++i) {
                double d;
                double d2;
                double d3;
                double d4;
                int n7;
                int n8;
                int n9;
                int n10;
                for (int j = 0; j < i; ++j) {
                    n10 = 4 * j + 2 * nArray[n4 + i];
                    n9 = 4 * i + 2 * nArray[n4 + j];
                    n8 = n2 + n10;
                    n7 = n2 + n9;
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 -= n6);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n5);
                    n7 = n2 + (n9 += 2);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 += n6);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += 2);
                    n7 = n2 + (n9 += n5);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 -= n6);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n5);
                    n7 = n2 + (n9 -= 2);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 += n6);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                }
                n9 = 4 * i + 2 * nArray[n4 + i];
                n10 = n9 + 2;
                n8 = n2 + n10;
                n7 = n2 + (n9 += n5);
                d4 = dArray[n8];
                d3 = dArray[n8 + 1];
                d2 = dArray[n7];
                d = dArray[n7 + 1];
                dArray[n8] = d2;
                dArray[n8 + 1] = d;
                dArray[n7] = d4;
                dArray[n7 + 1] = d3;
                n8 = n2 + (n10 += n6);
                n7 = n2 + (n9 += 2 * n6);
                d4 = dArray[n8];
                d3 = dArray[n8 + 1];
                d2 = dArray[n7];
                d = dArray[n7 + 1];
                dArray[n8] = d2;
                dArray[n8 + 1] = d;
                dArray[n7] = d4;
                dArray[n7 + 1] = d3;
                n8 = n2 + (n10 += n6);
                n7 = n2 + (n9 -= n6);
                d4 = dArray[n8];
                d3 = dArray[n8 + 1];
                d2 = dArray[n7];
                d = dArray[n7 + 1];
                dArray[n8] = d2;
                dArray[n8 + 1] = d;
                dArray[n7] = d4;
                dArray[n7 + 1] = d3;
                n8 = n2 + (n10 -= 2);
                n7 = n2 + (n9 -= n5);
                d4 = dArray[n8];
                d3 = dArray[n8 + 1];
                d2 = dArray[n7];
                d = dArray[n7 + 1];
                dArray[n8] = d2;
                dArray[n8 + 1] = d;
                dArray[n7] = d4;
                dArray[n7 + 1] = d3;
                n8 = n2 + (n10 += n5 + 2);
                n7 = n2 + (n9 += n5 + 2);
                d4 = dArray[n8];
                d3 = dArray[n8 + 1];
                d2 = dArray[n7];
                d = dArray[n7 + 1];
                dArray[n8] = d2;
                dArray[n8 + 1] = d;
                dArray[n7] = d4;
                dArray[n7 + 1] = d3;
                n8 = n2 + (n10 -= n5 - n6);
                n7 = n2 + (n9 += 2 * n6 - 2);
                d4 = dArray[n8];
                d3 = dArray[n8 + 1];
                d2 = dArray[n7];
                d = dArray[n7 + 1];
                dArray[n8] = d2;
                dArray[n8 + 1] = d;
                dArray[n7] = d4;
                dArray[n7 + 1] = d3;
            }
        } else {
            for (int i = 0; i < n4; ++i) {
                double d;
                double d5;
                double d6;
                double d7;
                int n11;
                int n12;
                int n13;
                int n14;
                for (int j = 0; j < i; ++j) {
                    n14 = 4 * j + nArray[n4 + i];
                    n13 = 4 * i + nArray[n4 + j];
                    n12 = n2 + n14;
                    n11 = n2 + n13;
                    d7 = dArray[n12];
                    d6 = dArray[n12 + 1];
                    d5 = dArray[n11];
                    d = dArray[n11 + 1];
                    dArray[n12] = d5;
                    dArray[n12 + 1] = d;
                    dArray[n11] = d7;
                    dArray[n11 + 1] = d6;
                    n12 = n2 + (n14 += n6);
                    n11 = n2 + (n13 += n6);
                    d7 = dArray[n12];
                    d6 = dArray[n12 + 1];
                    d5 = dArray[n11];
                    d = dArray[n11 + 1];
                    dArray[n12] = d5;
                    dArray[n12 + 1] = d;
                    dArray[n11] = d7;
                    dArray[n11 + 1] = d6;
                    n12 = n2 + (n14 += n5);
                    n11 = n2 + (n13 += 2);
                    d7 = dArray[n12];
                    d6 = dArray[n12 + 1];
                    d5 = dArray[n11];
                    d = dArray[n11 + 1];
                    dArray[n12] = d5;
                    dArray[n12 + 1] = d;
                    dArray[n11] = d7;
                    dArray[n11 + 1] = d6;
                    n12 = n2 + (n14 -= n6);
                    n11 = n2 + (n13 -= n6);
                    d7 = dArray[n12];
                    d6 = dArray[n12 + 1];
                    d5 = dArray[n11];
                    d = dArray[n11 + 1];
                    dArray[n12] = d5;
                    dArray[n12 + 1] = d;
                    dArray[n11] = d7;
                    dArray[n11 + 1] = d6;
                    n12 = n2 + (n14 += 2);
                    n11 = n2 + (n13 += n5);
                    d7 = dArray[n12];
                    d6 = dArray[n12 + 1];
                    d5 = dArray[n11];
                    d = dArray[n11 + 1];
                    dArray[n12] = d5;
                    dArray[n12 + 1] = d;
                    dArray[n11] = d7;
                    dArray[n11 + 1] = d6;
                    n12 = n2 + (n14 += n6);
                    n11 = n2 + (n13 += n6);
                    d7 = dArray[n12];
                    d6 = dArray[n12 + 1];
                    d5 = dArray[n11];
                    d = dArray[n11 + 1];
                    dArray[n12] = d5;
                    dArray[n12 + 1] = d;
                    dArray[n11] = d7;
                    dArray[n11 + 1] = d6;
                    n12 = n2 + (n14 -= n5);
                    n11 = n2 + (n13 -= 2);
                    d7 = dArray[n12];
                    d6 = dArray[n12 + 1];
                    d5 = dArray[n11];
                    d = dArray[n11 + 1];
                    dArray[n12] = d5;
                    dArray[n12 + 1] = d;
                    dArray[n11] = d7;
                    dArray[n11 + 1] = d6;
                    n12 = n2 + (n14 -= n6);
                    n11 = n2 + (n13 -= n6);
                    d7 = dArray[n12];
                    d6 = dArray[n12 + 1];
                    d5 = dArray[n11];
                    d = dArray[n11 + 1];
                    dArray[n12] = d5;
                    dArray[n12 + 1] = d;
                    dArray[n11] = d7;
                    dArray[n11 + 1] = d6;
                }
                n13 = 4 * i + nArray[n4 + i];
                n14 = n13 + 2;
                n12 = n2 + n14;
                n11 = n2 + (n13 += n5);
                d7 = dArray[n12];
                d6 = dArray[n12 + 1];
                d5 = dArray[n11];
                d = dArray[n11 + 1];
                dArray[n12] = d5;
                dArray[n12 + 1] = d;
                dArray[n11] = d7;
                dArray[n11 + 1] = d6;
                n12 = n2 + (n14 += n6);
                n11 = n2 + (n13 += n6);
                d7 = dArray[n12];
                d6 = dArray[n12 + 1];
                d5 = dArray[n11];
                d = dArray[n11 + 1];
                dArray[n12] = d5;
                dArray[n12 + 1] = d;
                dArray[n11] = d7;
                dArray[n11 + 1] = d6;
            }
        }
    }

    private void bitrv2conj(int n, int[] nArray, double[] dArray, int n2) {
        int n3;
        int n4 = 1;
        for (n3 = n >> 2; n3 > 8; n3 >>= 2) {
            n4 <<= 1;
        }
        int n5 = n >> 1;
        int n6 = 4 * n4;
        if (n3 == 8) {
            for (int i = 0; i < n4; ++i) {
                double d;
                double d2;
                double d3;
                double d4;
                int n7;
                int n8;
                int n9;
                int n10;
                for (int j = 0; j < i; ++j) {
                    n10 = 4 * j + 2 * nArray[n4 + i];
                    n9 = 4 * i + 2 * nArray[n4 + j];
                    n8 = n2 + n10;
                    n7 = n2 + n9;
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 -= n6);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n5);
                    n7 = n2 + (n9 += 2);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 += n6);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += 2);
                    n7 = n2 + (n9 += n5);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 -= n6);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n5);
                    n7 = n2 + (n9 -= 2);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 += n6);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                }
                n9 = 4 * i + 2 * nArray[n4 + i];
                n10 = n9 + 2;
                n8 = n2 + n10;
                n7 = n2 + (n9 += n5);
                dArray[n8 - 1] = -dArray[n8 - 1];
                d4 = dArray[n8];
                d3 = -dArray[n8 + 1];
                d2 = dArray[n7];
                d = -dArray[n7 + 1];
                dArray[n8] = d2;
                dArray[n8 + 1] = d;
                dArray[n7] = d4;
                dArray[n7 + 1] = d3;
                dArray[n7 + 3] = -dArray[n7 + 3];
                n8 = n2 + (n10 += n6);
                n7 = n2 + (n9 += 2 * n6);
                d4 = dArray[n8];
                d3 = -dArray[n8 + 1];
                d2 = dArray[n7];
                d = -dArray[n7 + 1];
                dArray[n8] = d2;
                dArray[n8 + 1] = d;
                dArray[n7] = d4;
                dArray[n7 + 1] = d3;
                n8 = n2 + (n10 += n6);
                n7 = n2 + (n9 -= n6);
                d4 = dArray[n8];
                d3 = -dArray[n8 + 1];
                d2 = dArray[n7];
                d = -dArray[n7 + 1];
                dArray[n8] = d2;
                dArray[n8 + 1] = d;
                dArray[n7] = d4;
                dArray[n7 + 1] = d3;
                n8 = n2 + (n10 -= 2);
                n7 = n2 + (n9 -= n5);
                d4 = dArray[n8];
                d3 = -dArray[n8 + 1];
                d2 = dArray[n7];
                d = -dArray[n7 + 1];
                dArray[n8] = d2;
                dArray[n8 + 1] = d;
                dArray[n7] = d4;
                dArray[n7 + 1] = d3;
                n8 = n2 + (n10 += n5 + 2);
                n7 = n2 + (n9 += n5 + 2);
                d4 = dArray[n8];
                d3 = -dArray[n8 + 1];
                d2 = dArray[n7];
                d = -dArray[n7 + 1];
                dArray[n8] = d2;
                dArray[n8 + 1] = d;
                dArray[n7] = d4;
                dArray[n7 + 1] = d3;
                n8 = n2 + (n10 -= n5 - n6);
                n7 = n2 + (n9 += 2 * n6 - 2);
                dArray[n8 - 1] = -dArray[n8 - 1];
                d4 = dArray[n8];
                d3 = -dArray[n8 + 1];
                d2 = dArray[n7];
                d = -dArray[n7 + 1];
                dArray[n8] = d2;
                dArray[n8 + 1] = d;
                dArray[n7] = d4;
                dArray[n7 + 1] = d3;
                dArray[n7 + 3] = -dArray[n7 + 3];
            }
        } else {
            for (int i = 0; i < n4; ++i) {
                double d;
                double d5;
                double d6;
                double d7;
                int n11;
                int n12;
                int n13;
                int n14;
                for (int j = 0; j < i; ++j) {
                    n14 = 4 * j + nArray[n4 + i];
                    n13 = 4 * i + nArray[n4 + j];
                    n12 = n2 + n14;
                    n11 = n2 + n13;
                    d7 = dArray[n12];
                    d6 = -dArray[n12 + 1];
                    d5 = dArray[n11];
                    d = -dArray[n11 + 1];
                    dArray[n12] = d5;
                    dArray[n12 + 1] = d;
                    dArray[n11] = d7;
                    dArray[n11 + 1] = d6;
                    n12 = n2 + (n14 += n6);
                    n11 = n2 + (n13 += n6);
                    d7 = dArray[n12];
                    d6 = -dArray[n12 + 1];
                    d5 = dArray[n11];
                    d = -dArray[n11 + 1];
                    dArray[n12] = d5;
                    dArray[n12 + 1] = d;
                    dArray[n11] = d7;
                    dArray[n11 + 1] = d6;
                    n12 = n2 + (n14 += n5);
                    n11 = n2 + (n13 += 2);
                    d7 = dArray[n12];
                    d6 = -dArray[n12 + 1];
                    d5 = dArray[n11];
                    d = -dArray[n11 + 1];
                    dArray[n12] = d5;
                    dArray[n12 + 1] = d;
                    dArray[n11] = d7;
                    dArray[n11 + 1] = d6;
                    n12 = n2 + (n14 -= n6);
                    n11 = n2 + (n13 -= n6);
                    d7 = dArray[n12];
                    d6 = -dArray[n12 + 1];
                    d5 = dArray[n11];
                    d = -dArray[n11 + 1];
                    dArray[n12] = d5;
                    dArray[n12 + 1] = d;
                    dArray[n11] = d7;
                    dArray[n11 + 1] = d6;
                    n12 = n2 + (n14 += 2);
                    n11 = n2 + (n13 += n5);
                    d7 = dArray[n12];
                    d6 = -dArray[n12 + 1];
                    d5 = dArray[n11];
                    d = -dArray[n11 + 1];
                    dArray[n12] = d5;
                    dArray[n12 + 1] = d;
                    dArray[n11] = d7;
                    dArray[n11 + 1] = d6;
                    n12 = n2 + (n14 += n6);
                    n11 = n2 + (n13 += n6);
                    d7 = dArray[n12];
                    d6 = -dArray[n12 + 1];
                    d5 = dArray[n11];
                    d = -dArray[n11 + 1];
                    dArray[n12] = d5;
                    dArray[n12 + 1] = d;
                    dArray[n11] = d7;
                    dArray[n11 + 1] = d6;
                    n12 = n2 + (n14 -= n5);
                    n11 = n2 + (n13 -= 2);
                    d7 = dArray[n12];
                    d6 = -dArray[n12 + 1];
                    d5 = dArray[n11];
                    d = -dArray[n11 + 1];
                    dArray[n12] = d5;
                    dArray[n12 + 1] = d;
                    dArray[n11] = d7;
                    dArray[n11 + 1] = d6;
                    n12 = n2 + (n14 -= n6);
                    n11 = n2 + (n13 -= n6);
                    d7 = dArray[n12];
                    d6 = -dArray[n12 + 1];
                    d5 = dArray[n11];
                    d = -dArray[n11 + 1];
                    dArray[n12] = d5;
                    dArray[n12 + 1] = d;
                    dArray[n11] = d7;
                    dArray[n11 + 1] = d6;
                }
                n13 = 4 * i + nArray[n4 + i];
                n14 = n13 + 2;
                n12 = n2 + n14;
                n11 = n2 + (n13 += n5);
                dArray[n12 - 1] = -dArray[n12 - 1];
                d7 = dArray[n12];
                d6 = -dArray[n12 + 1];
                d5 = dArray[n11];
                d = -dArray[n11 + 1];
                dArray[n12] = d5;
                dArray[n12 + 1] = d;
                dArray[n11] = d7;
                dArray[n11 + 1] = d6;
                dArray[n11 + 3] = -dArray[n11 + 3];
                n12 = n2 + (n14 += n6);
                n11 = n2 + (n13 += n6);
                dArray[n12 - 1] = -dArray[n12 - 1];
                d7 = dArray[n12];
                d6 = -dArray[n12 + 1];
                d5 = dArray[n11];
                d = -dArray[n11 + 1];
                dArray[n12] = d5;
                dArray[n12 + 1] = d;
                dArray[n11] = d7;
                dArray[n11 + 1] = d6;
                dArray[n11 + 3] = -dArray[n11 + 3];
            }
        }
    }

    private void bitrv216(double[] dArray, int n) {
        double d = dArray[n + 2];
        double d2 = dArray[n + 3];
        double d3 = dArray[n + 4];
        double d4 = dArray[n + 5];
        double d5 = dArray[n + 6];
        double d6 = dArray[n + 7];
        double d7 = dArray[n + 8];
        double d8 = dArray[n + 9];
        double d9 = dArray[n + 10];
        double d10 = dArray[n + 11];
        double d11 = dArray[n + 14];
        double d12 = dArray[n + 15];
        double d13 = dArray[n + 16];
        double d14 = dArray[n + 17];
        double d15 = dArray[n + 20];
        double d16 = dArray[n + 21];
        double d17 = dArray[n + 22];
        double d18 = dArray[n + 23];
        double d19 = dArray[n + 24];
        double d20 = dArray[n + 25];
        double d21 = dArray[n + 26];
        double d22 = dArray[n + 27];
        double d23 = dArray[n + 28];
        double d24 = dArray[n + 29];
        dArray[n + 2] = d13;
        dArray[n + 3] = d14;
        dArray[n + 4] = d7;
        dArray[n + 5] = d8;
        dArray[n + 6] = d19;
        dArray[n + 7] = d20;
        dArray[n + 8] = d3;
        dArray[n + 9] = d4;
        dArray[n + 10] = d15;
        dArray[n + 11] = d16;
        dArray[n + 14] = d23;
        dArray[n + 15] = d24;
        dArray[n + 16] = d;
        dArray[n + 17] = d2;
        dArray[n + 20] = d9;
        dArray[n + 21] = d10;
        dArray[n + 22] = d21;
        dArray[n + 23] = d22;
        dArray[n + 24] = d5;
        dArray[n + 25] = d6;
        dArray[n + 26] = d17;
        dArray[n + 27] = d18;
        dArray[n + 28] = d11;
        dArray[n + 29] = d12;
    }

    private void bitrv216neg(double[] dArray, int n) {
        double d = dArray[n + 2];
        double d2 = dArray[n + 3];
        double d3 = dArray[n + 4];
        double d4 = dArray[n + 5];
        double d5 = dArray[n + 6];
        double d6 = dArray[n + 7];
        double d7 = dArray[n + 8];
        double d8 = dArray[n + 9];
        double d9 = dArray[n + 10];
        double d10 = dArray[n + 11];
        double d11 = dArray[n + 12];
        double d12 = dArray[n + 13];
        double d13 = dArray[n + 14];
        double d14 = dArray[n + 15];
        double d15 = dArray[n + 16];
        double d16 = dArray[n + 17];
        double d17 = dArray[n + 18];
        double d18 = dArray[n + 19];
        double d19 = dArray[n + 20];
        double d20 = dArray[n + 21];
        double d21 = dArray[n + 22];
        double d22 = dArray[n + 23];
        double d23 = dArray[n + 24];
        double d24 = dArray[n + 25];
        double d25 = dArray[n + 26];
        double d26 = dArray[n + 27];
        double d27 = dArray[n + 28];
        double d28 = dArray[n + 29];
        double d29 = dArray[n + 30];
        double d30 = dArray[n + 31];
        dArray[n + 2] = d29;
        dArray[n + 3] = d30;
        dArray[n + 4] = d13;
        dArray[n + 5] = d14;
        dArray[n + 6] = d21;
        dArray[n + 7] = d22;
        dArray[n + 8] = d5;
        dArray[n + 9] = d6;
        dArray[n + 10] = d25;
        dArray[n + 11] = d26;
        dArray[n + 12] = d9;
        dArray[n + 13] = d10;
        dArray[n + 14] = d17;
        dArray[n + 15] = d18;
        dArray[n + 16] = d;
        dArray[n + 17] = d2;
        dArray[n + 18] = d27;
        dArray[n + 19] = d28;
        dArray[n + 20] = d11;
        dArray[n + 21] = d12;
        dArray[n + 22] = d19;
        dArray[n + 23] = d20;
        dArray[n + 24] = d3;
        dArray[n + 25] = d4;
        dArray[n + 26] = d23;
        dArray[n + 27] = d24;
        dArray[n + 28] = d7;
        dArray[n + 29] = d8;
        dArray[n + 30] = d15;
        dArray[n + 31] = d16;
    }

    private void bitrv208(double[] dArray, int n) {
        double d = dArray[n + 2];
        double d2 = dArray[n + 3];
        double d3 = dArray[n + 6];
        double d4 = dArray[n + 7];
        double d5 = dArray[n + 8];
        double d6 = dArray[n + 9];
        double d7 = dArray[n + 12];
        double d8 = dArray[n + 13];
        dArray[n + 2] = d5;
        dArray[n + 3] = d6;
        dArray[n + 6] = d7;
        dArray[n + 7] = d8;
        dArray[n + 8] = d;
        dArray[n + 9] = d2;
        dArray[n + 12] = d3;
        dArray[n + 13] = d4;
    }

    private void bitrv208neg(double[] dArray, int n) {
        double d = dArray[n + 2];
        double d2 = dArray[n + 3];
        double d3 = dArray[n + 4];
        double d4 = dArray[n + 5];
        double d5 = dArray[n + 6];
        double d6 = dArray[n + 7];
        double d7 = dArray[n + 8];
        double d8 = dArray[n + 9];
        double d9 = dArray[n + 10];
        double d10 = dArray[n + 11];
        double d11 = dArray[n + 12];
        double d12 = dArray[n + 13];
        double d13 = dArray[n + 14];
        double d14 = dArray[n + 15];
        dArray[n + 2] = d13;
        dArray[n + 3] = d14;
        dArray[n + 4] = d5;
        dArray[n + 5] = d6;
        dArray[n + 6] = d9;
        dArray[n + 7] = d10;
        dArray[n + 8] = d;
        dArray[n + 9] = d2;
        dArray[n + 10] = d11;
        dArray[n + 11] = d12;
        dArray[n + 12] = d3;
        dArray[n + 13] = d4;
        dArray[n + 14] = d7;
        dArray[n + 15] = d8;
    }

    private void cftf1st(int n, double[] dArray, int n2, double[] dArray2, int n3) {
        int n4;
        int n5;
        double d;
        double d2;
        double d3;
        double d4;
        int n6;
        int n7 = n >> 3;
        int n8 = n6 = 2 * n7;
        int n9 = n8 + n6;
        int n10 = n9 + n6;
        int n11 = n2 + n8;
        int n12 = n2 + n9;
        int n13 = n2 + n10;
        double d5 = dArray[n2] + dArray[n12];
        double d6 = dArray[n2 + 1] + dArray[n12 + 1];
        double d7 = dArray[n2] - dArray[n12];
        double d8 = dArray[n2 + 1] - dArray[n12 + 1];
        double d9 = dArray[n11] + dArray[n13];
        double d10 = dArray[n11 + 1] + dArray[n13 + 1];
        double d11 = dArray[n11] - dArray[n13];
        double d12 = dArray[n11 + 1] - dArray[n13 + 1];
        dArray[n2] = d5 + d9;
        dArray[n2 + 1] = d6 + d10;
        dArray[n11] = d5 - d9;
        dArray[n11 + 1] = d6 - d10;
        dArray[n12] = d7 - d12;
        dArray[n12 + 1] = d8 + d11;
        dArray[n13] = d7 + d12;
        dArray[n13 + 1] = d8 - d11;
        double d13 = dArray2[n3 + 1];
        double d14 = dArray2[n3 + 2];
        double d15 = dArray2[n3 + 3];
        double d16 = 1.0;
        double d17 = 0.0;
        double d18 = 1.0;
        double d19 = 0.0;
        int n14 = 0;
        for (int i = 2; i < n7 - 2; i += 4) {
            int n15 = n3 + (n14 += 4);
            d4 = d14 * (d16 + dArray2[n15]);
            d3 = d14 * (d17 + dArray2[n15 + 1]);
            d2 = d15 * (d18 + dArray2[n15 + 2]);
            d = d15 * (d19 + dArray2[n15 + 3]);
            d16 = dArray2[n15];
            d17 = dArray2[n15 + 1];
            d18 = dArray2[n15 + 2];
            d19 = dArray2[n15 + 3];
            n8 = i + n6;
            n9 = n8 + n6;
            n10 = n9 + n6;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            int n16 = n2 + i;
            d5 = dArray[n16] + dArray[n12];
            d6 = dArray[n16 + 1] + dArray[n12 + 1];
            d7 = dArray[n16] - dArray[n12];
            d8 = dArray[n16 + 1] - dArray[n12 + 1];
            double d20 = dArray[n16 + 2] + dArray[n12 + 2];
            double d21 = dArray[n16 + 3] + dArray[n12 + 3];
            double d22 = dArray[n16 + 2] - dArray[n12 + 2];
            double d23 = dArray[n16 + 3] - dArray[n12 + 3];
            d9 = dArray[n11] + dArray[n13];
            d10 = dArray[n11 + 1] + dArray[n13 + 1];
            d11 = dArray[n11] - dArray[n13];
            d12 = dArray[n11 + 1] - dArray[n13 + 1];
            double d24 = dArray[n11 + 2] + dArray[n13 + 2];
            double d25 = dArray[n11 + 3] + dArray[n13 + 3];
            double d26 = dArray[n11 + 2] - dArray[n13 + 2];
            double d27 = dArray[n11 + 3] - dArray[n13 + 3];
            dArray[n16] = d5 + d9;
            dArray[n16 + 1] = d6 + d10;
            dArray[n16 + 2] = d20 + d24;
            dArray[n16 + 3] = d21 + d25;
            dArray[n11] = d5 - d9;
            dArray[n11 + 1] = d6 - d10;
            dArray[n11 + 2] = d20 - d24;
            dArray[n11 + 3] = d21 - d25;
            d5 = d7 - d12;
            d6 = d8 + d11;
            dArray[n12] = d4 * d5 - d3 * d6;
            dArray[n12 + 1] = d4 * d6 + d3 * d5;
            d5 = d22 - d27;
            d6 = d23 + d26;
            dArray[n12 + 2] = d16 * d5 - d17 * d6;
            dArray[n12 + 3] = d16 * d6 + d17 * d5;
            d5 = d7 + d12;
            d6 = d8 - d11;
            dArray[n13] = d2 * d5 + d * d6;
            dArray[n13 + 1] = d2 * d6 - d * d5;
            d5 = d22 + d27;
            d6 = d23 - d26;
            dArray[n13 + 2] = d18 * d5 + d19 * d6;
            dArray[n13 + 3] = d18 * d6 - d19 * d5;
            n5 = n6 - i;
            n8 = n5 + n6;
            n9 = n8 + n6;
            n10 = n9 + n6;
            n4 = n2 + n5;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            d5 = dArray[n4] + dArray[n12];
            d6 = dArray[n4 + 1] + dArray[n12 + 1];
            d7 = dArray[n4] - dArray[n12];
            d8 = dArray[n4 + 1] - dArray[n12 + 1];
            d20 = dArray[n4 - 2] + dArray[n12 - 2];
            d21 = dArray[n4 - 1] + dArray[n12 - 1];
            d22 = dArray[n4 - 2] - dArray[n12 - 2];
            d23 = dArray[n4 - 1] - dArray[n12 - 1];
            d9 = dArray[n11] + dArray[n13];
            d10 = dArray[n11 + 1] + dArray[n13 + 1];
            d11 = dArray[n11] - dArray[n13];
            d12 = dArray[n11 + 1] - dArray[n13 + 1];
            d24 = dArray[n11 - 2] + dArray[n13 - 2];
            d25 = dArray[n11 - 1] + dArray[n13 - 1];
            d26 = dArray[n11 - 2] - dArray[n13 - 2];
            d27 = dArray[n11 - 1] - dArray[n13 - 1];
            dArray[n4] = d5 + d9;
            dArray[n4 + 1] = d6 + d10;
            dArray[n4 - 2] = d20 + d24;
            dArray[n4 - 1] = d21 + d25;
            dArray[n11] = d5 - d9;
            dArray[n11 + 1] = d6 - d10;
            dArray[n11 - 2] = d20 - d24;
            dArray[n11 - 1] = d21 - d25;
            d5 = d7 - d12;
            d6 = d8 + d11;
            dArray[n12] = d3 * d5 - d4 * d6;
            dArray[n12 + 1] = d3 * d6 + d4 * d5;
            d5 = d22 - d27;
            d6 = d23 + d26;
            dArray[n12 - 2] = d17 * d5 - d16 * d6;
            dArray[n12 - 1] = d17 * d6 + d16 * d5;
            d5 = d7 + d12;
            d6 = d8 - d11;
            dArray[n13] = d * d5 + d2 * d6;
            dArray[n13 + 1] = d * d6 - d2 * d5;
            d5 = d22 + d27;
            d6 = d23 - d26;
            dArray[n2 + n10 - 2] = d19 * d5 + d18 * d6;
            dArray[n2 + n10 - 1] = d19 * d6 - d18 * d5;
        }
        d4 = d14 * (d16 + d13);
        d3 = d14 * (d17 + d13);
        d2 = d15 * (d18 - d13);
        d = d15 * (d19 - d13);
        n5 = n7;
        n8 = n5 + n6;
        n9 = n8 + n6;
        n10 = n9 + n6;
        n4 = n2 + n5;
        n11 = n2 + n8;
        n12 = n2 + n9;
        n13 = n2 + n10;
        d5 = dArray[n4 - 2] + dArray[n12 - 2];
        d6 = dArray[n4 - 1] + dArray[n12 - 1];
        d7 = dArray[n4 - 2] - dArray[n12 - 2];
        d8 = dArray[n4 - 1] - dArray[n12 - 1];
        d9 = dArray[n11 - 2] + dArray[n13 - 2];
        d10 = dArray[n11 - 1] + dArray[n13 - 1];
        d11 = dArray[n11 - 2] - dArray[n13 - 2];
        d12 = dArray[n11 - 1] - dArray[n13 - 1];
        dArray[n4 - 2] = d5 + d9;
        dArray[n4 - 1] = d6 + d10;
        dArray[n11 - 2] = d5 - d9;
        dArray[n11 - 1] = d6 - d10;
        d5 = d7 - d12;
        d6 = d8 + d11;
        dArray[n12 - 2] = d4 * d5 - d3 * d6;
        dArray[n12 - 1] = d4 * d6 + d3 * d5;
        d5 = d7 + d12;
        d6 = d8 - d11;
        dArray[n13 - 2] = d2 * d5 + d * d6;
        dArray[n13 - 1] = d2 * d6 - d * d5;
        d5 = dArray[n4] + dArray[n12];
        d6 = dArray[n4 + 1] + dArray[n12 + 1];
        d7 = dArray[n4] - dArray[n12];
        d8 = dArray[n4 + 1] - dArray[n12 + 1];
        d9 = dArray[n11] + dArray[n13];
        d10 = dArray[n11 + 1] + dArray[n13 + 1];
        d11 = dArray[n11] - dArray[n13];
        d12 = dArray[n11 + 1] - dArray[n13 + 1];
        dArray[n4] = d5 + d9;
        dArray[n4 + 1] = d6 + d10;
        dArray[n11] = d5 - d9;
        dArray[n11 + 1] = d6 - d10;
        d5 = d7 - d12;
        d6 = d8 + d11;
        dArray[n12] = d13 * (d5 - d6);
        dArray[n12 + 1] = d13 * (d6 + d5);
        d5 = d7 + d12;
        d6 = d8 - d11;
        dArray[n13] = -d13 * (d5 + d6);
        dArray[n13 + 1] = -d13 * (d6 - d5);
        d5 = dArray[n4 + 2] + dArray[n12 + 2];
        d6 = dArray[n4 + 3] + dArray[n12 + 3];
        d7 = dArray[n4 + 2] - dArray[n12 + 2];
        d8 = dArray[n4 + 3] - dArray[n12 + 3];
        d9 = dArray[n11 + 2] + dArray[n13 + 2];
        d10 = dArray[n11 + 3] + dArray[n13 + 3];
        d11 = dArray[n11 + 2] - dArray[n13 + 2];
        d12 = dArray[n11 + 3] - dArray[n13 + 3];
        dArray[n4 + 2] = d5 + d9;
        dArray[n4 + 3] = d6 + d10;
        dArray[n11 + 2] = d5 - d9;
        dArray[n11 + 3] = d6 - d10;
        d5 = d7 - d12;
        d6 = d8 + d11;
        dArray[n12 + 2] = d3 * d5 - d4 * d6;
        dArray[n12 + 3] = d3 * d6 + d4 * d5;
        d5 = d7 + d12;
        d6 = d8 - d11;
        dArray[n13 + 2] = d * d5 + d2 * d6;
        dArray[n13 + 3] = d * d6 - d2 * d5;
    }

    private void cftb1st(int n, double[] dArray, int n2, double[] dArray2, int n3) {
        int n4;
        int n5;
        double d;
        double d2;
        double d3;
        double d4;
        int n6;
        int n7 = n >> 3;
        int n8 = n6 = 2 * n7;
        int n9 = n8 + n6;
        int n10 = n9 + n6;
        int n11 = n2 + n8;
        int n12 = n2 + n9;
        int n13 = n2 + n10;
        double d5 = dArray[n2] + dArray[n12];
        double d6 = -dArray[n2 + 1] - dArray[n12 + 1];
        double d7 = dArray[n2] - dArray[n12];
        double d8 = -dArray[n2 + 1] + dArray[n12 + 1];
        double d9 = dArray[n11] + dArray[n13];
        double d10 = dArray[n11 + 1] + dArray[n13 + 1];
        double d11 = dArray[n11] - dArray[n13];
        double d12 = dArray[n11 + 1] - dArray[n13 + 1];
        dArray[n2] = d5 + d9;
        dArray[n2 + 1] = d6 - d10;
        dArray[n11] = d5 - d9;
        dArray[n11 + 1] = d6 + d10;
        dArray[n12] = d7 + d12;
        dArray[n12 + 1] = d8 + d11;
        dArray[n13] = d7 - d12;
        dArray[n13 + 1] = d8 - d11;
        double d13 = dArray2[n3 + 1];
        double d14 = dArray2[n3 + 2];
        double d15 = dArray2[n3 + 3];
        double d16 = 1.0;
        double d17 = 0.0;
        double d18 = 1.0;
        double d19 = 0.0;
        int n14 = 0;
        for (int i = 2; i < n7 - 2; i += 4) {
            int n15 = n3 + (n14 += 4);
            d4 = d14 * (d16 + dArray2[n15]);
            d3 = d14 * (d17 + dArray2[n15 + 1]);
            d2 = d15 * (d18 + dArray2[n15 + 2]);
            d = d15 * (d19 + dArray2[n15 + 3]);
            d16 = dArray2[n15];
            d17 = dArray2[n15 + 1];
            d18 = dArray2[n15 + 2];
            d19 = dArray2[n15 + 3];
            n8 = i + n6;
            n9 = n8 + n6;
            n10 = n9 + n6;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            int n16 = n2 + i;
            d5 = dArray[n16] + dArray[n12];
            d6 = -dArray[n16 + 1] - dArray[n12 + 1];
            d7 = dArray[n16] - dArray[n2 + n9];
            d8 = -dArray[n16 + 1] + dArray[n12 + 1];
            double d20 = dArray[n16 + 2] + dArray[n12 + 2];
            double d21 = -dArray[n16 + 3] - dArray[n12 + 3];
            double d22 = dArray[n16 + 2] - dArray[n12 + 2];
            double d23 = -dArray[n16 + 3] + dArray[n12 + 3];
            d9 = dArray[n11] + dArray[n13];
            d10 = dArray[n11 + 1] + dArray[n13 + 1];
            d11 = dArray[n11] - dArray[n13];
            d12 = dArray[n11 + 1] - dArray[n13 + 1];
            double d24 = dArray[n11 + 2] + dArray[n13 + 2];
            double d25 = dArray[n11 + 3] + dArray[n13 + 3];
            double d26 = dArray[n11 + 2] - dArray[n13 + 2];
            double d27 = dArray[n11 + 3] - dArray[n13 + 3];
            dArray[n16] = d5 + d9;
            dArray[n16 + 1] = d6 - d10;
            dArray[n16 + 2] = d20 + d24;
            dArray[n16 + 3] = d21 - d25;
            dArray[n11] = d5 - d9;
            dArray[n11 + 1] = d6 + d10;
            dArray[n11 + 2] = d20 - d24;
            dArray[n11 + 3] = d21 + d25;
            d5 = d7 + d12;
            d6 = d8 + d11;
            dArray[n12] = d4 * d5 - d3 * d6;
            dArray[n12 + 1] = d4 * d6 + d3 * d5;
            d5 = d22 + d27;
            d6 = d23 + d26;
            dArray[n12 + 2] = d16 * d5 - d17 * d6;
            dArray[n12 + 3] = d16 * d6 + d17 * d5;
            d5 = d7 - d12;
            d6 = d8 - d11;
            dArray[n13] = d2 * d5 + d * d6;
            dArray[n13 + 1] = d2 * d6 - d * d5;
            d5 = d22 - d27;
            d6 = d23 - d26;
            dArray[n13 + 2] = d18 * d5 + d19 * d6;
            dArray[n13 + 3] = d18 * d6 - d19 * d5;
            n5 = n6 - i;
            n8 = n5 + n6;
            n9 = n8 + n6;
            n10 = n9 + n6;
            n4 = n2 + n5;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            d5 = dArray[n4] + dArray[n12];
            d6 = -dArray[n4 + 1] - dArray[n12 + 1];
            d7 = dArray[n4] - dArray[n12];
            d8 = -dArray[n4 + 1] + dArray[n12 + 1];
            d20 = dArray[n4 - 2] + dArray[n12 - 2];
            d21 = -dArray[n4 - 1] - dArray[n12 - 1];
            d22 = dArray[n4 - 2] - dArray[n12 - 2];
            d23 = -dArray[n4 - 1] + dArray[n12 - 1];
            d9 = dArray[n11] + dArray[n13];
            d10 = dArray[n11 + 1] + dArray[n13 + 1];
            d11 = dArray[n11] - dArray[n13];
            d12 = dArray[n11 + 1] - dArray[n13 + 1];
            d24 = dArray[n11 - 2] + dArray[n13 - 2];
            d25 = dArray[n11 - 1] + dArray[n13 - 1];
            d26 = dArray[n11 - 2] - dArray[n13 - 2];
            d27 = dArray[n11 - 1] - dArray[n13 - 1];
            dArray[n4] = d5 + d9;
            dArray[n4 + 1] = d6 - d10;
            dArray[n4 - 2] = d20 + d24;
            dArray[n4 - 1] = d21 - d25;
            dArray[n11] = d5 - d9;
            dArray[n11 + 1] = d6 + d10;
            dArray[n11 - 2] = d20 - d24;
            dArray[n11 - 1] = d21 + d25;
            d5 = d7 + d12;
            d6 = d8 + d11;
            dArray[n12] = d3 * d5 - d4 * d6;
            dArray[n12 + 1] = d3 * d6 + d4 * d5;
            d5 = d22 + d27;
            d6 = d23 + d26;
            dArray[n12 - 2] = d17 * d5 - d16 * d6;
            dArray[n12 - 1] = d17 * d6 + d16 * d5;
            d5 = d7 - d12;
            d6 = d8 - d11;
            dArray[n13] = d * d5 + d2 * d6;
            dArray[n13 + 1] = d * d6 - d2 * d5;
            d5 = d22 - d27;
            d6 = d23 - d26;
            dArray[n13 - 2] = d19 * d5 + d18 * d6;
            dArray[n13 - 1] = d19 * d6 - d18 * d5;
        }
        d4 = d14 * (d16 + d13);
        d3 = d14 * (d17 + d13);
        d2 = d15 * (d18 - d13);
        d = d15 * (d19 - d13);
        n5 = n7;
        n8 = n5 + n6;
        n9 = n8 + n6;
        n10 = n9 + n6;
        n4 = n2 + n5;
        n11 = n2 + n8;
        n12 = n2 + n9;
        n13 = n2 + n10;
        d5 = dArray[n4 - 2] + dArray[n12 - 2];
        d6 = -dArray[n4 - 1] - dArray[n12 - 1];
        d7 = dArray[n4 - 2] - dArray[n12 - 2];
        d8 = -dArray[n4 - 1] + dArray[n12 - 1];
        d9 = dArray[n11 - 2] + dArray[n13 - 2];
        d10 = dArray[n11 - 1] + dArray[n13 - 1];
        d11 = dArray[n11 - 2] - dArray[n13 - 2];
        d12 = dArray[n11 - 1] - dArray[n13 - 1];
        dArray[n4 - 2] = d5 + d9;
        dArray[n4 - 1] = d6 - d10;
        dArray[n11 - 2] = d5 - d9;
        dArray[n11 - 1] = d6 + d10;
        d5 = d7 + d12;
        d6 = d8 + d11;
        dArray[n12 - 2] = d4 * d5 - d3 * d6;
        dArray[n12 - 1] = d4 * d6 + d3 * d5;
        d5 = d7 - d12;
        d6 = d8 - d11;
        dArray[n13 - 2] = d2 * d5 + d * d6;
        dArray[n13 - 1] = d2 * d6 - d * d5;
        d5 = dArray[n4] + dArray[n12];
        d6 = -dArray[n4 + 1] - dArray[n12 + 1];
        d7 = dArray[n4] - dArray[n12];
        d8 = -dArray[n4 + 1] + dArray[n12 + 1];
        d9 = dArray[n11] + dArray[n13];
        d10 = dArray[n11 + 1] + dArray[n13 + 1];
        d11 = dArray[n11] - dArray[n13];
        d12 = dArray[n11 + 1] - dArray[n13 + 1];
        dArray[n4] = d5 + d9;
        dArray[n4 + 1] = d6 - d10;
        dArray[n11] = d5 - d9;
        dArray[n11 + 1] = d6 + d10;
        d5 = d7 + d12;
        d6 = d8 + d11;
        dArray[n12] = d13 * (d5 - d6);
        dArray[n12 + 1] = d13 * (d6 + d5);
        d5 = d7 - d12;
        d6 = d8 - d11;
        dArray[n13] = -d13 * (d5 + d6);
        dArray[n13 + 1] = -d13 * (d6 - d5);
        d5 = dArray[n4 + 2] + dArray[n12 + 2];
        d6 = -dArray[n4 + 3] - dArray[n12 + 3];
        d7 = dArray[n4 + 2] - dArray[n12 + 2];
        d8 = -dArray[n4 + 3] + dArray[n12 + 3];
        d9 = dArray[n11 + 2] + dArray[n13 + 2];
        d10 = dArray[n11 + 3] + dArray[n13 + 3];
        d11 = dArray[n11 + 2] - dArray[n13 + 2];
        d12 = dArray[n11 + 3] - dArray[n13 + 3];
        dArray[n4 + 2] = d5 + d9;
        dArray[n4 + 3] = d6 - d10;
        dArray[n11 + 2] = d5 - d9;
        dArray[n11 + 3] = d6 + d10;
        d5 = d7 + d12;
        d6 = d8 + d11;
        dArray[n12 + 2] = d3 * d5 - d4 * d6;
        dArray[n12 + 3] = d3 * d6 + d4 * d5;
        d5 = d7 - d12;
        d6 = d8 - d11;
        dArray[n13 + 2] = d * d5 + d2 * d6;
        dArray[n13 + 3] = d * d6 - d2 * d5;
    }

    private void cftrec4_th(final int n, final double[] dArray, int n2, final int n3, final double[] dArray2) {
        int n4 = 0;
        int n5 = 2;
        int n6 = 0;
        int n7 = n >> 1;
        if (n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_4Threads()) {
            n5 = 4;
            n6 = 1;
            n7 >>= 1;
        }
        Future[] futureArray = new Future[n5];
        final int n8 = n7;
        for (int i = 0; i < n5; ++i) {
            final int n9 = n2 + i * n7;
            futureArray[n4++] = i != n6 ? ConcurrencyUtils.submit((Runnable)new Runnable(){

                public void run() {
                    int n6 = n9 + n8;
                    int n2 = n;
                    while (n2 > 512) {
                        DoubleDCT_1D.this.cftmdl1(n2 >>= 2, dArray, n6 - n2, dArray2, n3 - (n2 >> 1));
                    }
                    DoubleDCT_1D.this.cftleaf(n2, 1, dArray, n6 - n2, n3, dArray2);
                    int n32 = 0;
                    int n4 = n9 - n2;
                    for (int i = n8 - n2; i > 0; i -= n2) {
                        int n5 = DoubleDCT_1D.this.cfttree(n2, i, ++n32, dArray, n9, n3, dArray2);
                        DoubleDCT_1D.this.cftleaf(n2, n5, dArray, n4 + i, n3, dArray2);
                    }
                }
            }) : ConcurrencyUtils.submit((Runnable)new Runnable(){

                public void run() {
                    int n6 = n9 + n8;
                    int n2 = 1;
                    int n32 = n;
                    while (n32 > 512) {
                        n2 <<= 2;
                        DoubleDCT_1D.this.cftmdl2(n32 >>= 2, dArray, n6 - n32, dArray2, n3 - n32);
                    }
                    DoubleDCT_1D.this.cftleaf(n32, 0, dArray, n6 - n32, n3, dArray2);
                    n2 >>= 1;
                    int n4 = n9 - n32;
                    for (int i = n8 - n32; i > 0; i -= n32) {
                        int n5 = DoubleDCT_1D.this.cfttree(n32, i, ++n2, dArray, n9, n3, dArray2);
                        DoubleDCT_1D.this.cftleaf(n32, n5, dArray, n4 + i, n3, dArray2);
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion((Future[])futureArray);
    }

    private void cftrec4(int n, double[] dArray, int n2, int n3, double[] dArray2) {
        int n4 = n2 + n;
        int n5 = n;
        while (n5 > 512) {
            this.cftmdl1(n5 >>= 2, dArray, n4 - n5, dArray2, n3 - (n5 >> 1));
        }
        this.cftleaf(n5, 1, dArray, n4 - n5, n3, dArray2);
        int n6 = 0;
        int n7 = n2 - n5;
        for (int i = n - n5; i > 0; i -= n5) {
            int n8 = this.cfttree(n5, i, ++n6, dArray, n2, n3, dArray2);
            this.cftleaf(n5, n8, dArray, n7 + i, n3, dArray2);
        }
    }

    private int cfttree(int n, int n2, int n3, double[] dArray, int n4, int n5, double[] dArray2) {
        int n6;
        int n7 = n4 - n;
        if ((n3 & 3) != 0) {
            n6 = n3 & 1;
            if (n6 != 0) {
                this.cftmdl1(n, dArray, n7 + n2, dArray2, n5 - (n >> 1));
            } else {
                this.cftmdl2(n, dArray, n7 + n2, dArray2, n5 - n);
            }
        } else {
            int n8 = n;
            int n9 = n3;
            while ((n9 & 3) == 0) {
                n8 <<= 2;
                n9 >>= 2;
            }
            n6 = n9 & 1;
            int n10 = n4 + n2;
            if (n6 != 0) {
                while (n8 > 128) {
                    this.cftmdl1(n8, dArray, n10 - n8, dArray2, n5 - (n8 >> 1));
                    n8 >>= 2;
                }
            } else {
                while (n8 > 128) {
                    this.cftmdl2(n8, dArray, n10 - n8, dArray2, n5 - n8);
                    n8 >>= 2;
                }
            }
        }
        return n6;
    }

    private void cftleaf(int n, int n2, double[] dArray, int n3, int n4, double[] dArray2) {
        if (n == 512) {
            this.cftmdl1(128, dArray, n3, dArray2, n4 - 64);
            this.cftf161(dArray, n3, dArray2, n4 - 8);
            this.cftf162(dArray, n3 + 32, dArray2, n4 - 32);
            this.cftf161(dArray, n3 + 64, dArray2, n4 - 8);
            this.cftf161(dArray, n3 + 96, dArray2, n4 - 8);
            this.cftmdl2(128, dArray, n3 + 128, dArray2, n4 - 128);
            this.cftf161(dArray, n3 + 128, dArray2, n4 - 8);
            this.cftf162(dArray, n3 + 160, dArray2, n4 - 32);
            this.cftf161(dArray, n3 + 192, dArray2, n4 - 8);
            this.cftf162(dArray, n3 + 224, dArray2, n4 - 32);
            this.cftmdl1(128, dArray, n3 + 256, dArray2, n4 - 64);
            this.cftf161(dArray, n3 + 256, dArray2, n4 - 8);
            this.cftf162(dArray, n3 + 288, dArray2, n4 - 32);
            this.cftf161(dArray, n3 + 320, dArray2, n4 - 8);
            this.cftf161(dArray, n3 + 352, dArray2, n4 - 8);
            if (n2 != 0) {
                this.cftmdl1(128, dArray, n3 + 384, dArray2, n4 - 64);
                this.cftf161(dArray, n3 + 480, dArray2, n4 - 8);
            } else {
                this.cftmdl2(128, dArray, n3 + 384, dArray2, n4 - 128);
                this.cftf162(dArray, n3 + 480, dArray2, n4 - 32);
            }
            this.cftf161(dArray, n3 + 384, dArray2, n4 - 8);
            this.cftf162(dArray, n3 + 416, dArray2, n4 - 32);
            this.cftf161(dArray, n3 + 448, dArray2, n4 - 8);
        } else {
            this.cftmdl1(64, dArray, n3, dArray2, n4 - 32);
            this.cftf081(dArray, n3, dArray2, n4 - 8);
            this.cftf082(dArray, n3 + 16, dArray2, n4 - 8);
            this.cftf081(dArray, n3 + 32, dArray2, n4 - 8);
            this.cftf081(dArray, n3 + 48, dArray2, n4 - 8);
            this.cftmdl2(64, dArray, n3 + 64, dArray2, n4 - 64);
            this.cftf081(dArray, n3 + 64, dArray2, n4 - 8);
            this.cftf082(dArray, n3 + 80, dArray2, n4 - 8);
            this.cftf081(dArray, n3 + 96, dArray2, n4 - 8);
            this.cftf082(dArray, n3 + 112, dArray2, n4 - 8);
            this.cftmdl1(64, dArray, n3 + 128, dArray2, n4 - 32);
            this.cftf081(dArray, n3 + 128, dArray2, n4 - 8);
            this.cftf082(dArray, n3 + 144, dArray2, n4 - 8);
            this.cftf081(dArray, n3 + 160, dArray2, n4 - 8);
            this.cftf081(dArray, n3 + 176, dArray2, n4 - 8);
            if (n2 != 0) {
                this.cftmdl1(64, dArray, n3 + 192, dArray2, n4 - 32);
                this.cftf081(dArray, n3 + 240, dArray2, n4 - 8);
            } else {
                this.cftmdl2(64, dArray, n3 + 192, dArray2, n4 - 64);
                this.cftf082(dArray, n3 + 240, dArray2, n4 - 8);
            }
            this.cftf081(dArray, n3 + 192, dArray2, n4 - 8);
            this.cftf082(dArray, n3 + 208, dArray2, n4 - 8);
            this.cftf081(dArray, n3 + 224, dArray2, n4 - 8);
        }
    }

    private void cftmdl1(int n, double[] dArray, int n2, double[] dArray2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7 = n >> 3;
        int n8 = n6 = 2 * n7;
        int n9 = n8 + n6;
        int n10 = n9 + n6;
        int n11 = n2 + n8;
        int n12 = n2 + n9;
        int n13 = n2 + n10;
        double d = dArray[n2] + dArray[n12];
        double d2 = dArray[n2 + 1] + dArray[n12 + 1];
        double d3 = dArray[n2] - dArray[n12];
        double d4 = dArray[n2 + 1] - dArray[n12 + 1];
        double d5 = dArray[n11] + dArray[n13];
        double d6 = dArray[n11 + 1] + dArray[n13 + 1];
        double d7 = dArray[n11] - dArray[n13];
        double d8 = dArray[n11 + 1] - dArray[n13 + 1];
        dArray[n2] = d + d5;
        dArray[n2 + 1] = d2 + d6;
        dArray[n11] = d - d5;
        dArray[n11 + 1] = d2 - d6;
        dArray[n12] = d3 - d8;
        dArray[n12 + 1] = d4 + d7;
        dArray[n13] = d3 + d8;
        dArray[n13 + 1] = d4 - d7;
        double d9 = dArray2[n3 + 1];
        int n14 = 0;
        for (int i = 2; i < n7; i += 2) {
            int n15 = n3 + (n14 += 4);
            double d10 = dArray2[n15];
            double d11 = dArray2[n15 + 1];
            double d12 = dArray2[n15 + 2];
            double d13 = dArray2[n15 + 3];
            n8 = i + n6;
            n9 = n8 + n6;
            n10 = n9 + n6;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            int n16 = n2 + i;
            d = dArray[n16] + dArray[n12];
            d2 = dArray[n16 + 1] + dArray[n12 + 1];
            d3 = dArray[n16] - dArray[n12];
            d4 = dArray[n16 + 1] - dArray[n12 + 1];
            d5 = dArray[n11] + dArray[n13];
            d6 = dArray[n11 + 1] + dArray[n13 + 1];
            d7 = dArray[n11] - dArray[n13];
            d8 = dArray[n11 + 1] - dArray[n13 + 1];
            dArray[n16] = d + d5;
            dArray[n16 + 1] = d2 + d6;
            dArray[n11] = d - d5;
            dArray[n11 + 1] = d2 - d6;
            d = d3 - d8;
            d2 = d4 + d7;
            dArray[n12] = d10 * d - d11 * d2;
            dArray[n12 + 1] = d10 * d2 + d11 * d;
            d = d3 + d8;
            d2 = d4 - d7;
            dArray[n13] = d12 * d + d13 * d2;
            dArray[n13 + 1] = d12 * d2 - d13 * d;
            n5 = n6 - i;
            n8 = n5 + n6;
            n9 = n8 + n6;
            n10 = n9 + n6;
            n4 = n2 + n5;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            d = dArray[n4] + dArray[n12];
            d2 = dArray[n4 + 1] + dArray[n12 + 1];
            d3 = dArray[n4] - dArray[n12];
            d4 = dArray[n4 + 1] - dArray[n12 + 1];
            d5 = dArray[n11] + dArray[n13];
            d6 = dArray[n11 + 1] + dArray[n13 + 1];
            d7 = dArray[n11] - dArray[n13];
            d8 = dArray[n11 + 1] - dArray[n13 + 1];
            dArray[n4] = d + d5;
            dArray[n4 + 1] = d2 + d6;
            dArray[n11] = d - d5;
            dArray[n11 + 1] = d2 - d6;
            d = d3 - d8;
            d2 = d4 + d7;
            dArray[n12] = d11 * d - d10 * d2;
            dArray[n12 + 1] = d11 * d2 + d10 * d;
            d = d3 + d8;
            d2 = d4 - d7;
            dArray[n13] = d13 * d + d12 * d2;
            dArray[n13 + 1] = d13 * d2 - d12 * d;
        }
        n5 = n7;
        n8 = n5 + n6;
        n9 = n8 + n6;
        n10 = n9 + n6;
        n4 = n2 + n5;
        n11 = n2 + n8;
        n12 = n2 + n9;
        n13 = n2 + n10;
        d = dArray[n4] + dArray[n12];
        d2 = dArray[n4 + 1] + dArray[n12 + 1];
        d3 = dArray[n4] - dArray[n12];
        d4 = dArray[n4 + 1] - dArray[n12 + 1];
        d5 = dArray[n11] + dArray[n13];
        d6 = dArray[n11 + 1] + dArray[n13 + 1];
        d7 = dArray[n11] - dArray[n13];
        d8 = dArray[n11 + 1] - dArray[n13 + 1];
        dArray[n4] = d + d5;
        dArray[n4 + 1] = d2 + d6;
        dArray[n11] = d - d5;
        dArray[n11 + 1] = d2 - d6;
        d = d3 - d8;
        d2 = d4 + d7;
        dArray[n12] = d9 * (d - d2);
        dArray[n12 + 1] = d9 * (d2 + d);
        d = d3 + d8;
        d2 = d4 - d7;
        dArray[n13] = -d9 * (d + d2);
        dArray[n13 + 1] = -d9 * (d2 - d);
    }

    private void cftmdl2(int n, double[] dArray, int n2, double[] dArray2, int n3) {
        int n4;
        int n5;
        double d;
        double d2;
        double d3;
        double d4;
        int n6 = n >> 3;
        int n7 = 2 * n6;
        double d5 = dArray2[n3 + 1];
        int n8 = n7;
        int n9 = n8 + n7;
        int n10 = n9 + n7;
        int n11 = n2 + n8;
        int n12 = n2 + n9;
        int n13 = n2 + n10;
        double d6 = dArray[n2] - dArray[n12 + 1];
        double d7 = dArray[n2 + 1] + dArray[n12];
        double d8 = dArray[n2] + dArray[n12 + 1];
        double d9 = dArray[n2 + 1] - dArray[n12];
        double d10 = dArray[n11] - dArray[n13 + 1];
        double d11 = dArray[n11 + 1] + dArray[n13];
        double d12 = dArray[n11] + dArray[n13 + 1];
        double d13 = dArray[n11 + 1] - dArray[n13];
        double d14 = d5 * (d10 - d11);
        double d15 = d5 * (d11 + d10);
        dArray[n2] = d6 + d14;
        dArray[n2 + 1] = d7 + d15;
        dArray[n11] = d6 - d14;
        dArray[n11 + 1] = d7 - d15;
        d14 = d5 * (d12 - d13);
        d15 = d5 * (d13 + d12);
        dArray[n12] = d8 - d15;
        dArray[n12 + 1] = d9 + d14;
        dArray[n13] = d8 + d15;
        dArray[n13 + 1] = d9 - d14;
        int n14 = 0;
        int n15 = 2 * n7;
        for (int i = 2; i < n6; i += 2) {
            int n16 = n3 + (n14 += 4);
            d4 = dArray2[n16];
            d3 = dArray2[n16 + 1];
            double d16 = dArray2[n16 + 2];
            double d17 = dArray2[n16 + 3];
            int n17 = n3 + (n15 -= 4);
            double d18 = dArray2[n17];
            double d19 = dArray2[n17 + 1];
            double d20 = dArray2[n17 + 2];
            double d21 = dArray2[n17 + 3];
            n8 = i + n7;
            n9 = n8 + n7;
            n10 = n9 + n7;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            int n18 = n2 + i;
            d6 = dArray[n18] - dArray[n12 + 1];
            d7 = dArray[n18 + 1] + dArray[n12];
            d8 = dArray[n18] + dArray[n12 + 1];
            d9 = dArray[n18 + 1] - dArray[n12];
            d10 = dArray[n11] - dArray[n13 + 1];
            d11 = dArray[n11 + 1] + dArray[n13];
            d12 = dArray[n11] + dArray[n13 + 1];
            d13 = dArray[n11 + 1] - dArray[n13];
            d14 = d4 * d6 - d3 * d7;
            d15 = d4 * d7 + d3 * d6;
            d2 = d19 * d10 - d18 * d11;
            d = d19 * d11 + d18 * d10;
            dArray[n18] = d14 + d2;
            dArray[n18 + 1] = d15 + d;
            dArray[n11] = d14 - d2;
            dArray[n11 + 1] = d15 - d;
            d14 = d16 * d8 + d17 * d9;
            d15 = d16 * d9 - d17 * d8;
            d2 = d21 * d12 + d20 * d13;
            d = d21 * d13 - d20 * d12;
            dArray[n12] = d14 + d2;
            dArray[n12 + 1] = d15 + d;
            dArray[n13] = d14 - d2;
            dArray[n13 + 1] = d15 - d;
            n5 = n7 - i;
            n8 = n5 + n7;
            n9 = n8 + n7;
            n10 = n9 + n7;
            n4 = n2 + n5;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            d6 = dArray[n4] - dArray[n12 + 1];
            d7 = dArray[n4 + 1] + dArray[n12];
            d8 = dArray[n4] + dArray[n12 + 1];
            d9 = dArray[n4 + 1] - dArray[n12];
            d10 = dArray[n11] - dArray[n13 + 1];
            d11 = dArray[n11 + 1] + dArray[n13];
            d12 = dArray[n11] + dArray[n13 + 1];
            d13 = dArray[n11 + 1] - dArray[n13];
            d14 = d18 * d6 - d19 * d7;
            d15 = d18 * d7 + d19 * d6;
            d2 = d3 * d10 - d4 * d11;
            d = d3 * d11 + d4 * d10;
            dArray[n4] = d14 + d2;
            dArray[n4 + 1] = d15 + d;
            dArray[n11] = d14 - d2;
            dArray[n11 + 1] = d15 - d;
            d14 = d20 * d8 + d21 * d9;
            d15 = d20 * d9 - d21 * d8;
            d2 = d17 * d12 + d16 * d13;
            d = d17 * d13 - d16 * d12;
            dArray[n12] = d14 + d2;
            dArray[n12 + 1] = d15 + d;
            dArray[n13] = d14 - d2;
            dArray[n13 + 1] = d15 - d;
        }
        d4 = dArray2[n3 + n7];
        d3 = dArray2[n3 + n7 + 1];
        n5 = n6;
        n8 = n5 + n7;
        n9 = n8 + n7;
        n10 = n9 + n7;
        n4 = n2 + n5;
        n11 = n2 + n8;
        n12 = n2 + n9;
        n13 = n2 + n10;
        d6 = dArray[n4] - dArray[n12 + 1];
        d7 = dArray[n4 + 1] + dArray[n12];
        d8 = dArray[n4] + dArray[n12 + 1];
        d9 = dArray[n4 + 1] - dArray[n12];
        d10 = dArray[n11] - dArray[n13 + 1];
        d11 = dArray[n11 + 1] + dArray[n13];
        d12 = dArray[n11] + dArray[n13 + 1];
        d13 = dArray[n11 + 1] - dArray[n13];
        d14 = d4 * d6 - d3 * d7;
        d15 = d4 * d7 + d3 * d6;
        d2 = d3 * d10 - d4 * d11;
        d = d3 * d11 + d4 * d10;
        dArray[n4] = d14 + d2;
        dArray[n4 + 1] = d15 + d;
        dArray[n11] = d14 - d2;
        dArray[n11 + 1] = d15 - d;
        d14 = d3 * d8 - d4 * d9;
        d15 = d3 * d9 + d4 * d8;
        d2 = d4 * d12 - d3 * d13;
        d = d4 * d13 + d3 * d12;
        dArray[n12] = d14 - d2;
        dArray[n12 + 1] = d15 - d;
        dArray[n13] = d14 + d2;
        dArray[n13 + 1] = d15 + d;
    }

    private void cftfx41(int n, double[] dArray, int n2, int n3, double[] dArray2) {
        if (n == 128) {
            this.cftf161(dArray, n2, dArray2, n3 - 8);
            this.cftf162(dArray, n2 + 32, dArray2, n3 - 32);
            this.cftf161(dArray, n2 + 64, dArray2, n3 - 8);
            this.cftf161(dArray, n2 + 96, dArray2, n3 - 8);
        } else {
            this.cftf081(dArray, n2, dArray2, n3 - 8);
            this.cftf082(dArray, n2 + 16, dArray2, n3 - 8);
            this.cftf081(dArray, n2 + 32, dArray2, n3 - 8);
            this.cftf081(dArray, n2 + 48, dArray2, n3 - 8);
        }
    }

    private void cftf161(double[] dArray, int n, double[] dArray2, int n2) {
        double d = dArray2[n2 + 1];
        double d2 = dArray2[n2 + 2];
        double d3 = dArray2[n2 + 3];
        double d4 = dArray[n] + dArray[n + 16];
        double d5 = dArray[n + 1] + dArray[n + 17];
        double d6 = dArray[n] - dArray[n + 16];
        double d7 = dArray[n + 1] - dArray[n + 17];
        double d8 = dArray[n + 8] + dArray[n + 24];
        double d9 = dArray[n + 9] + dArray[n + 25];
        double d10 = dArray[n + 8] - dArray[n + 24];
        double d11 = dArray[n + 9] - dArray[n + 25];
        double d12 = d4 + d8;
        double d13 = d5 + d9;
        double d14 = d4 - d8;
        double d15 = d5 - d9;
        double d16 = d6 - d11;
        double d17 = d7 + d10;
        double d18 = d6 + d11;
        double d19 = d7 - d10;
        d4 = dArray[n + 2] + dArray[n + 18];
        d5 = dArray[n + 3] + dArray[n + 19];
        d6 = dArray[n + 2] - dArray[n + 18];
        d7 = dArray[n + 3] - dArray[n + 19];
        d8 = dArray[n + 10] + dArray[n + 26];
        d9 = dArray[n + 11] + dArray[n + 27];
        d10 = dArray[n + 10] - dArray[n + 26];
        d11 = dArray[n + 11] - dArray[n + 27];
        double d20 = d4 + d8;
        double d21 = d5 + d9;
        double d22 = d4 - d8;
        double d23 = d5 - d9;
        d4 = d6 - d11;
        d5 = d7 + d10;
        double d24 = d2 * d4 - d3 * d5;
        double d25 = d2 * d5 + d3 * d4;
        d4 = d6 + d11;
        d5 = d7 - d10;
        double d26 = d3 * d4 - d2 * d5;
        double d27 = d3 * d5 + d2 * d4;
        d4 = dArray[n + 4] + dArray[n + 20];
        d5 = dArray[n + 5] + dArray[n + 21];
        d6 = dArray[n + 4] - dArray[n + 20];
        d7 = dArray[n + 5] - dArray[n + 21];
        d8 = dArray[n + 12] + dArray[n + 28];
        d9 = dArray[n + 13] + dArray[n + 29];
        d10 = dArray[n + 12] - dArray[n + 28];
        d11 = dArray[n + 13] - dArray[n + 29];
        double d28 = d4 + d8;
        double d29 = d5 + d9;
        double d30 = d4 - d8;
        double d31 = d5 - d9;
        d4 = d6 - d11;
        d5 = d7 + d10;
        double d32 = d * (d4 - d5);
        double d33 = d * (d5 + d4);
        d4 = d6 + d11;
        d5 = d7 - d10;
        double d34 = d * (d4 + d5);
        double d35 = d * (d5 - d4);
        d4 = dArray[n + 6] + dArray[n + 22];
        d5 = dArray[n + 7] + dArray[n + 23];
        d6 = dArray[n + 6] - dArray[n + 22];
        d7 = dArray[n + 7] - dArray[n + 23];
        d8 = dArray[n + 14] + dArray[n + 30];
        d9 = dArray[n + 15] + dArray[n + 31];
        d10 = dArray[n + 14] - dArray[n + 30];
        d11 = dArray[n + 15] - dArray[n + 31];
        double d36 = d4 + d8;
        double d37 = d5 + d9;
        double d38 = d4 - d8;
        double d39 = d5 - d9;
        d4 = d6 - d11;
        d5 = d7 + d10;
        double d40 = d3 * d4 - d2 * d5;
        double d41 = d3 * d5 + d2 * d4;
        d4 = d6 + d11;
        d5 = d7 - d10;
        double d42 = d2 * d4 - d3 * d5;
        double d43 = d2 * d5 + d3 * d4;
        d4 = d18 - d34;
        d5 = d19 - d35;
        d6 = d18 + d34;
        d7 = d19 + d35;
        d8 = d26 - d42;
        d9 = d27 - d43;
        d10 = d26 + d42;
        d11 = d27 + d43;
        dArray[n + 24] = d4 + d8;
        dArray[n + 25] = d5 + d9;
        dArray[n + 26] = d4 - d8;
        dArray[n + 27] = d5 - d9;
        dArray[n + 28] = d6 - d11;
        dArray[n + 29] = d7 + d10;
        dArray[n + 30] = d6 + d11;
        dArray[n + 31] = d7 - d10;
        d4 = d16 + d32;
        d5 = d17 + d33;
        d6 = d16 - d32;
        d7 = d17 - d33;
        d8 = d24 + d40;
        d9 = d25 + d41;
        d10 = d24 - d40;
        d11 = d25 - d41;
        dArray[n + 16] = d4 + d8;
        dArray[n + 17] = d5 + d9;
        dArray[n + 18] = d4 - d8;
        dArray[n + 19] = d5 - d9;
        dArray[n + 20] = d6 - d11;
        dArray[n + 21] = d7 + d10;
        dArray[n + 22] = d6 + d11;
        dArray[n + 23] = d7 - d10;
        d4 = d22 - d39;
        d5 = d23 + d38;
        d8 = d * (d4 - d5);
        d9 = d * (d5 + d4);
        d4 = d22 + d39;
        d5 = d23 - d38;
        d10 = d * (d4 - d5);
        d11 = d * (d5 + d4);
        d4 = d14 - d31;
        d5 = d15 + d30;
        d6 = d14 + d31;
        d7 = d15 - d30;
        dArray[n + 8] = d4 + d8;
        dArray[n + 9] = d5 + d9;
        dArray[n + 10] = d4 - d8;
        dArray[n + 11] = d5 - d9;
        dArray[n + 12] = d6 - d11;
        dArray[n + 13] = d7 + d10;
        dArray[n + 14] = d6 + d11;
        dArray[n + 15] = d7 - d10;
        d4 = d12 + d28;
        d5 = d13 + d29;
        d6 = d12 - d28;
        d7 = d13 - d29;
        d8 = d20 + d36;
        d9 = d21 + d37;
        d10 = d20 - d36;
        d11 = d21 - d37;
        dArray[n] = d4 + d8;
        dArray[n + 1] = d5 + d9;
        dArray[n + 2] = d4 - d8;
        dArray[n + 3] = d5 - d9;
        dArray[n + 4] = d6 - d11;
        dArray[n + 5] = d7 + d10;
        dArray[n + 6] = d6 + d11;
        dArray[n + 7] = d7 - d10;
    }

    private void cftf162(double[] dArray, int n, double[] dArray2, int n2) {
        double d = dArray2[n2 + 1];
        double d2 = dArray2[n2 + 4];
        double d3 = dArray2[n2 + 5];
        double d4 = dArray2[n2 + 6];
        double d5 = -dArray2[n2 + 7];
        double d6 = dArray2[n2 + 8];
        double d7 = dArray2[n2 + 9];
        double d8 = dArray[n] - dArray[n + 17];
        double d9 = dArray[n + 1] + dArray[n + 16];
        double d10 = dArray[n + 8] - dArray[n + 25];
        double d11 = dArray[n + 9] + dArray[n + 24];
        double d12 = d * (d10 - d11);
        double d13 = d * (d11 + d10);
        double d14 = d8 + d12;
        double d15 = d9 + d13;
        double d16 = d8 - d12;
        double d17 = d9 - d13;
        d8 = dArray[n] + dArray[n + 17];
        d9 = dArray[n + 1] - dArray[n + 16];
        d10 = dArray[n + 8] + dArray[n + 25];
        d11 = dArray[n + 9] - dArray[n + 24];
        d12 = d * (d10 - d11);
        d13 = d * (d11 + d10);
        double d18 = d8 - d13;
        double d19 = d9 + d12;
        double d20 = d8 + d13;
        double d21 = d9 - d12;
        d10 = dArray[n + 2] - dArray[n + 19];
        d11 = dArray[n + 3] + dArray[n + 18];
        d8 = d2 * d10 - d3 * d11;
        d9 = d2 * d11 + d3 * d10;
        d10 = dArray[n + 10] - dArray[n + 27];
        d11 = dArray[n + 11] + dArray[n + 26];
        d12 = d5 * d10 - d4 * d11;
        d13 = d5 * d11 + d4 * d10;
        double d22 = d8 + d12;
        double d23 = d9 + d13;
        double d24 = d8 - d12;
        double d25 = d9 - d13;
        d10 = dArray[n + 2] + dArray[n + 19];
        d11 = dArray[n + 3] - dArray[n + 18];
        d8 = d4 * d10 - d5 * d11;
        d9 = d4 * d11 + d5 * d10;
        d10 = dArray[n + 10] + dArray[n + 27];
        d11 = dArray[n + 11] - dArray[n + 26];
        d12 = d2 * d10 + d3 * d11;
        d13 = d2 * d11 - d3 * d10;
        double d26 = d8 - d12;
        double d27 = d9 - d13;
        double d28 = d8 + d12;
        double d29 = d9 + d13;
        d10 = dArray[n + 4] - dArray[n + 21];
        d11 = dArray[n + 5] + dArray[n + 20];
        d8 = d6 * d10 - d7 * d11;
        d9 = d6 * d11 + d7 * d10;
        d10 = dArray[n + 12] - dArray[n + 29];
        d11 = dArray[n + 13] + dArray[n + 28];
        d12 = d7 * d10 - d6 * d11;
        d13 = d7 * d11 + d6 * d10;
        double d30 = d8 + d12;
        double d31 = d9 + d13;
        double d32 = d8 - d12;
        double d33 = d9 - d13;
        d10 = dArray[n + 4] + dArray[n + 21];
        d11 = dArray[n + 5] - dArray[n + 20];
        d8 = d7 * d10 - d6 * d11;
        d9 = d7 * d11 + d6 * d10;
        d10 = dArray[n + 12] + dArray[n + 29];
        d11 = dArray[n + 13] - dArray[n + 28];
        d12 = d6 * d10 - d7 * d11;
        d13 = d6 * d11 + d7 * d10;
        double d34 = d8 - d12;
        double d35 = d9 - d13;
        double d36 = d8 + d12;
        double d37 = d9 + d13;
        d10 = dArray[n + 6] - dArray[n + 23];
        d11 = dArray[n + 7] + dArray[n + 22];
        d8 = d4 * d10 - d5 * d11;
        d9 = d4 * d11 + d5 * d10;
        d10 = dArray[n + 14] - dArray[n + 31];
        d11 = dArray[n + 15] + dArray[n + 30];
        d12 = d3 * d10 - d2 * d11;
        d13 = d3 * d11 + d2 * d10;
        double d38 = d8 + d12;
        double d39 = d9 + d13;
        double d40 = d8 - d12;
        double d41 = d9 - d13;
        d10 = dArray[n + 6] + dArray[n + 23];
        d11 = dArray[n + 7] - dArray[n + 22];
        d8 = d3 * d10 + d2 * d11;
        d9 = d3 * d11 - d2 * d10;
        d10 = dArray[n + 14] + dArray[n + 31];
        d11 = dArray[n + 15] - dArray[n + 30];
        d12 = d5 * d10 - d4 * d11;
        d13 = d5 * d11 + d4 * d10;
        double d42 = d8 + d12;
        double d43 = d9 + d13;
        double d44 = d8 - d12;
        double d45 = d9 - d13;
        d8 = d14 + d30;
        d9 = d15 + d31;
        d12 = d22 + d38;
        d13 = d23 + d39;
        dArray[n] = d8 + d12;
        dArray[n + 1] = d9 + d13;
        dArray[n + 2] = d8 - d12;
        dArray[n + 3] = d9 - d13;
        d8 = d14 - d30;
        d9 = d15 - d31;
        d12 = d22 - d38;
        d13 = d23 - d39;
        dArray[n + 4] = d8 - d13;
        dArray[n + 5] = d9 + d12;
        dArray[n + 6] = d8 + d13;
        dArray[n + 7] = d9 - d12;
        d8 = d16 - d33;
        d9 = d17 + d32;
        d10 = d24 - d41;
        d11 = d25 + d40;
        d12 = d * (d10 - d11);
        d13 = d * (d11 + d10);
        dArray[n + 8] = d8 + d12;
        dArray[n + 9] = d9 + d13;
        dArray[n + 10] = d8 - d12;
        dArray[n + 11] = d9 - d13;
        d8 = d16 + d33;
        d9 = d17 - d32;
        d10 = d24 + d41;
        d11 = d25 - d40;
        d12 = d * (d10 - d11);
        d13 = d * (d11 + d10);
        dArray[n + 12] = d8 - d13;
        dArray[n + 13] = d9 + d12;
        dArray[n + 14] = d8 + d13;
        dArray[n + 15] = d9 - d12;
        d8 = d18 + d34;
        d9 = d19 + d35;
        d12 = d26 - d42;
        d13 = d27 - d43;
        dArray[n + 16] = d8 + d12;
        dArray[n + 17] = d9 + d13;
        dArray[n + 18] = d8 - d12;
        dArray[n + 19] = d9 - d13;
        d8 = d18 - d34;
        d9 = d19 - d35;
        d12 = d26 + d42;
        d13 = d27 + d43;
        dArray[n + 20] = d8 - d13;
        dArray[n + 21] = d9 + d12;
        dArray[n + 22] = d8 + d13;
        dArray[n + 23] = d9 - d12;
        d8 = d20 - d37;
        d9 = d21 + d36;
        d10 = d28 + d45;
        d11 = d29 - d44;
        d12 = d * (d10 - d11);
        d13 = d * (d11 + d10);
        dArray[n + 24] = d8 + d12;
        dArray[n + 25] = d9 + d13;
        dArray[n + 26] = d8 - d12;
        dArray[n + 27] = d9 - d13;
        d8 = d20 + d37;
        d9 = d21 - d36;
        d10 = d28 - d45;
        d11 = d29 + d44;
        d12 = d * (d10 - d11);
        d13 = d * (d11 + d10);
        dArray[n + 28] = d8 - d13;
        dArray[n + 29] = d9 + d12;
        dArray[n + 30] = d8 + d13;
        dArray[n + 31] = d9 - d12;
    }

    private void cftf081(double[] dArray, int n, double[] dArray2, int n2) {
        double d = dArray2[n2 + 1];
        double d2 = dArray[n] + dArray[n + 8];
        double d3 = dArray[n + 1] + dArray[n + 9];
        double d4 = dArray[n] - dArray[n + 8];
        double d5 = dArray[n + 1] - dArray[n + 9];
        double d6 = dArray[n + 4] + dArray[n + 12];
        double d7 = dArray[n + 5] + dArray[n + 13];
        double d8 = dArray[n + 4] - dArray[n + 12];
        double d9 = dArray[n + 5] - dArray[n + 13];
        double d10 = d2 + d6;
        double d11 = d3 + d7;
        double d12 = d2 - d6;
        double d13 = d3 - d7;
        double d14 = d4 - d9;
        double d15 = d5 + d8;
        double d16 = d4 + d9;
        double d17 = d5 - d8;
        d2 = dArray[n + 2] + dArray[n + 10];
        d3 = dArray[n + 3] + dArray[n + 11];
        d4 = dArray[n + 2] - dArray[n + 10];
        d5 = dArray[n + 3] - dArray[n + 11];
        d6 = dArray[n + 6] + dArray[n + 14];
        d7 = dArray[n + 7] + dArray[n + 15];
        d8 = dArray[n + 6] - dArray[n + 14];
        d9 = dArray[n + 7] - dArray[n + 15];
        double d18 = d2 + d6;
        double d19 = d3 + d7;
        double d20 = d2 - d6;
        double d21 = d3 - d7;
        d2 = d4 - d9;
        d3 = d5 + d8;
        d6 = d4 + d9;
        d7 = d5 - d8;
        double d22 = d * (d2 - d3);
        double d23 = d * (d2 + d3);
        double d24 = d * (d6 - d7);
        double d25 = d * (d6 + d7);
        dArray[n + 8] = d14 + d22;
        dArray[n + 9] = d15 + d23;
        dArray[n + 10] = d14 - d22;
        dArray[n + 11] = d15 - d23;
        dArray[n + 12] = d16 - d25;
        dArray[n + 13] = d17 + d24;
        dArray[n + 14] = d16 + d25;
        dArray[n + 15] = d17 - d24;
        dArray[n] = d10 + d18;
        dArray[n + 1] = d11 + d19;
        dArray[n + 2] = d10 - d18;
        dArray[n + 3] = d11 - d19;
        dArray[n + 4] = d12 - d21;
        dArray[n + 5] = d13 + d20;
        dArray[n + 6] = d12 + d21;
        dArray[n + 7] = d13 - d20;
    }

    private void cftf082(double[] dArray, int n, double[] dArray2, int n2) {
        double d = dArray2[n2 + 1];
        double d2 = dArray2[n2 + 2];
        double d3 = dArray2[n2 + 3];
        double d4 = dArray[n] - dArray[n + 9];
        double d5 = dArray[n + 1] + dArray[n + 8];
        double d6 = dArray[n] + dArray[n + 9];
        double d7 = dArray[n + 1] - dArray[n + 8];
        double d8 = dArray[n + 4] - dArray[n + 13];
        double d9 = dArray[n + 5] + dArray[n + 12];
        double d10 = d * (d8 - d9);
        double d11 = d * (d9 + d8);
        d8 = dArray[n + 4] + dArray[n + 13];
        d9 = dArray[n + 5] - dArray[n + 12];
        double d12 = d * (d8 - d9);
        double d13 = d * (d9 + d8);
        d8 = dArray[n + 2] - dArray[n + 11];
        d9 = dArray[n + 3] + dArray[n + 10];
        double d14 = d2 * d8 - d3 * d9;
        double d15 = d2 * d9 + d3 * d8;
        d8 = dArray[n + 2] + dArray[n + 11];
        d9 = dArray[n + 3] - dArray[n + 10];
        double d16 = d3 * d8 - d2 * d9;
        double d17 = d3 * d9 + d2 * d8;
        d8 = dArray[n + 6] - dArray[n + 15];
        d9 = dArray[n + 7] + dArray[n + 14];
        double d18 = d3 * d8 - d2 * d9;
        double d19 = d3 * d9 + d2 * d8;
        d8 = dArray[n + 6] + dArray[n + 15];
        d9 = dArray[n + 7] - dArray[n + 14];
        double d20 = d2 * d8 - d3 * d9;
        double d21 = d2 * d9 + d3 * d8;
        d8 = d4 + d10;
        d9 = d5 + d11;
        double d22 = d14 + d18;
        double d23 = d15 + d19;
        dArray[n] = d8 + d22;
        dArray[n + 1] = d9 + d23;
        dArray[n + 2] = d8 - d22;
        dArray[n + 3] = d9 - d23;
        d8 = d4 - d10;
        d9 = d5 - d11;
        d22 = d14 - d18;
        d23 = d15 - d19;
        dArray[n + 4] = d8 - d23;
        dArray[n + 5] = d9 + d22;
        dArray[n + 6] = d8 + d23;
        dArray[n + 7] = d9 - d22;
        d8 = d6 - d13;
        d9 = d7 + d12;
        d22 = d16 - d20;
        d23 = d17 - d21;
        dArray[n + 8] = d8 + d22;
        dArray[n + 9] = d9 + d23;
        dArray[n + 10] = d8 - d22;
        dArray[n + 11] = d9 - d23;
        d8 = d6 + d13;
        d9 = d7 - d12;
        d22 = d16 + d20;
        d23 = d17 + d21;
        dArray[n + 12] = d8 - d23;
        dArray[n + 13] = d9 + d22;
        dArray[n + 14] = d8 + d23;
        dArray[n + 15] = d9 - d22;
    }

    private void cftf040(double[] dArray, int n) {
        double d = dArray[n] + dArray[n + 4];
        double d2 = dArray[n + 1] + dArray[n + 5];
        double d3 = dArray[n] - dArray[n + 4];
        double d4 = dArray[n + 1] - dArray[n + 5];
        double d5 = dArray[n + 2] + dArray[n + 6];
        double d6 = dArray[n + 3] + dArray[n + 7];
        double d7 = dArray[n + 2] - dArray[n + 6];
        double d8 = dArray[n + 3] - dArray[n + 7];
        dArray[n] = d + d5;
        dArray[n + 1] = d2 + d6;
        dArray[n + 2] = d3 - d8;
        dArray[n + 3] = d4 + d7;
        dArray[n + 4] = d - d5;
        dArray[n + 5] = d2 - d6;
        dArray[n + 6] = d3 + d8;
        dArray[n + 7] = d4 - d7;
    }

    private void cftb040(double[] dArray, int n) {
        double d = dArray[n] + dArray[n + 4];
        double d2 = dArray[n + 1] + dArray[n + 5];
        double d3 = dArray[n] - dArray[n + 4];
        double d4 = dArray[n + 1] - dArray[n + 5];
        double d5 = dArray[n + 2] + dArray[n + 6];
        double d6 = dArray[n + 3] + dArray[n + 7];
        double d7 = dArray[n + 2] - dArray[n + 6];
        double d8 = dArray[n + 3] - dArray[n + 7];
        dArray[n] = d + d5;
        dArray[n + 1] = d2 + d6;
        dArray[n + 2] = d3 + d8;
        dArray[n + 3] = d4 - d7;
        dArray[n + 4] = d - d5;
        dArray[n + 5] = d2 - d6;
        dArray[n + 6] = d3 - d8;
        dArray[n + 7] = d4 + d7;
    }

    private void cftx020(double[] dArray, int n) {
        double d = dArray[n] - dArray[n + 2];
        double d2 = dArray[n + 1] - dArray[n + 3];
        int n2 = n;
        dArray[n2] = dArray[n2] + dArray[n + 2];
        int n3 = n + 1;
        dArray[n3] = dArray[n3] + dArray[n + 3];
        dArray[n + 2] = d;
        dArray[n + 3] = d2;
    }

    private void rftfsub(int n, double[] dArray, int n2, int n3, double[] dArray2, int n4) {
        int n5 = n >> 1;
        int n6 = 2 * n3 / n5;
        int n7 = 0;
        for (int i = 2; i < n5; i += 2) {
            int n8 = n - i;
            double d = 0.5 - dArray2[n4 + n3 - (n7 += n6)];
            double d2 = dArray2[n4 + n7];
            int n9 = n2 + i;
            int n10 = n2 + n8;
            double d3 = dArray[n9] - dArray[n10];
            double d4 = dArray[n9 + 1] + dArray[n10 + 1];
            double d5 = d * d3 - d2 * d4;
            double d6 = d * d4 + d2 * d3;
            int n11 = n9;
            dArray[n11] = dArray[n11] - d5;
            int n12 = n9 + 1;
            dArray[n12] = dArray[n12] - d6;
            int n13 = n10;
            dArray[n13] = dArray[n13] + d5;
            int n14 = n10 + 1;
            dArray[n14] = dArray[n14] - d6;
        }
    }

    private void rftbsub(int n, double[] dArray, int n2, int n3, double[] dArray2, int n4) {
        int n5 = n >> 1;
        int n6 = 2 * n3 / n5;
        int n7 = 0;
        for (int i = 2; i < n5; i += 2) {
            int n8 = n - i;
            double d = 0.5 - dArray2[n4 + n3 - (n7 += n6)];
            double d2 = dArray2[n4 + n7];
            int n9 = n2 + i;
            int n10 = n2 + n8;
            double d3 = dArray[n9] - dArray[n10];
            double d4 = dArray[n9 + 1] + dArray[n10 + 1];
            double d5 = d * d3 + d2 * d4;
            double d6 = d * d4 - d2 * d3;
            int n11 = n9;
            dArray[n11] = dArray[n11] - d5;
            int n12 = n9 + 1;
            dArray[n12] = dArray[n12] - d6;
            int n13 = n10;
            dArray[n13] = dArray[n13] + d5;
            int n14 = n10 + 1;
            dArray[n14] = dArray[n14] - d6;
        }
    }

    private void dctsub(int n, double[] dArray, int n2, int n3, double[] dArray2, int n4) {
        int n5 = n >> 1;
        int n6 = n3 / n;
        int n7 = 0;
        for (int i = 1; i < n5; ++i) {
            int n8 = n - i;
            int n9 = n4 + (n7 += n6);
            int n10 = n2 + i;
            int n11 = n2 + n8;
            double d = dArray2[n9] - dArray2[n4 + n3 - n7];
            double d2 = dArray2[n9] + dArray2[n4 + n3 - n7];
            double d3 = d2 * dArray[n10] - d * dArray[n11];
            dArray[n10] = d * dArray[n10] + d2 * dArray[n11];
            dArray[n11] = d3;
        }
        int n12 = n2 + n5;
        dArray[n12] = dArray[n12] * dArray2[n4];
    }

    private void scale(final double d, final double[] dArray, int n) {
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            n2 = 2;
            int n3 = this.n / n2;
            Future[] futureArray = new Future[n2];
            for (int i = 0; i < n2; ++i) {
                final int n4 = n + i * n3;
                final int n5 = i == n2 - 1 ? n + this.n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        int n = n4;
                        while (n < n5) {
                            int n2 = n++;
                            dArray[n2] = dArray[n2] * d;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futureArray);
        } else {
            int n6 = n;
            int n7 = n + this.n;
            int n8 = n6;
            while (n8 < n7) {
                int n9 = n8++;
                dArray[n9] = dArray[n9] * d;
            }
        }
    }
}

