/*
 * Decompiled with CFR 0.152.
 */
package in.xiandan.countdowntimer;

import android.os.Handler;
import in.xiandan.countdowntimer.ITimerSupport;
import in.xiandan.countdowntimer.OnCountDownTimerListener;
import in.xiandan.countdowntimer.TimerState;
import java.util.Timer;
import java.util.TimerTask;

public class CountDownTimerSupport
implements ITimerSupport {
    private Timer mTimer;
    private Handler mHandler;
    private long mMillisInFuture;
    private long mCountDownInterval;
    private long mMillisUntilFinished;
    private OnCountDownTimerListener mOnCountDownTimerListener;
    private TimerState mTimerState = TimerState.FINISH;

    @Deprecated
    public CountDownTimerSupport() {
        this.mHandler = new Handler();
    }

    public CountDownTimerSupport(long millisInFuture, long countDownInterval) {
        this.setMillisInFuture(millisInFuture);
        this.setCountDownInterval(countDownInterval);
        this.mHandler = new Handler();
    }

    @Override
    public void start() {
        if (this.mTimer == null && this.mTimerState != TimerState.START) {
            this.mTimer = new Timer();
            this.mTimer.scheduleAtFixedRate(this.createTimerTask(), 0L, this.mCountDownInterval);
            this.mTimerState = TimerState.START;
        }
    }

    @Override
    public void pause() {
        if (this.mTimer != null && this.mTimerState == TimerState.START) {
            this.cancelTimer();
            this.mTimerState = TimerState.PAUSE;
        }
    }

    @Override
    public void resume() {
        if (this.mTimerState == TimerState.PAUSE) {
            this.start();
        }
    }

    @Override
    public void stop() {
        this.stopTimer(true);
    }

    @Override
    public void reset() {
        if (this.mTimer != null) {
            this.cancelTimer();
        }
        this.mMillisUntilFinished = this.mMillisInFuture;
        this.mTimerState = TimerState.FINISH;
    }

    private void stopTimer(final boolean cancel) {
        if (this.mTimer != null) {
            this.cancelTimer();
            this.mMillisUntilFinished = this.mMillisInFuture;
            this.mTimerState = TimerState.FINISH;
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (CountDownTimerSupport.this.mOnCountDownTimerListener != null) {
                        if (cancel) {
                            CountDownTimerSupport.this.mOnCountDownTimerListener.onCancel();
                        } else {
                            CountDownTimerSupport.this.mOnCountDownTimerListener.onFinish();
                        }
                    }
                }
            });
        }
    }

    private void cancelTimer() {
        this.mTimer.cancel();
        this.mTimer.purge();
        this.mTimer = null;
    }

    public boolean isStart() {
        return this.mTimerState == TimerState.START;
    }

    public boolean isFinish() {
        return this.mTimerState == TimerState.FINISH;
    }

    @Deprecated
    public void setMillisInFuture(long millisInFuture) {
        this.mMillisUntilFinished = this.mMillisInFuture = millisInFuture;
    }

    @Deprecated
    public void setCountDownInterval(long countDownInterval) {
        this.mCountDownInterval = countDownInterval;
    }

    public void setOnCountDownTimerListener(OnCountDownTimerListener listener) {
        this.mOnCountDownTimerListener = listener;
    }

    public long getMillisUntilFinished() {
        return this.mMillisUntilFinished;
    }

    public TimerState getTimerState() {
        return this.mTimerState;
    }

    protected TimerTask createTimerTask() {
        return new TimerTask(){
            private long startTime = -1L;

            @Override
            public void run() {
                if (this.startTime < 0L) {
                    this.startTime = this.scheduledExecutionTime() - (CountDownTimerSupport.this.mMillisInFuture - CountDownTimerSupport.this.mMillisUntilFinished);
                    CountDownTimerSupport.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (CountDownTimerSupport.this.mOnCountDownTimerListener != null) {
                                CountDownTimerSupport.this.mOnCountDownTimerListener.onTick(CountDownTimerSupport.this.mMillisUntilFinished);
                            }
                        }
                    });
                } else {
                    CountDownTimerSupport.this.mMillisUntilFinished = CountDownTimerSupport.this.mMillisInFuture - (this.scheduledExecutionTime() - this.startTime);
                    CountDownTimerSupport.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (CountDownTimerSupport.this.mOnCountDownTimerListener != null) {
                                CountDownTimerSupport.this.mOnCountDownTimerListener.onTick(CountDownTimerSupport.this.mMillisUntilFinished);
                            }
                        }
                    });
                    if (CountDownTimerSupport.this.mMillisUntilFinished <= 0L) {
                        CountDownTimerSupport.this.stopTimer(false);
                    }
                }
            }
        };
    }
}

