/*
 * Decompiled with CFR 0.152.
 */
package in.shadowfax.proswipebutton;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.ColorInt;
import android.support.annotation.Dimension;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import in.shadowfax.proswipebutton.Constants;
import in.shadowfax.proswipebutton.R;
import in.shadowfax.proswipebutton.UiUtils;

public class ProSwipeButton
extends RelativeLayout {
    private Context context;
    private View view;
    private GradientDrawable gradientDrawable;
    private RelativeLayout contentContainer;
    private TextView contentTv;
    private ImageView arrow1;
    private ImageView arrow2;
    private LinearLayout arrowHintContainer;
    private ProgressBar progressBar;
    private CharSequence btnText = "BUTTON";
    @ColorInt
    private int textColorInt;
    @ColorInt
    private int bgColorInt;
    @ColorInt
    private int arrowColorInt;
    private float btnRadius = Constants.BTN_INIT_RADIUS;
    @Dimension
    private float textSize = Constants.DEFAULT_TEXT_SIZE;
    @Nullable
    private OnSwipeListener swipeListener = null;
    private float swipeDistance = 0.85f;

    public ProSwipeButton(Context context) {
        super(context);
        this.context = context;
        this.init();
    }

    public ProSwipeButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.setAttrs(context, attrs);
        this.init();
    }

    public ProSwipeButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        this.setAttrs(context, attrs);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAttrs(Context context, AttributeSet attrs) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ProSwipeButton, 0, 0);
        try {
            String btnString = a.getString(R.styleable.ProSwipeButton_btn_text);
            if (btnString != null) {
                this.btnText = btnString;
            }
            this.textColorInt = a.getColor(R.styleable.ProSwipeButton_text_color, ContextCompat.getColor((Context)context, (int)17170443));
            this.bgColorInt = a.getColor(R.styleable.ProSwipeButton_bg_color, ContextCompat.getColor((Context)context, (int)R.color.proswipebtn_red));
            this.arrowColorInt = a.getColor(R.styleable.ProSwipeButton_arrow_color, ContextCompat.getColor((Context)context, (int)R.color.proswipebtn_translucent_white));
            this.btnRadius = a.getFloat(R.styleable.ProSwipeButton_btn_radius, (float)Constants.BTN_INIT_RADIUS);
            this.textSize = a.getDimensionPixelSize(R.styleable.ProSwipeButton_text_size, (int)Constants.DEFAULT_TEXT_SIZE);
        }
        finally {
            a.recycle();
        }
    }

    public void init() {
        LayoutInflater inflater = LayoutInflater.from((Context)this.context);
        this.view = inflater.inflate(R.layout.view_proswipebtn, (ViewGroup)this, true);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.contentContainer = (RelativeLayout)this.view.findViewById(R.id.relativeLayout_swipeBtn_contentContainer);
        this.arrowHintContainer = (LinearLayout)this.view.findViewById(R.id.linearLayout_swipeBtn_hintContainer);
        this.contentTv = (TextView)this.view.findViewById(R.id.tv_btnText);
        this.arrow1 = (ImageView)this.view.findViewById(R.id.iv_arrow1);
        this.arrow2 = (ImageView)this.view.findViewById(R.id.iv_arrow2);
        this.tintArrowHint();
        this.contentTv.setText(this.btnText);
        this.contentTv.setTextColor(this.textColorInt);
        this.contentTv.setTextSize(0, this.textSize);
        this.gradientDrawable = new GradientDrawable();
        this.gradientDrawable.setShape(0);
        this.gradientDrawable.setCornerRadius(this.btnRadius);
        this.setBackgroundColor(this.bgColorInt);
        this.updateBackground();
        this.setupTouchListener();
    }

    private void setupTouchListener() {
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: {
                        return true;
                    }
                    case 2: {
                        if (event.getX() > (float)(ProSwipeButton.this.arrowHintContainer.getWidth() / 2) && event.getX() + (float)(ProSwipeButton.this.arrowHintContainer.getWidth() / 2) < (float)ProSwipeButton.this.getWidth() && (event.getX() < ProSwipeButton.this.arrowHintContainer.getX() + (float)ProSwipeButton.this.arrowHintContainer.getWidth() || ProSwipeButton.this.arrowHintContainer.getX() != 0.0f)) {
                            ProSwipeButton.this.arrowHintContainer.setX(event.getX() - (float)(ProSwipeButton.this.arrowHintContainer.getWidth() / 2));
                        }
                        if (ProSwipeButton.this.arrowHintContainer.getX() + (float)ProSwipeButton.this.arrowHintContainer.getWidth() > (float)ProSwipeButton.this.getWidth() && ProSwipeButton.this.arrowHintContainer.getX() + (float)(ProSwipeButton.this.arrowHintContainer.getWidth() / 2) < (float)ProSwipeButton.this.getWidth()) {
                            ProSwipeButton.this.arrowHintContainer.setX((float)(ProSwipeButton.this.getWidth() - ProSwipeButton.this.arrowHintContainer.getWidth()));
                        }
                        if (event.getX() < (float)(ProSwipeButton.this.arrowHintContainer.getWidth() / 2) && ProSwipeButton.this.arrowHintContainer.getX() > 0.0f) {
                            ProSwipeButton.this.arrowHintContainer.setX(0.0f);
                        }
                        return true;
                    }
                    case 1: {
                        if (ProSwipeButton.this.arrowHintContainer.getX() + (float)ProSwipeButton.this.arrowHintContainer.getWidth() > (float)ProSwipeButton.this.getWidth() * ProSwipeButton.this.swipeDistance) {
                            ProSwipeButton.this.performSuccessfulSwipe();
                        } else if (ProSwipeButton.this.arrowHintContainer.getX() <= 0.0f) {
                            ProSwipeButton.this.startFwdAnim();
                        } else {
                            ProSwipeButton.this.animateHintBack();
                        }
                        return true;
                    }
                }
                return false;
            }
        });
    }

    private void performSuccessfulSwipe() {
        if (this.swipeListener != null) {
            this.swipeListener.onSwipeConfirm();
        }
        this.morphToCircle();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.startFwdAnim();
    }

    private void animateHintBack() {
        final ValueAnimator positionAnimator = ValueAnimator.ofFloat((float[])new float[]{this.arrowHintContainer.getX(), 0.0f});
        positionAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        positionAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float x = ((Float)positionAnimator.getAnimatedValue()).floatValue();
                ProSwipeButton.this.arrowHintContainer.setX(x);
            }
        });
        positionAnimator.setDuration(200L);
        positionAnimator.start();
    }

    private void startFwdAnim() {
        TranslateAnimation animation = new TranslateAnimation(0.0f, (float)this.getMeasuredWidth(), 0.0f, 0.0f);
        animation.setInterpolator((Interpolator)new AccelerateDecelerateInterpolator());
        animation.setDuration(1000L);
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                ProSwipeButton.this.startHintInitAnim();
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.arrowHintContainer.startAnimation((Animation)animation);
    }

    private void startHintInitAnim() {
        TranslateAnimation anim2 = new TranslateAnimation((float)(-this.arrowHintContainer.getWidth()), 0.0f, 0.0f, 0.0f);
        anim2.setDuration(500L);
        this.arrowHintContainer.startAnimation((Animation)anim2);
    }

    public void performOnSwipe() {
        this.performSuccessfulSwipe();
    }

    public void morphToCircle() {
        UiUtils.animateFadeHide(this.context, (View)this.arrowHintContainer);
        this.setOnTouchListener(null);
        ObjectAnimator cornerAnimation = ObjectAnimator.ofFloat((Object)this.gradientDrawable, (String)"cornerRadius", (float[])new float[]{Constants.BTN_INIT_RADIUS, Constants.BTN_MORPHED_RADIUS});
        UiUtils.animateFadeHide(this.context, (View)this.contentTv);
        ValueAnimator widthAnimation = ValueAnimator.ofInt((int[])new int[]{this.getWidth(), UiUtils.dpToPx(50)});
        widthAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                int val = (Integer)valueAnimator.getAnimatedValue();
                ViewGroup.LayoutParams layoutParams = ProSwipeButton.this.contentContainer.getLayoutParams();
                layoutParams.width = val;
                ProSwipeButton.this.contentContainer.setLayoutParams(layoutParams);
            }
        });
        ValueAnimator heightAnimation = ValueAnimator.ofInt((int[])new int[]{this.getHeight(), UiUtils.dpToPx(50)});
        heightAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                int val = (Integer)valueAnimator.getAnimatedValue();
                ViewGroup.LayoutParams layoutParams = ProSwipeButton.this.contentContainer.getLayoutParams();
                layoutParams.height = val;
                ProSwipeButton.this.contentContainer.setLayoutParams(layoutParams);
            }
        });
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.setDuration(500L);
        animatorSet.playTogether(new Animator[]{cornerAnimation, widthAnimation, heightAnimation});
        animatorSet.start();
        this.showProgressBar();
    }

    private void morphToRect() {
        this.setupTouchListener();
        ObjectAnimator cornerAnimation = ObjectAnimator.ofFloat((Object)this.gradientDrawable, (String)"cornerRadius", (float[])new float[]{Constants.BTN_MORPHED_RADIUS, Constants.BTN_INIT_RADIUS});
        ValueAnimator widthAnimation = ValueAnimator.ofInt((int[])new int[]{UiUtils.dpToPx(50), this.getWidth()});
        widthAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                int val = (Integer)valueAnimator.getAnimatedValue();
                ViewGroup.LayoutParams layoutParams = ProSwipeButton.this.contentContainer.getLayoutParams();
                layoutParams.width = val;
                ProSwipeButton.this.contentContainer.setLayoutParams(layoutParams);
            }
        });
        ValueAnimator heightAnimation = ValueAnimator.ofInt((int[])new int[]{UiUtils.dpToPx(50), this.getWidth()});
        heightAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                int val = (Integer)valueAnimator.getAnimatedValue();
                ViewGroup.LayoutParams layoutParams = ProSwipeButton.this.contentContainer.getLayoutParams();
                layoutParams.height = val;
                ProSwipeButton.this.contentContainer.setLayoutParams(layoutParams);
            }
        });
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.setDuration(500L);
        animatorSet.playTogether(new Animator[]{cornerAnimation, widthAnimation, heightAnimation});
        animatorSet.start();
    }

    public void updateBackground() {
        if (Build.VERSION.SDK_INT >= 16) {
            this.contentContainer.setBackground((Drawable)this.gradientDrawable);
        } else {
            this.contentContainer.setBackgroundDrawable((Drawable)this.gradientDrawable);
        }
    }

    private void showProgressBar() {
        this.progressBar = new ProgressBar(this.context);
        this.progressBar.getIndeterminateDrawable().setColorFilter(ContextCompat.getColor((Context)this.context, (int)17170443), PorterDuff.Mode.SRC_IN);
        UiUtils.animateFadeHide(this.context, (View)this.contentTv);
        this.contentContainer.addView((View)this.progressBar);
    }

    public void showResultIcon(boolean isSuccess) {
        UiUtils.animateFadeHide(this.context, (View)this.progressBar);
        final ImageView failureIcon = new ImageView(this.context);
        RelativeLayout.LayoutParams icLayoutParams = new RelativeLayout.LayoutParams(UiUtils.dpToPx(50), UiUtils.dpToPx(50));
        failureIcon.setLayoutParams((ViewGroup.LayoutParams)icLayoutParams);
        failureIcon.setVisibility(8);
        Drawable icon = isSuccess ? ContextCompat.getDrawable((Context)this.context, (int)R.drawable.ic_check_circle_36dp) : ContextCompat.getDrawable((Context)this.context, (int)R.drawable.ic_cancel_full_24dp);
        failureIcon.setImageDrawable(icon);
        this.contentContainer.addView((View)failureIcon);
        UiUtils.animateFadeShow(this.context, (View)failureIcon);
        if (!isSuccess) {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    UiUtils.animateFadeHide(ProSwipeButton.this.context, (View)failureIcon);
                    ProSwipeButton.this.morphToRect();
                    ProSwipeButton.this.arrowHintContainer.setX(0.0f);
                    UiUtils.animateFadeShow(ProSwipeButton.this.context, (View)ProSwipeButton.this.arrowHintContainer);
                    UiUtils.animateFadeShow(ProSwipeButton.this.context, (View)ProSwipeButton.this.contentTv);
                }
            }, 1000L);
        }
    }

    private void tintArrowHint() {
        this.arrow1.setColorFilter(this.arrowColorInt, PorterDuff.Mode.MULTIPLY);
        this.arrow2.setColorFilter(this.arrowColorInt, PorterDuff.Mode.MULTIPLY);
    }

    public void setText(CharSequence text) {
        this.btnText = text;
        this.contentTv.setText(text);
    }

    public CharSequence getText() {
        return this.btnText;
    }

    public void setTextColor(@ColorInt int textColor) {
        this.textColorInt = textColor;
        this.contentTv.setTextColor(textColor);
    }

    @ColorInt
    public int getTextColor() {
        return this.textColorInt;
    }

    public void setBackgroundColor(@ColorInt int bgColor) {
        this.bgColorInt = bgColor;
        this.gradientDrawable.setColor(bgColor);
        this.updateBackground();
    }

    @ColorInt
    public int getBackgroundColor() {
        return this.bgColorInt;
    }

    public void setCornerRadius(float cornerRadius) {
        this.btnRadius = cornerRadius;
    }

    public float getCornerRadius() {
        return this.btnRadius;
    }

    public int getArrowColorRes() {
        return this.arrowColorInt;
    }

    public void setArrowColor(int arrowColor) {
        this.arrowColorInt = arrowColor;
        this.tintArrowHint();
    }

    public void setTextSize(@Dimension float textSize) {
        this.textSize = textSize;
        this.contentTv.setTextSize(0, textSize);
    }

    @Dimension
    public float getTextSize() {
        return this.textSize;
    }

    public void setSwipeDistance(@Dimension float swipeDistance) {
        if (swipeDistance > 1.0f) {
            swipeDistance = 1.0f;
        }
        if (swipeDistance < 0.0f) {
            swipeDistance = 0.0f;
        }
        this.swipeDistance = swipeDistance;
    }

    @Dimension
    public float getSwipeDistance() {
        return this.swipeDistance;
    }

    public void setOnSwipeListener(@Nullable OnSwipeListener customSwipeListener) {
        this.swipeListener = customSwipeListener;
    }

    public static interface OnSwipeListener {
        public void onSwipeConfirm();
    }
}

