/*
 * Decompiled with CFR 0.152.
 */
package in.kncsolutions.dhelm.candlepattern.twoline;

import in.kncsolutions.dhelm.candlebasic.BlackMarubozu;
import in.kncsolutions.dhelm.candlebasic.WhiteMarubozu;
import in.kncsolutions.dhelm.exceptions.DataException;
import in.kncsolutions.dhelm.mathcal.Mathfns;
import java.util.ArrayList;
import java.util.List;

public class BearishKicking {
    private List<Double> Open = new ArrayList<Double>();
    private List<Double> High = new ArrayList<Double>();
    private List<Double> Low = new ArrayList<Double>();
    private List<Double> Close = new ArrayList<Double>();
    private int RefLength;
    private int RefTrend;
    private double Percentage;
    private double[] trendPrior = new double[]{0.0, 0.0};
    private boolean isBearishKicking;
    private boolean inUpTrend;
    private boolean inDownTrend;

    public BearishKicking(List<Double> open, List<Double> high, List<Double> low, List<Double> close, int numLen, int numTrend, double percentage) throws DataException {
        this.Open.addAll(open);
        this.High.addAll(high);
        this.Low.addAll(low);
        this.Close.addAll(close);
        this.RefLength = numLen;
        this.RefTrend = numTrend;
        this.Percentage = percentage;
        this.isBearishKicking = false;
        this.inUpTrend = false;
        this.inDownTrend = false;
        if (this.Open.size() < (this.RefTrend + 2 > this.RefLength ? this.RefTrend + 2 : this.RefLength) || this.Open.size() != this.Close.size() || this.Open.size() != this.High.size() || this.Open.size() != this.Low.size()) {
            throw new DataException();
        }
        this.BearishKicking();
    }

    private void BearishKicking() throws DataException {
        if (new BlackMarubozu(this.Open, this.High, this.Low, this.Close).isLongBlackMarubozu(this.RefLength, this.Percentage) && new WhiteMarubozu(this.Open.subList(1, this.Open.size()), this.High.subList(1, this.High.size()), this.Low.subList(1, this.Low.size()), this.Close.subList(1, this.Close.size())).isLongWhiteMarubozu(this.RefLength, this.Percentage) && this.Open.get(0) < this.Open.get(1)) {
            this.trendPrior = Mathfns.ComputeTrendLine(this.Close.subList(2, this.RefTrend + 2), (int)this.Close.subList(2, this.RefTrend + 2).size());
            this.isBearishKicking = true;
            if (this.trendPrior[0] < 0.0) {
                this.inUpTrend = true;
            }
            if (this.trendPrior[0] > 0.0) {
                this.inDownTrend = true;
            }
        }
    }

    public boolean isBearishKicking() {
        return this.isBearishKicking;
    }

    public boolean inUpTrend() {
        if (this.isBearishKicking) {
            return this.inUpTrend;
        }
        return false;
    }

    public boolean inDownTrend() {
        if (this.isBearishKicking) {
            return this.inDownTrend;
        }
        return false;
    }
}

