/*
 * Decompiled with CFR 0.152.
 */
package in.kncsolutions.dhelm.candlepattern.oneline;

import in.kncsolutions.dhelm.candlebasic.OpeningWhiteMarubozu;
import in.kncsolutions.dhelm.exceptions.DataException;
import in.kncsolutions.dhelm.mathcal.Mathfns;
import java.util.ArrayList;
import java.util.List;

public class BullishBeltHold {
    private List<Double> Open = new ArrayList<Double>();
    private List<Double> High = new ArrayList<Double>();
    private List<Double> Low = new ArrayList<Double>();
    private List<Double> Close = new ArrayList<Double>();
    private int RefLength;
    private int RefTrend;
    private double Percentage1;
    private double Percentage2;
    private double[] trendPrior = new double[]{0.0, 0.0};
    private boolean isBullishBeltHold;

    public BullishBeltHold(List<Double> open, List<Double> high, List<Double> low, List<Double> close, int numLen, int numTrend, double p1, double p2) throws DataException {
        this.Open.addAll(open);
        this.High.addAll(high);
        this.Low.addAll(low);
        this.Close.addAll(close);
        this.RefLength = numLen;
        this.RefTrend = numTrend;
        this.Percentage1 = p1;
        this.Percentage2 = p2;
        this.isBullishBeltHold = false;
        if (this.Open.size() < (this.RefTrend + 1 > this.RefLength ? this.RefTrend + 1 : this.RefLength) || this.Open.size() != this.Close.size() || this.Open.size() != this.High.size() || this.Open.size() != this.Low.size()) {
            throw new DataException();
        }
        this.BullishBeltHold();
    }

    private void BullishBeltHold() throws DataException {
        if (new OpeningWhiteMarubozu(this.Open, this.High, this.Low, this.Close).isLongOpeningWhiteMarubozu(this.RefLength, this.Percentage1) && (this.High.get(0) - this.Close.get(0)) / (this.Close.get(0) - this.Open.get(0)) <= this.Percentage2 / 100.0) {
            this.trendPrior = Mathfns.ComputeTrendLine(this.Close.subList(1, this.RefTrend + 1), (int)this.Close.subList(1, this.RefTrend + 1).size());
            if (this.trendPrior[0] > 0.0) {
                this.isBullishBeltHold = true;
            }
        }
    }

    public boolean isBullishBeltHold() {
        return this.isBullishBeltHold;
    }
}

