/*
 * Decompiled with CFR 0.152.
 */
package in.kncsolutions.dhelm.candlebasic;

import in.kncsolutions.dhelm.exceptions.DataException;
import in.kncsolutions.dhelm.mathcal.CandleFacts;
import java.util.ArrayList;
import java.util.List;

public class HighWave {
    private List<Double> Open = new ArrayList<Double>();
    private List<Double> High = new ArrayList<Double>();
    private List<Double> Low = new ArrayList<Double>();
    private List<Double> Close = new ArrayList<Double>();
    private int RefLength;
    private double Percentage;
    private boolean isHighWave;

    public HighWave(List<Double> open, List<Double> high, List<Double> low, List<Double> close, int numLen, double percentage) throws DataException {
        this.Open.addAll(open);
        this.High.addAll(high);
        this.Low.addAll(low);
        this.Close.addAll(close);
        this.RefLength = numLen;
        this.Percentage = percentage;
        if (this.Open.size() < this.RefLength || this.Open.size() != this.Close.size() || this.Open.size() != this.High.size() || this.Open.size() != this.Low.size()) {
            throw new DataException();
        }
        this.HighWave();
    }

    private void HighWave() throws DataException {
        double avgCandleLength = CandleFacts.getAverageLength(this.High, this.Low, (int)this.RefLength);
        if (this.Open.get(0) > this.Close.get(0)) {
            if ((this.High.get(0) != this.Open.get(0) || this.Low.get(0) != this.Close.get(0)) && (this.High.get(0) - this.Open.get(0) > this.Open.get(0) - this.Close.get(0) || this.Close.get(0) - this.Low.get(0) > this.Open.get(0) - this.Close.get(0)) && this.High.get(0) - this.Low.get(0) > avgCandleLength * this.Percentage / 100.0 && (this.High.get(0) - this.Open.get(0) >= 3.0 * (this.Open.get(0) - this.Close.get(0)) || this.Close.get(0) - this.Low.get(0) >= 3.0 * (this.Open.get(0) - this.Close.get(0)))) {
                this.isHighWave = true;
            }
        } else if (this.Open.get(0) < this.Close.get(0) && (this.High.get(0) != this.Close.get(0) || this.Low.get(0) != this.Open.get(0)) && (this.High.get(0) - this.Close.get(0) > this.Close.get(0) - this.Open.get(0) || this.Open.get(0) - this.Low.get(0) > this.Close.get(0) - this.Open.get(0)) && this.High.get(0) - this.Low.get(0) > avgCandleLength * this.Percentage / 100.0 && (this.High.get(0) - this.Close.get(0) >= 3.0 * (this.Close.get(0) - this.Open.get(0)) || this.Open.get(0) - this.Low.get(0) >= 3.0 * (this.Close.get(0) - this.Open.get(0)))) {
            this.isHighWave = true;
        }
    }

    public boolean isHighWave() {
        return this.isHighWave;
    }
}

