/*
 * Decompiled with CFR 0.152.
 */
package in.kncsolutions.dhelm.candlebasic;

import in.kncsolutions.dhelm.exceptions.DataException;
import in.kncsolutions.dhelm.mathcal.CandleFacts;
import java.util.ArrayList;
import java.util.List;

public class BlackMarubozu {
    private List<Double> Open = new ArrayList<Double>();
    private List<Double> High = new ArrayList<Double>();
    private List<Double> Low = new ArrayList<Double>();
    private List<Double> Close = new ArrayList<Double>();
    private int RefBody;
    private int RefLength;
    private double Percentage;
    private boolean isBlackMarubozu;

    public BlackMarubozu(List<Double> open, List<Double> high, List<Double> low, List<Double> close) throws DataException {
        this.Open.addAll(open);
        this.High.addAll(high);
        this.Low.addAll(low);
        this.Close.addAll(close);
        if (this.Open.size() == 0 || this.Open.size() != this.Close.size() || this.Open.size() != this.High.size() || this.Open.size() != this.Low.size()) {
            throw new DataException();
        }
        this.BlackMarubozu();
    }

    private void BlackMarubozu() throws DataException {
        double avgBodyLength = CandleFacts.getAverageLength(this.Open, this.Close, (int)this.RefBody);
        double avgCandleLength = CandleFacts.getAverageLength(this.High, this.Low, (int)this.RefLength);
        if (this.Open.get(0) > this.Close.get(0) && this.High.get(0) == this.Open.get(0) && this.Low.get(0) == this.Close.get(0)) {
            this.isBlackMarubozu = true;
        }
    }

    public boolean isBlackMarubozu() {
        return this.isBlackMarubozu;
    }

    public boolean isLongBlackMarubozu(int numLen, double percentage) throws DataException {
        double avgCandleLength = CandleFacts.getAverageLength(this.High, this.Low, (int)this.RefLength);
        return this.isBlackMarubozu && this.High.get(0) - this.Low.get(0) > avgCandleLength * this.Percentage / 100.0;
    }
}

