/*
 * Decompiled with CFR 0.152.
 */
package in.kncsolutions.dhelm.candlebasic;

import in.kncsolutions.dhelm.exceptions.DataException;
import in.kncsolutions.dhelm.mathcal.CandleFacts;
import java.util.ArrayList;
import java.util.List;

public class BlackCandle {
    private List<Double> Open = new ArrayList<Double>();
    private List<Double> High = new ArrayList<Double>();
    private List<Double> Low = new ArrayList<Double>();
    private List<Double> Close = new ArrayList<Double>();
    private int RefBody;
    private int RefLength;
    private double Percentage;
    private boolean isBlackCandle;

    public BlackCandle(List<Double> open, List<Double> high, List<Double> low, List<Double> close, int numBody, int numLen, double percentage) throws DataException {
        this.Open.addAll(open);
        this.High.addAll(high);
        this.Low.addAll(low);
        this.Close.addAll(close);
        this.RefBody = numBody;
        this.RefLength = numLen;
        this.Percentage = percentage;
        this.isBlackCandle = false;
        if (this.Open.size() < (this.RefBody > this.RefLength ? this.RefBody : this.RefLength) || this.Open.size() != this.Close.size() || this.Open.size() != this.High.size() || this.Open.size() != this.Low.size()) {
            throw new DataException();
        }
        this.BlackCandle();
    }

    private void BlackCandle() throws DataException {
        double avgBodyLength = CandleFacts.getAverageLength(this.Open, this.Close, (int)this.RefBody);
        double avgCandleLength = CandleFacts.getAverageLength(this.High, this.Low, (int)this.RefLength);
        if (this.Open.get(0) > this.Close.get(0) && this.High.get(0) != this.Open.get(0) && this.Low.get(0) != this.Close.get(0) && this.High.get(0) - this.Open.get(0) < this.Open.get(0) - this.Close.get(0) && this.Close.get(0) - this.Open.get(0) < this.Open.get(0) - this.Close.get(0) && this.Open.get(0) - this.Close.get(0) < 3.0 * avgBodyLength && this.High.get(0) - this.Low.get(0) > avgCandleLength * this.Percentage / 100.0) {
            this.isBlackCandle = true;
        }
    }

    public boolean isBlackCandle() {
        return this.isBlackCandle;
    }
}

