/*
 * Decompiled with CFR 0.152.
 */
package in.arjsna.passcodeview;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Rect;
import android.util.Log;
import android.view.View;
import android.view.animation.CycleInterpolator;

public class KeyRect {
    private final View view;
    public Rect rect;
    public String value;
    public int rippleRadius = 0;
    public int requiredRadius;
    public int circleAlpha;
    private final Rect tempRect;
    public boolean hasRippleEffect = false;
    public ValueAnimator animator;
    private final int MAX_RIPPLE_ALPHA = 180;
    private InterpolatedValueListener interpolatedValueListener;
    private int animationLeftRepeatCount = 2;
    private int animationRightRepeatCount = 2;
    private int cycleCount = 4;
    private RippleAnimListener rippleAnimListener;

    public KeyRect(View view, Rect rect, String value) {
        this.view = view;
        this.rect = rect;
        this.tempRect = new Rect(rect);
        this.value = value;
        this.requiredRadius = (this.rect.right - this.rect.left) / 4;
        this.setUpAnimator();
    }

    private void setUpAnimator() {
        this.animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, this.requiredRadius});
        this.animator.setDuration(400L);
        final int circleAlphaOffset = 180 / this.requiredRadius;
        this.animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                if (KeyRect.this.hasRippleEffect) {
                    float animatedValue = ((Float)animation.getAnimatedValue()).floatValue();
                    KeyRect.this.rippleRadius = (int)animatedValue;
                    Log.i((String)"Ripple start", (String)("radius " + KeyRect.this.rippleRadius));
                    KeyRect.this.circleAlpha = (int)(180.0f - animatedValue * (float)circleAlphaOffset);
                    KeyRect.this.interpolatedValueListener.onValueUpdated();
                }
            }
        });
        this.animator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                KeyRect.this.hasRippleEffect = true;
            }

            public void onAnimationEnd(Animator animation) {
                KeyRect.this.hasRippleEffect = false;
                KeyRect.this.rippleRadius = 0;
                KeyRect.this.rippleAnimListener.onEnd();
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setError() {
        ValueAnimator goLeftAnimator = ValueAnimator.ofInt((int[])new int[]{0, 5});
        goLeftAnimator.setInterpolator((TimeInterpolator)new CycleInterpolator(2.0f));
        goLeftAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                KeyRect.this.rect.left += ((Integer)animation.getAnimatedValue()).intValue();
                KeyRect.this.rect.right += ((Integer)animation.getAnimatedValue()).intValue();
                KeyRect.this.view.invalidate();
            }
        });
        goLeftAnimator.start();
    }

    public void setOnValueUpdateListener(InterpolatedValueListener listener) {
        this.interpolatedValueListener = listener;
    }

    public void playRippleAnim(RippleAnimListener listener) {
        this.rippleAnimListener = listener;
        this.setOnValueUpdateListener(new InterpolatedValueListener(){

            @Override
            public void onValueUpdated() {
                KeyRect.this.view.invalidate(KeyRect.this.rect);
            }
        });
        this.rippleAnimListener.onStart();
        this.animator.start();
    }

    public static interface RippleAnimListener {
        public void onStart();

        public void onEnd();
    }

    public static interface InterpolatedValueListener {
        public void onValueUpdated();
    }
}

