/*
 * Decompiled with CFR 0.152.
 */
package in.arjsna.passcodeview;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import in.arjsna.passcodeview.KeyRect;
import in.arjsna.passcodeview.R;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PassCodeView
extends View {
    private boolean DEBUG = false;
    private final int KEYS_COUNT = 12;
    private final String eraseChar = "\u232b";
    private final int KEY_PAD_COLS = 3;
    private final int KEY_PAD_ROWS = 4;
    private int digits;
    private int filledCount = 0;
    private Bitmap filledDrawable;
    private Bitmap emptyDrawable;
    private Paint paint;
    private int DEFAULT_DRAWABLE_DIM;
    private int DEFAULT_VIEW_HEIGHT = 200;
    private int digitVerticalPadding;
    private int drawableWidth;
    private int drawableHeight;
    private int drawableStartX;
    private int drawableStartY;
    private int digitHorizontalPadding;
    private int kpStartX;
    private int kpStartY;
    private ArrayList<KeyRect> keyRects = new ArrayList();
    private int keyWidth;
    private int keyHeight;
    private String passCodeText = "";
    private TextChangeListener textChangeListener;
    private boolean skipKeyDraw = false;
    private int touchSlope = 5;
    private Map<Integer, Integer> touchXMap = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> touchYMap = new HashMap<Integer, Integer>();
    private Typeface typeFace;
    private TextPaint textPaint;
    private float keyTextSize;
    private long animDuration = 200L;
    private Paint circlePaint;
    private boolean dividerVisible;
    private float dividerStartX;
    private float dividerStartY;
    private float dividerEndX;
    private float dividerEndY;
    private Context context;

    public PassCodeView(Context context) {
        super(context);
        this.init(context, null, 0, 0);
    }

    public PassCodeView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0, 0);
    }

    public PassCodeView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public PassCodeView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.context = context;
        TypedArray values = context.getTheme().obtainStyledAttributes(attrs, R.styleable.PassCodeView, defStyleAttr, defStyleRes);
        try {
            this.digits = values.getInteger(R.styleable.PassCodeView_digits, 4);
            float digitSize = values.getDimension(R.styleable.PassCodeView_digit_size, this.getResources().getDimension(R.dimen.drawableDimen));
            this.keyTextSize = values.getDimension(R.styleable.PassCodeView_key_text_size, this.getResources().getDimension(R.dimen.key_text_size));
            this.dividerVisible = values.getBoolean(R.styleable.PassCodeView_divider_visible, true);
            this.digitHorizontalPadding = (int)values.getDimension(R.styleable.PassCodeView_digit_spacing, this.getResources().getDimension(R.dimen.digit_horizontal_padding));
            this.digitVerticalPadding = (int)values.getDimension(R.styleable.PassCodeView_digit_vertical_padding, this.getResources().getDimension(R.dimen.digit_vertical_padding));
            this.drawableWidth = (int)digitSize;
            this.drawableHeight = (int)digitSize;
            this.setFilledDrawable(values.getResourceId(R.styleable.PassCodeView_filled_drawable, -1));
            this.setEmptyDrawable(values.getResourceId(R.styleable.PassCodeView_empty_drawable, -1));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        values.recycle();
        this.preparePaint();
    }

    private void preparePaint() {
        this.paint = new Paint(1);
        this.textPaint = new TextPaint(1);
        this.circlePaint = new Paint(1);
        this.circlePaint.setStyle(Paint.Style.FILL);
        this.paint.setStyle(Paint.Style.FILL);
        this.textPaint.setStyle(Paint.Style.FILL);
        this.textPaint.setColor(Color.argb((int)255, (int)0, (int)0, (int)0));
        this.textPaint.density = this.getResources().getDisplayMetrics().density;
        this.textPaint.setTextSize(this.keyTextSize);
        this.textPaint.setTextAlign(Paint.Align.CENTER);
    }

    public void setTypeFace(Typeface typeFace) {
        if (this.typeFace != typeFace) {
            this.typeFace = typeFace;
            this.textPaint.setTypeface(typeFace);
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setKeyTextColor(int color) {
        ColorStateList colorStateList = ColorStateList.valueOf((int)color);
        this.textPaint.setColor(colorStateList.getColorForState(this.getDrawableState(), 0));
        this.invalidate();
    }

    public void setKeyTextSize(float size) {
        this.textPaint.setTextSize(size);
        this.requestLayout();
        this.invalidate();
    }

    private void computeDrawableStartXY() {
        int totalDrawableWidth = this.digits * this.drawableWidth;
        int totalPaddingWidth = this.digitHorizontalPadding * (this.digits - 1);
        int totalReqWidth = totalDrawableWidth + totalPaddingWidth;
        this.drawableStartX = this.getMeasuredWidth() / 2 - totalReqWidth / 2;
        this.drawableStartY = (this.drawableHeight + this.digitVerticalPadding) / 2 - this.drawableHeight / 2;
        this.computeKeyboardStartXY();
    }

    private void computeKeyboardStartXY() {
        this.kpStartX = 0;
        this.kpStartY = this.drawableHeight + this.digitVerticalPadding;
        this.keyWidth = this.getMeasuredWidth() / 3;
        this.keyHeight = (this.getMeasuredHeight() - (this.drawableHeight + this.digitVerticalPadding)) / 4;
        this.initialiseKeyRects();
        if (this.dividerVisible) {
            this.computeDividerPos();
        }
    }

    private void computeDividerPos() {
        float widthFactor = 10.0f;
        this.dividerStartX = (float)(this.keyWidth / 2) - widthFactor;
        this.dividerStartY = this.drawableHeight + this.digitVerticalPadding;
        this.dividerEndX = (float)(this.getMeasuredWidth() - this.keyWidth / 2) + widthFactor;
        this.dividerEndY = this.dividerStartY;
    }

    private void initialiseKeyRects() {
        this.keyRects.clear();
        int x = this.kpStartX;
        int y = this.kpStartY;
        for (int i = 1; i <= 12; ++i) {
            this.keyRects.add(new KeyRect(this, new Rect(x, y, x + this.keyWidth, y + this.keyHeight), String.valueOf(i)));
            x += this.keyWidth;
            if (i % 3 != 0) continue;
            y += this.keyHeight;
            x = this.kpStartX;
        }
        this.keyRects.get(9).setValue("");
        this.keyRects.get(10).setValue("0");
        this.keyRects.get(11).setValue("\u232b");
    }

    private Bitmap getBitmap(int resId) {
        Drawable drawable = this.getResources().getDrawable(resId);
        Canvas canvas = new Canvas();
        Bitmap bitmap = Bitmap.createBitmap((int)this.drawableWidth, (int)this.drawableHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        canvas.setBitmap(bitmap);
        drawable.setBounds(0, 0, this.drawableWidth, this.drawableHeight);
        drawable.draw(canvas);
        return bitmap;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawDigitDrawable(canvas);
        if (this.dividerVisible) {
            this.drawDivider(canvas);
        }
        this.drawKeyPad(canvas);
    }

    private void drawDivider(Canvas canvas) {
        this.paint.setAlpha(40);
        canvas.drawLine(this.dividerStartX, this.dividerStartY, this.dividerEndX, this.dividerEndY, this.paint);
    }

    private void drawKeyPad(Canvas canvas) {
        float centerHalf = (this.textPaint.descent() + this.textPaint.ascent()) / 2.0f;
        for (KeyRect rect : this.keyRects) {
            canvas.drawText(rect.value, rect.rect.exactCenterX(), rect.rect.exactCenterY() - centerHalf, (Paint)this.textPaint);
            if (rect.hasRippleEffect) {
                this.circlePaint.setAlpha(rect.circleAlpha);
                canvas.drawCircle(rect.rect.exactCenterX(), rect.rect.exactCenterY(), (float)rect.rippleRadius, this.circlePaint);
            }
            if (!this.DEBUG) continue;
            canvas.drawLine((float)rect.rect.left, (float)rect.rect.centerY(), (float)rect.rect.right, (float)rect.rect.centerY(), (Paint)this.textPaint);
            canvas.drawLine((float)rect.rect.centerX(), (float)rect.rect.top, (float)rect.rect.centerX(), (float)rect.rect.bottom, (Paint)this.textPaint);
            canvas.drawRect(rect.rect, (Paint)this.textPaint);
        }
    }

    private void drawDigitDrawable(Canvas canvas) {
        int i;
        this.paint.setAlpha(255);
        int x = this.drawableStartX;
        int y = this.drawableStartY;
        int totalContentWidth = this.drawableWidth + this.digitHorizontalPadding;
        for (i = 1; i <= this.filledCount; ++i) {
            canvas.drawBitmap(this.filledDrawable, (float)x, (float)y, this.paint);
            x += totalContentWidth;
        }
        for (i = 1; i <= this.digits - this.filledCount; ++i) {
            canvas.drawBitmap(this.emptyDrawable, (float)x, (float)y, this.paint);
            x += totalContentWidth;
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        int measuredWidth = 0;
        int measuredHeight = 0;
        if (widthMode == 0x40000000 || widthMode == Integer.MIN_VALUE) {
            measuredWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        }
        if (heightMode == 0x40000000) {
            measuredHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        } else if (heightMode == Integer.MIN_VALUE) {
            double height = (double)View.MeasureSpec.getSize((int)heightMeasureSpec) * 0.8;
            measuredHeight = (int)height;
        }
        measuredHeight = (int)Math.max((float)measuredHeight, this.getResources().getDimension(R.dimen.key_pad_min_height));
        this.setMeasuredDimension(measuredWidth, measuredHeight);
        this.computeDrawableStartXY();
    }

    private void setFilledCount(int count) {
        this.filledCount = count > this.digits ? this.digits : count;
        this.invalidate();
    }

    public boolean onTouchEvent(MotionEvent event) {
        return this.processTouch(event);
    }

    private boolean processTouch(MotionEvent event) {
        switch (event.getActionMasked()) {
            case 0: {
                int pointerDownId = event.getPointerId(event.getActionIndex());
                this.touchXMap.put(pointerDownId, (int)event.getX());
                this.touchYMap.put(pointerDownId, (int)event.getY());
                break;
            }
            case 1: {
                int pointerUpId = event.getPointerId(event.getActionIndex());
                int pointerUpIndex = event.findPointerIndex(pointerUpId);
                int eventX = (int)event.getX(pointerUpIndex);
                int eventY = (int)event.getY(pointerUpIndex);
                this.findKeyPressed(this.touchXMap.get(pointerUpId), this.touchYMap.get(pointerUpId), eventX, eventY);
                break;
            }
            case 5: {
                Log.i((String)"Pointer", (String)"down");
                int pointerActionDownId = event.getPointerId(event.getActionIndex());
                this.touchXMap.put(pointerActionDownId, (int)event.getX(event.getActionIndex()));
                this.touchYMap.put(pointerActionDownId, (int)event.getY(event.getActionIndex()));
                break;
            }
            case 6: {
                int pointerActionUpIndex = event.getActionIndex();
                int pointerActionUpId = event.getPointerId(pointerActionUpIndex);
                int eventPointerX = (int)event.getX(pointerActionUpIndex);
                int eventPointerY = (int)event.getY(pointerActionUpIndex);
                this.findKeyPressed(this.touchXMap.get(pointerActionUpId), this.touchYMap.get(pointerActionUpId), eventPointerX, eventPointerY);
                break;
            }
            case 2: 
            case 3: {
                return false;
            }
        }
        return true;
    }

    private void findKeyPressed(int downEventX, int downEventY, int upEventX, int upEventY) {
        for (final KeyRect keyRect : this.keyRects) {
            if (!keyRect.rect.contains(downEventX, downEventY) || !keyRect.rect.contains(upEventX, upEventY)) continue;
            keyRect.playRippleAnim(new KeyRect.RippleAnimListener(){

                @Override
                public void onStart() {
                    int length = PassCodeView.this.passCodeText.length();
                    if (keyRect.value.equals("\u232b")) {
                        if (length > 0) {
                            PassCodeView.this.passCodeText = PassCodeView.this.passCodeText.substring(0, PassCodeView.this.passCodeText.length() - 1);
                            PassCodeView.this.setFilledCount(PassCodeView.this.passCodeText.length());
                        }
                    } else if (!keyRect.value.isEmpty() && length < PassCodeView.this.digits) {
                        PassCodeView.this.passCodeText = PassCodeView.this.passCodeText + keyRect.value;
                        PassCodeView.this.setFilledCount(PassCodeView.this.passCodeText.length());
                    }
                }

                @Override
                public void onEnd() {
                    if (!keyRect.value.isEmpty()) {
                        PassCodeView.this.notifyListener();
                    }
                }
            });
        }
    }

    public void setEmptyDrawable(int resId) {
        this.emptyDrawable = this.getBitmap(resId);
    }

    public void setFilledDrawable(int resId) {
        this.filledDrawable = this.getBitmap(resId);
    }

    public void reset() {
        this.passCodeText = "";
        this.invalidateAndNotifyListener();
    }

    private void invalidateAndNotifyListener() {
        this.setFilledCount(this.passCodeText.length());
        Log.i((String)"New text", (String)this.passCodeText);
        if (this.textChangeListener != null) {
            this.textChangeListener.onTextChanged(this.passCodeText);
        }
    }

    private void notifyListener() {
        if (this.textChangeListener != null) {
            this.textChangeListener.onTextChanged(this.passCodeText);
        }
    }

    public void setOnTextChangeListener(TextChangeListener listener) {
        this.textChangeListener = listener;
    }

    public void removeOnTextChangeListener() {
        this.textChangeListener = null;
    }

    public void setError(boolean reset) {
        if (reset) {
            this.reset();
        }
        for (KeyRect keyRect : this.keyRects) {
            keyRect.setError();
        }
    }

    public void setDigitLength(int length) {
        this.digits = length;
        this.invalidate();
    }

    public int getDigitLength() {
        return this.digits;
    }

    public void setPassCode(String code) {
        this.passCodeText = code;
        this.setFilledCount(code.length());
        this.invalidate();
    }

    public String getPassCodeText() {
        return this.passCodeText;
    }

    public static interface TextChangeListener {
        public void onTextChanged(String var1);
    }
}

