package im.yagni.driveby.scalatest

import im.yagni.driveby.ExampleAware
import org.scalatest._
import im.yagni.driveby.tracking.TrackingIds
import im.yagni.driveby.Example
import scala.Some

trait NakedExample extends SuiteMixin with BeforeAndAfterEach with ExampleAware {
  this: Spec =>

  private var capturedExample: Option[Example] = None

  //TODO: alternatively we could use this.testNames to build a list of examples here ...
  def example = capturedExample.getOrElse(throw new RuntimeException("Spooky I'm running, yet at the same time I don't exist"))

  override def beforeEach() { doBeforeExample() }
  override def afterEach() { doAfterExample() }

  abstract protected override def runTest(testName: String, args: Args): Status = {
    capturedExample = Some(Example(testName, TrackingIds.nextExampleId))
    super.runTest(testName, args)
  }

  abstract override def withFixture(test: NoArgTest): Outcome = {
    super.withFixture(test) match {
      case failed: Failed => { doOnFailure("Failure: " + test.name); failed }
      case other => other
    }
  }
}
