/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.util.svg.primitives;

import hudson.plugins.project_inheritance.util.svg.primitives.SVGPrimitive;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGUnion
implements SVGPrimitive {
    private final LinkedList<SVGPrimitive> elements = new LinkedList();
    private volatile transient Rectangle2D.Double bounds = null;

    public SVGUnion(SVGPrimitive ... elements) {
        if (elements != null && elements.length > 0) {
            this.elements.addAll(Arrays.asList(elements));
        }
    }

    public SVGUnion(Collection<SVGPrimitive> elements) {
        if (elements != null && !elements.isEmpty()) {
            this.elements.addAll(elements);
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("u[");
        Iterator iter = this.elements.iterator();
        while (iter.hasNext()) {
            b.append(((SVGPrimitive)iter.next()).toString());
            if (!iter.hasNext()) continue;
            b.append(", ");
        }
        b.append(']');
        return b.toString();
    }

    public void addElements(SVGPrimitive ... elements) {
        if (elements == null || elements.length == 0) {
            return;
        }
        for (SVGPrimitive p : elements) {
            this.elements.add(p);
        }
    }

    public void removeElements(SVGPrimitive ... elements) {
        if (elements == null || elements.length == 0) {
            return;
        }
        HashSet<SVGPrimitive> set = new HashSet<SVGPrimitive>(Arrays.asList(elements));
        Iterator iter = this.elements.iterator();
        while (iter.hasNext()) {
            SVGPrimitive p = (SVGPrimitive)iter.next();
            if (!set.contains(p)) continue;
            iter.remove();
        }
    }

    public Collection<SVGPrimitive> getElements() {
        return Collections.unmodifiableCollection(this.elements);
    }

    @Override
    public Element render(Document doc) {
        Element g = doc.createElement("g");
        for (SVGPrimitive p : this.elements) {
            g.appendChild(p.render(doc));
        }
        return g;
    }

    @Override
    public void translate(Point2D.Double offset) {
        for (SVGPrimitive p : this.elements) {
            p.translate(offset);
        }
        this.bounds = null;
    }

    @Override
    public void moveTo(Point2D.Double pos) {
        if (pos == null) {
            return;
        }
        Rectangle2D.Double bounds = this.getBounds();
        Point2D.Double offset = new Point2D.Double(pos.x - bounds.getMinX(), pos.y - bounds.getMinY());
        for (SVGPrimitive p : this.elements) {
            p.translate(offset);
        }
        this.bounds = null;
    }

    @Override
    public void rescale(double factor, boolean applyToStyles) {
        for (SVGPrimitive p : this.elements) {
            p.rescale(factor, applyToStyles);
        }
        this.bounds = null;
    }

    @Override
    public Rectangle2D.Double getBounds() {
        if (this.bounds == null) {
            Rectangle2D.Double rect = null;
            for (SVGPrimitive p : this.elements) {
                if (rect == null) {
                    rect = p.getBounds();
                    continue;
                }
                Rectangle2D.Double newRect = new Rectangle2D.Double();
                Rectangle2D.Double.union(rect, p.getBounds(), newRect);
                rect = newRect;
            }
            this.bounds = rect;
        }
        return this.bounds;
    }

    @Override
    public List<Point2D.Double> getAttachmentPoints() {
        LinkedList<Point2D.Double> lst = new LinkedList<Point2D.Double>();
        for (SVGPrimitive p : this.elements) {
            List<Point2D.Double> plst = p.getAttachmentPoints();
            if (plst == null) continue;
            lst.addAll(p.getAttachmentPoints());
        }
        return lst;
    }
}

