/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.util.svg;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class Graph<T> {
    private final HashSet<T> nodes = new LinkedHashSet<T>();
    private final HashMap<T, HashSet<T>> edges = new LinkedHashMap<T, HashSet<T>>();

    public void addNode(T node, T ... neighbours) {
        if (node == null) {
            return;
        }
        this.nodes.add(node);
        if (neighbours == null) {
            return;
        }
        for (T n : neighbours) {
            if (n == null) continue;
            this.nodes.add(n);
            HashSet<T> eSet = this.edges.get(node);
            if (eSet == null) {
                eSet = new LinkedHashSet<T>();
            }
            eSet.add(n);
            this.edges.put(node, eSet);
        }
    }

    protected void addSingleNode(T node) {
        if (node == null) {
            return;
        }
        this.nodes.add(node);
    }

    protected void addSingleEdge(T start, T end) {
        if (start == null || end == null) {
            return;
        }
        this.nodes.add(start);
        HashSet<T> eSet = this.edges.get(start);
        if (eSet == null) {
            eSet = new LinkedHashSet<T>();
        }
        eSet.add(end);
        this.edges.put(start, eSet);
    }

    public Set<T> getNodes() {
        return Collections.unmodifiableSet(this.nodes);
    }

    public void addEdges(T node, T ... neighbours) {
        this.addNode(node, neighbours);
    }

    public Set<T> getEdgesFor(T node) {
        if (node == null) {
            return new LinkedHashSet();
        }
        if (!this.nodes.contains(node)) {
            return new LinkedHashSet();
        }
        HashSet<T> eSet = this.edges.get(node);
        if (eSet == null) {
            return new HashSet();
        }
        return eSet;
    }

    public void removeNode(T node) {
        this.nodes.remove(node);
        this.edges.remove(node);
        for (Map.Entry<T, HashSet<T>> entry : this.edges.entrySet()) {
            HashSet<T> eSet = entry.getValue();
            if (eSet == null) continue;
            eSet.remove(node);
        }
    }

    public void removeEdge(T start, T end) {
        HashSet<T> eSet = this.edges.get(start);
        if (eSet != null) {
            eSet.remove(end);
        }
    }

    public int getNumNodes() {
        return this.nodes.size();
    }

    public Set<T> getLeaves(Set<T> ignored) {
        HashSet<T> set = new HashSet<T>();
        for (Map.Entry<T, HashSet<T>> entry : this.edges.entrySet()) {
            T start = entry.getKey();
            HashSet<T> ends = entry.getValue();
            if (ignored.contains(start)) continue;
            if (ends == null || ends.isEmpty()) {
                set.add(start);
            }
            boolean hasValidEdges = false;
            for (T end : ends) {
                if (ignored.contains(end)) continue;
                hasValidEdges = true;
                break;
            }
            if (hasValidEdges) continue;
            set.add(start);
        }
        return set;
    }

    public Set<T> getMinimalOutboundEdgeNodes(Set<T> ignored) {
        LinkedHashSet<T> out = new LinkedHashSet<T>();
        int minEdges = Integer.MAX_VALUE;
        for (T node : this.nodes) {
            if (ignored != null && ignored.contains(node)) continue;
            Set<T> edges = this.getEdgesFor(node);
            int edgeCnt = 0;
            for (T edge : edges) {
                if (ignored != null && ignored.contains(edge)) continue;
                ++edgeCnt;
            }
            if (edgeCnt < minEdges) {
                minEdges = edgeCnt;
                out.clear();
                out.add(node);
                continue;
            }
            if (edgeCnt != minEdges) continue;
            out.add(node);
        }
        return out;
    }

    public Set<T> getMinimalInboundEdgeNodes(Set<T> ignored) {
        HashMap<T, Integer> bucketLookup = new HashMap<T, Integer>();
        Vector buckets = new Vector();
        buckets.add(new LinkedHashSet());
        for (T node : this.nodes) {
            if (ignored != null && ignored.contains(node)) continue;
            bucketLookup.put(node, 0);
            ((Set)buckets.get(0)).add(node);
        }
        int minBucket = 0;
        for (T node : this.nodes) {
            HashSet<T> edgePartners;
            if (ignored != null && ignored.contains(node) || (edgePartners = this.edges.get(node)) == null) continue;
            for (T edge : edgePartners) {
                if (ignored != null && ignored.contains(edge)) continue;
                Integer bucket = (Integer)bucketLookup.get(edge);
                ((Set)buckets.get(bucket)).remove(edge);
                if (bucket + 1 >= buckets.size()) {
                    buckets.add(new LinkedHashSet());
                }
                ((Set)buckets.get(bucket + 1)).add(edge);
                bucketLookup.put(edge, bucket + 1);
                if (bucket != minBucket || !((Set)buckets.get(bucket)).isEmpty()) continue;
                ++minBucket;
            }
        }
        return (Set)buckets.get(minBucket);
    }

    public Graph<T> getSpanningTree() {
        Graph<T> out = new Graph<T>();
        LinkedList<T> open = new LinkedList<T>(this.getMinimalInboundEdgeNodes(null));
        LinkedHashSet<T> visited = new LinkedHashSet<T>();
        while (!open.isEmpty()) {
            T node = open.pop();
            if (visited.contains(node)) continue;
            visited.add(node);
            out.addSingleNode(node);
            for (T child : this.getEdgesFor(node)) {
                if (child == null || visited.contains(child)) continue;
                out.addSingleEdge(node, child);
                open.push(child);
            }
        }
        return out;
    }
}

