/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.util;

import hudson.model.Hudson;
import hudson.plugins.project_inheritance.projects.creation.ProjectCreationEngine;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class Reflection {
    protected static final int MAX_STACK_DEPTH = 30;
    protected static final CachedClassResolver resolver = new CachedClassResolver(30000L);
    protected static final AssignabilityChecker assigner = new AssignabilityChecker();

    public static boolean calledFromClassNames(String ... classes) {
        return Reflection.calledFromClassNames(30, classes);
    }

    public static boolean calledFromClassNames(int maxDepth, String ... classes) {
        StackTraceElement[] stackTrace;
        if (classes == null || classes.length == 0) {
            return false;
        }
        if (maxDepth <= 0) {
            maxDepth = Integer.MAX_VALUE;
        }
        if ((stackTrace = new Throwable().getStackTrace()) == null || stackTrace.length == 0) {
            return false;
        }
        HashSet<String> clSet = new HashSet<String>(Arrays.asList(classes));
        int cnt = 0;
        int skip = 1;
        for (StackTraceElement ste : stackTrace) {
            if (skip > 0) {
                --skip;
                continue;
            }
            if (cnt++ >= maxDepth) break;
            if (!clSet.contains(ste.getClassName())) continue;
            return true;
        }
        return false;
    }

    public static boolean calledFromClass(Class<?> ... classes) {
        return Reflection.calledFromClass(30, classes);
    }

    public static boolean calledFromClass(int maxDepth, Class<?> ... classes) {
        StackTraceElement[] stackTrace;
        if (classes == null || classes.length == 0) {
            return false;
        }
        if (maxDepth <= 0) {
            maxDepth = Integer.MAX_VALUE;
        }
        if ((stackTrace = new Throwable().getStackTrace()) == null || stackTrace.length == 0) {
            return false;
        }
        Set<Class<?>> stackCls = Reflection.getClasses(maxDepth, 1, stackTrace);
        if (stackCls == null || stackCls.isEmpty()) {
            return false;
        }
        for (Class<?> inClass : classes) {
            for (Class<?> outClass : stackCls) {
                if (!assigner.isAssignableFrom(inClass, outClass)) continue;
                return true;
            }
        }
        return false;
    }

    private static Set<Class<?>> getClasses(int maxDepth, int skip, StackTraceElement[] stackTrace) {
        HashSet classSet = new HashSet();
        if (skip < 0) {
            skip = 0;
        }
        int cnt = 0;
        for (StackTraceElement ste : stackTrace) {
            if (skip > 0) {
                --skip;
                continue;
            }
            if (cnt++ >= maxDepth) break;
            Class<?> clazz = resolver.resolve(ste.getClassName());
            if (clazz == null) continue;
            classSet.add(clazz);
        }
        return classSet;
    }

    public static boolean calledFromMethod(Class<?> clazz, String ... methodNames) {
        return Reflection.calledFromMethod(clazz, 30, methodNames);
    }

    public static boolean calledFromMethod(Class<?> clazz, int maxDepth, String ... methodNames) {
        if (clazz == null || methodNames == null || methodNames.length == 0) {
            return false;
        }
        if (maxDepth <= 0) {
            maxDepth = Integer.MAX_VALUE;
        }
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        HashSet<String> methods = new HashSet<String>(Arrays.asList(methodNames));
        int cnt = 0;
        for (StackTraceElement ste : stackTrace) {
            Class<?> steClazz;
            if (cnt++ >= maxDepth) break;
            if (clazz != null && clazz != (steClazz = resolver.resolve(ste.getClassName())) || !methods.contains(ste.getMethodName())) continue;
            return true;
        }
        return false;
    }

    public static Object invokeIfPossible(Object self, String methodName, Object ... args) {
        Object out = null;
        try {
            Class[] classes = new Class[args.length];
            int i = 0;
            for (Object o : args) {
                classes[i++] = o == null ? Object.class : o.getClass();
            }
            Method m = self.getClass().getMethod(methodName, classes);
            if (m != null) {
                out = m.invoke(self, args);
            }
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
        return out;
    }

    protected static class AssignabilityChecker {
        protected final ConcurrentHashMap<Class<?>, ConcurrentHashMap<Class<?>, Boolean>> classAssignabilityMap = new ConcurrentHashMap();

        public boolean isAssignableFrom(Class<?> clazz, Class<?> other) {
            if (clazz == null || other == null) {
                return false;
            }
            if (!ProjectCreationEngine.instance.getEnableReflectionCaching()) {
                return clazz.isAssignableFrom(other);
            }
            ConcurrentHashMap<Class<Object>, Boolean> checkMap = this.classAssignabilityMap.get(clazz);
            if (checkMap == null) {
                boolean result = clazz.isAssignableFrom(other);
                checkMap = new ConcurrentHashMap();
                checkMap.put(other, result);
                this.classAssignabilityMap.putIfAbsent(clazz, checkMap);
                return result;
            }
            Boolean result = checkMap.get(other);
            if (result == null) {
                result = clazz.isAssignableFrom(other);
                checkMap.put(other, result);
                return result;
            }
            return result;
        }
    }

    protected static class CachedClassResolver {
        protected final ConcurrentHashMap<String, CacheEntry> resolveMap = new ConcurrentHashMap();
        protected final Long maxAge;

        public CachedClassResolver() {
            this(null);
        }

        public CachedClassResolver(Long maxAge) {
            this.maxAge = maxAge;
        }

        public Class<?> resolve(String className) {
            ClassLoader cl;
            if (className == null || className.isEmpty()) {
                return null;
            }
            CacheEntry entry = this.resolveMap.get(className);
            if (!(entry == null || this.maxAge != null && entry.isOlderThan(this.maxAge))) {
                return entry.clazz;
            }
            try {
                cl = Hudson.getInstance().getPluginManager().uberClassLoader;
            }
            catch (NullPointerException ex) {
                return null;
            }
            Class<?> clazz = null;
            try {
                clazz = cl.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            this.resolveMap.put(className, new CacheEntry(clazz));
            return clazz;
        }

        protected final class CacheEntry {
            public final Class<?> clazz;
            private final long cacheTime;

            public CacheEntry(Class<?> clazz) {
                this.clazz = clazz;
                this.cacheTime = System.currentTimeMillis();
            }

            public boolean isOlderThan(long age) {
                return this.cacheTime + age < System.currentTimeMillis();
            }
        }
    }
}

