/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.projects.references;

import hudson.Extension;
import hudson.plugins.project_inheritance.projects.references.AbstractProjectReference;
import hudson.plugins.project_inheritance.projects.references.Messages;
import hudson.plugins.project_inheritance.projects.references.SimpleProjectReference;
import hudson.util.FormValidation;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ProjectReference
extends SimpleProjectReference {
    public final PrioMap prioMap;

    @DataBoundConstructor
    public ProjectReference(String targetJob, int parameterPriority, int buildWrapperPriority, int builderPriority, int publisherPriority, int miscPriority) {
        super(targetJob);
        this.prioMap = new PrioMap(parameterPriority, buildWrapperPriority, builderPriority, publisherPriority, miscPriority);
    }

    public ProjectReference(String targetJob, int priority) {
        this(targetJob, priority, priority, priority, priority, priority);
    }

    public int getParameterPriority() {
        return this.prioMap.parameterPriority;
    }

    public int getBuildWrapperPriority() {
        return this.prioMap.buildWrapperPriority;
    }

    public int getBuilderPriority() {
        return this.prioMap.builderPriority;
    }

    public int getPublisherPriority() {
        return this.prioMap.publisherPriority;
    }

    public int getMiscPriority() {
        return this.prioMap.miscPriority;
    }

    @Extension
    public static class OrderedProjectReferenceDescriptor
    extends SimpleProjectReference.SimpleProjectReferenceDescriptor {
        private static final String PRIO_ERROR = "Please enter a valid priority. Negative numbers mean execute before, positive numbers (incl. 0) after  this project's entries.";

        @Override
        public String getDisplayName() {
            return Messages.ProjectReference_DisplayName();
        }

        public static FormValidation isNumber(String val, String errMsg) {
            try {
                Integer.parseInt(val);
                return FormValidation.ok();
            }
            catch (NumberFormatException ex) {
                return FormValidation.error((String)errMsg);
            }
        }

        public FormValidation doCheckParameterPriority(@QueryParameter String parameterPriority) {
            return OrderedProjectReferenceDescriptor.isNumber(parameterPriority, PRIO_ERROR);
        }

        public FormValidation doCheckBuildWrapperPriority(@QueryParameter String buildWrapperPriority) {
            return OrderedProjectReferenceDescriptor.isNumber(buildWrapperPriority, PRIO_ERROR);
        }

        public FormValidation doCheckBuilderPriority(@QueryParameter String builderPriority) {
            return OrderedProjectReferenceDescriptor.isNumber(builderPriority, PRIO_ERROR);
        }

        public FormValidation doCheckPublisherPriority(@QueryParameter String publisherPriority) {
            return OrderedProjectReferenceDescriptor.isNumber(publisherPriority, PRIO_ERROR);
        }

        public FormValidation doCheckMiscPriority(@QueryParameter String miscPriority) {
            return OrderedProjectReferenceDescriptor.isNumber(miscPriority, PRIO_ERROR);
        }
    }

    public static class PrioComparator
    implements Comparator<AbstractProjectReference> {
        private final SELECTOR sel;

        public PrioComparator(SELECTOR sel) {
            this.sel = sel;
        }

        @Override
        public int compare(AbstractProjectReference o1, AbstractProjectReference o2) {
            return this.getPrio(o1).compareTo(this.getPrio(o2));
        }

        private Integer getPrio(AbstractProjectReference ref) {
            if (!(ref instanceof ProjectReference)) {
                return 0;
            }
            ProjectReference pRef = (ProjectReference)ref;
            switch (this.sel) {
                case PARAMETER: {
                    return pRef.getParameterPriority();
                }
                case BUILD_WRAPPER: {
                    return pRef.getBuildWrapperPriority();
                }
                case BUILDER: {
                    return pRef.getBuilderPriority();
                }
                case PUBLISHER: {
                    return pRef.getPublisherPriority();
                }
                case MISC: {
                    return pRef.getMiscPriority();
                }
            }
            throw new IllegalArgumentException("Invalid priority selector");
        }

        public static int getPriorityFor(AbstractProjectReference ref, SELECTOR sel) {
            if (!(ref instanceof ProjectReference)) {
                return 0;
            }
            ProjectReference pRef = (ProjectReference)ref;
            switch (sel) {
                case BUILD_WRAPPER: {
                    return pRef.getBuildWrapperPriority();
                }
                case BUILDER: {
                    return pRef.getBuilderPriority();
                }
                case PARAMETER: {
                    return pRef.getParameterPriority();
                }
                case PUBLISHER: {
                    return pRef.getPublisherPriority();
                }
                case MISC: {
                    return pRef.getMiscPriority();
                }
            }
            return 0;
        }

        public static List<AbstractProjectReference> getSortedCopy(List<AbstractProjectReference> in, SELECTOR sel) {
            LinkedList<AbstractProjectReference> sortRefs = new LinkedList<AbstractProjectReference>(in);
            Collections.sort(sortRefs, new PrioComparator(sel));
            return sortRefs;
        }

        public static enum SELECTOR {
            PARAMETER,
            BUILD_WRAPPER,
            BUILDER,
            PUBLISHER,
            MISC;

        }
    }

    public static class PrioMap {
        public final int parameterPriority;
        public final int buildWrapperPriority;
        public final int builderPriority;
        public final int publisherPriority;
        public final int miscPriority;

        public PrioMap(int ... prio) {
            if (prio.length != 5) {
                throw new IllegalArgumentException("PrioMap expected 5 values");
            }
            this.parameterPriority = prio[0];
            this.buildWrapperPriority = prio[1];
            this.builderPriority = prio[2];
            this.publisherPriority = prio[3];
            this.miscPriority = prio[4];
        }
    }
}

