/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.projects.references;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.model.ParameterDefinition;
import hudson.plugins.project_inheritance.projects.references.AbstractProjectReference;
import hudson.plugins.project_inheritance.projects.references.Messages;
import hudson.plugins.project_inheritance.projects.references.SimpleParameterizedProjectReference;
import hudson.util.FormValidation;
import java.util.Collection;
import java.util.List;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class ParameterizedProjectReference
extends SimpleParameterizedProjectReference {
    protected String variance = null;

    public ParameterizedProjectReference(String targetJob, String variance, List<ParameterDefinition> parameters) {
        super(targetJob, parameters);
        if (StringUtils.isNotBlank((String)variance)) {
            this.variance = variance.trim();
        }
    }

    public String getVariance() {
        if (StringUtils.isBlank((String)this.variance)) {
            return null;
        }
        return this.variance;
    }

    @Extension
    public static class ParameterizedReferenceDescriptor
    extends SimpleParameterizedProjectReference.SimpleParameterizedReferenceDescriptor {
        @Override
        public String getDisplayName() {
            return Messages.ParameterizedProjectReference_DisplayName();
        }

        @Override
        public AbstractProjectReference newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String targetJob = formData.getString("targetJob");
            String variance = formData.getString("variance");
            FormValidation formValidation = this.doCheckVariance(formData.getString("variance"));
            if (formValidation.kind != FormValidation.Kind.OK) {
                throw new Descriptor.FormException(formValidation.getMessage(), "variance");
            }
            Object jParams = formData.get("parameters");
            List params = ParameterDefinition.ParameterDescriptor.newInstancesFromHeteroList((StaplerRequest)req, (Object)jParams, (Collection)ParameterDefinition.all());
            return new ParameterizedProjectReference(targetJob, variance, params);
        }

        public FormValidation doCheckVariance(@QueryParameter String value) {
            value = StringUtils.trimToNull((String)value);
            return this.validGoodName(value);
        }

        private FormValidation validGoodName(String variance) {
            if (StringUtils.isBlank((String)variance)) {
                return FormValidation.ok();
            }
            try {
                Jenkins.checkGoodName((String)variance);
                return FormValidation.ok();
            }
            catch (Failure e) {
                return FormValidation.error((String)e.getMessage());
            }
        }
    }
}

