/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.projects.inheritance;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.JobProperty;
import hudson.model.ParametersDefinitionProperty;
import hudson.plugins.project_inheritance.projects.InheritanceProject;
import hudson.plugins.project_inheritance.projects.inheritance.InheritanceSelector;
import hudson.plugins.project_inheritance.projects.parameters.InheritanceParametersDefinitionProperty;

@Extension
public class ParameterSelector
extends InheritanceSelector<JobProperty<?>> {
    private static final long serialVersionUID = 6765147898181407182L;

    @Override
    public boolean isApplicableFor(Class<?> clazz) {
        return JobProperty.class.isAssignableFrom(clazz);
    }

    @Override
    public InheritanceSelector.MODE getModeFor(Class<?> clazz) {
        if (ParametersDefinitionProperty.class.isAssignableFrom(clazz)) {
            return InheritanceSelector.MODE.MERGE;
        }
        return InheritanceSelector.MODE.NOT_RESPONSIBLE;
    }

    @Override
    public String getObjectIdentifier(JobProperty<?> obj) {
        if (obj.getClass() == ParametersDefinitionProperty.class || obj.getClass() == InheritanceParametersDefinitionProperty.class) {
            return "SINGLETON";
        }
        return null;
    }

    @Override
    public JobProperty<?> merge(JobProperty<?> prior, JobProperty<?> latter, InheritanceProject caller) {
        if (!(prior instanceof ParametersDefinitionProperty) || !(latter instanceof ParametersDefinitionProperty)) {
            return latter;
        }
        InheritanceParametersDefinitionProperty ipdp = InheritanceParametersDefinitionProperty.createMerged((ParametersDefinitionProperty)prior, (ParametersDefinitionProperty)latter);
        return ipdp;
    }

    @Override
    public JobProperty<?> handleSingleton(JobProperty<?> jp, InheritanceProject caller) {
        boolean needsCopy = false;
        if (!(jp instanceof ParametersDefinitionProperty)) {
            return jp;
        }
        ParametersDefinitionProperty pdp = (ParametersDefinitionProperty)jp;
        if (pdp instanceof InheritanceParametersDefinitionProperty) {
            if (pdp.getOwner() != caller) {
                needsCopy = true;
            }
        } else {
            needsCopy = true;
        }
        if (needsCopy) {
            InheritanceParametersDefinitionProperty ipdp = new InheritanceParametersDefinitionProperty((AbstractProject<?, ?>)(caller != null ? caller : pdp.getOwner()), pdp);
            return ipdp;
        }
        return pdp;
    }
}

