/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.projects.inheritance;

import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.plugins.project_inheritance.projects.InheritanceProject;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import jenkins.model.Jenkins;

public abstract class InheritanceSelector<T>
implements Serializable,
ExtensionPoint {
    private static final long serialVersionUID = 6297336734737162857L;

    public abstract boolean isApplicableFor(Class<?> var1);

    public abstract MODE getModeFor(Class<?> var1);

    public abstract String getObjectIdentifier(T var1);

    public abstract T merge(T var1, T var2, InheritanceProject var3);

    public abstract T handleSingleton(T var1, InheritanceProject var2);

    public final List<T> applyAgainstList(List<T> lst, InheritanceProject caller) {
        HashMap<String, LinkedList<T>> connections = new HashMap<String, LinkedList<T>>();
        block9: for (T entry : lst) {
            MODE mode = this.getModeFor(entry.getClass());
            switch (mode) {
                case NOT_RESPONSIBLE: {
                    continue block9;
                }
            }
            String id = this.getObjectIdentifier(entry);
            LinkedList<T> connLst = (LinkedList<T>)connections.get(id);
            if (connLst == null) {
                connLst = new LinkedList<T>();
            }
            connLst.add(entry);
            connections.put(id, connLst);
        }
        if (connections.isEmpty()) {
            return new LinkedList<T>(lst);
        }
        LinkedList<Object> out = new LinkedList<Object>();
        for (T entry : lst) {
            MODE mode = this.getModeFor(entry.getClass());
            if (mode == MODE.NOT_RESPONSIBLE) {
                out.add(entry);
            } else {
                LinkedList conn = (LinkedList)connections.get(this.getObjectIdentifier(entry));
                if (conn == null || conn.isEmpty()) continue;
                switch (mode) {
                    case USE_FIRST: {
                        out.add(this.handleSingleton(conn.peekFirst(), caller));
                        conn.clear();
                        break;
                    }
                    case USE_LAST: {
                        if (entry != conn.peekLast()) break;
                        out.add(this.handleSingleton(conn.peekLast(), caller));
                        conn.clear();
                        break;
                    }
                    case MULTIPLE: {
                        out.add(this.handleSingleton(entry, caller));
                        break;
                    }
                    case MERGE: {
                        if (entry != conn.peekLast()) break;
                        Object merge = conn.pollFirst();
                        while (!conn.isEmpty()) {
                            merge = this.merge(merge, conn.pollFirst(), caller);
                        }
                        out.add(this.handleSingleton(merge, caller));
                        break;
                    }
                }
            }
        }
        return out;
    }

    public static ExtensionList<InheritanceSelector> all() {
        ExtensionList isLst = Jenkins.getInstance().getExtensionList(InheritanceSelector.class);
        return isLst;
    }

    public static enum MODE {
        USE_FIRST,
        MULTIPLE,
        USE_LAST,
        MERGE,
        NOT_RESPONSIBLE;

    }
}

