/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.projects.actions.service;

import hudson.plugins.project_inheritance.projects.InheritanceProject;
import hudson.plugins.project_inheritance.projects.actions.service.InheritanceListService;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;

public final class CachingInheritanceListService
implements InheritanceListService {
    private static final Logger log = Logger.getLogger(CachingInheritanceListService.class.toString());
    private static final Comparator<InheritanceProject> JOB_COMPARATOR = new Comparator<InheritanceProject>(){

        @Override
        public int compare(InheritanceProject p1, InheritanceProject p2) {
            String s1 = p1.getFullName();
            String s2 = p2.getFullName();
            return s1.compareToIgnoreCase(s2);
        }
    };

    public CachingInheritanceListService() {
        log.info(String.format("Service %s instantiated", this.getClass().getSimpleName()));
    }

    @Override
    public List<InheritanceProject> getParentJobs(InheritanceProject myJob) {
        long startTime = System.currentTimeMillis();
        List<InheritanceProject> result = myJob.getParentProjects();
        Collections.sort(result, JOB_COMPARATOR);
        long delay = System.currentTimeMillis() - startTime;
        log.fine(String.format("Job '%s' inherits from %d other jobs (%d ms):", myJob.getFullName(), result.size(), delay));
        for (InheritanceProject job : result) {
            log.fine(String.format("\t%s", job.getFullName()));
        }
        return result;
    }

    @Override
    public List<InheritanceProject> getChildJobs(InheritanceProject myJob) {
        long startTime = System.currentTimeMillis();
        List<InheritanceProject> result = myJob.getChildrenProjects();
        Collections.sort(result, JOB_COMPARATOR);
        long delay = System.currentTimeMillis() - startTime;
        log.fine(String.format("Job '%s' is inherited by %d other jobs (%d ms):", myJob.getFullName(), result.size(), delay));
        for (InheritanceProject job : result) {
            log.fine(String.format("\t%s", job.getFullName()));
        }
        return result;
    }
}

