/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.service;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.exec.CommandLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SystemUtils.class);
    private static final String OS_NAME = SystemUtils.getSystemProperty("os.name");
    private static final boolean IS_OS_WINDOWS = SystemUtils.getOsMatchesName("Windows");
    private static final boolean IS_OS_MAC = SystemUtils.getOsMatchesName("Mac");
    private static final boolean IS_OS_LINUX = SystemUtils.getOsMatchesName("Linux") || SystemUtils.getOsMatchesName("LINUX");

    private SystemUtils() {
    }

    private static String getSystemProperty(String property) {
        try {
            return System.getProperty(property);
        }
        catch (SecurityException e) {
            LOG.error("Caught a SecurityException reading the system property '{}'.The SystemUtils property value will default to null.", (Object)property);
            return null;
        }
    }

    private static boolean getOsMatchesName(String osNamePrefix) {
        return SystemUtils.isOsNameMatch(OS_NAME, osNamePrefix);
    }

    private static boolean isOsNameMatch(String osName, String osNamePrefix) {
        return osName != null && osName.startsWith(osNamePrefix);
    }

    public static Path pathOf(String path) {
        return Paths.get(IS_OS_WINDOWS ? path.replace("\"", "") : path, new String[0]);
    }

    public static String executableName(String filename) {
        return IS_OS_WINDOWS ? filename + ".exe" : filename;
    }

    public static Function<CommandLine, CommandLine> getShellWrapperOrDefault(boolean shellWrapper) {
        if (!shellWrapper) {
            return Function.identity();
        }
        if (IS_OS_WINDOWS) {
            return SystemUtils.getWindowsShellWrapperFunc();
        }
        if (IS_OS_LINUX || IS_OS_MAC) {
            return SystemUtils.getLinuxShellWrapperFunc();
        }
        throw new IllegalStateException("Unsupported OS");
    }

    private static Function<CommandLine, CommandLine> getWindowsShellWrapperFunc() {
        return cmd -> new CommandLine("cmd").addArgument("/C").addArguments(cmd.toStrings(), false);
    }

    private static Function<CommandLine, CommandLine> getLinuxShellWrapperFunc() {
        return cmd -> {
            String originalCmd = Stream.concat(Arrays.stream(new String[]{cmd.getExecutable()}), Arrays.stream(cmd.getArguments())).collect(Collectors.joining(" "));
            return new CommandLine("/bin/sh").addArgument("-c").addArgument(originalCmd, false);
        };
    }
}

