/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.model;

import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.Label;
import guru.nidi.graphviz.attribute.MapAttributes;
import guru.nidi.graphviz.attribute.MutableAttributed;
import guru.nidi.graphviz.attribute.SimpleMutableAttributed;
import guru.nidi.graphviz.model.Compass;
import guru.nidi.graphviz.model.Link;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.Linkable;
import guru.nidi.graphviz.model.MutableLinkSource;
import guru.nidi.graphviz.model.MutablePortNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MutableNode
implements Linkable,
MutableAttributed<MutableNode>,
LinkTarget,
MutableLinkSource<MutableNode> {
    protected Label name;
    protected final List<Link> links;
    protected final MutableAttributed<MutableNode> attributes;

    MutableNode() {
        this(null, new ArrayList<Link>(), Attributes.attrs(new Attributes[0]));
    }

    protected MutableNode(Label name, List<Link> links, Attributes attributes) {
        this.links = links;
        this.attributes = new SimpleMutableAttributed<MutableNode>(this, attributes);
        this.setName(name);
    }

    public MutableNode copy() {
        return new MutableNode(this.name, new ArrayList<Link>(this.links), this.attributes.applyTo(Attributes.attrs(new Attributes[0])));
    }

    public final MutableNode setName(Label name) {
        this.name = name;
        if (name != null) {
            if (name.isExternal()) {
                this.name = Label.of("");
                this.attributes.add((Attributes)name);
            } else if (name.isHtml()) {
                this.attributes.add((Attributes)name);
            }
        }
        return this;
    }

    public MutableNode setName(String name) {
        return this.setName(Label.of(name));
    }

    public MutableNode merge(MutableNode n) {
        this.links.addAll(n.links);
        this.attributes.add((Attributes)n.attributes);
        return this;
    }

    public MutablePortNode withRecord(String record) {
        return new MutablePortNode().setNode(this).setRecord(record);
    }

    public MutablePortNode withCompass(Compass compass) {
        return new MutablePortNode().setNode(this).setCompass(compass);
    }

    @Override
    public MutableNode addLink(LinkTarget target) {
        Link link = target.linkTo();
        this.links.add(Link.between(this.from(link), link.to).with((Attributes)link.attributes));
        return this;
    }

    public MutableNode addLink(LinkTarget ... targets) {
        for (LinkTarget target : targets) {
            this.addLink(target);
        }
        return this;
    }

    public MutableNode addLink(String node) {
        return this.addLink((LinkTarget)new MutableNode().setName(node));
    }

    public MutableNode addLink(String ... nodes) {
        for (String node : nodes) {
            this.addLink(node);
        }
        return this;
    }

    @Override
    public MutableNode add(Attributes attrs) {
        this.attributes.add(attrs);
        return this;
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return this.attributes.iterator();
    }

    @Override
    public Attributes applyTo(MapAttributes attrs) {
        return this.attributes.applyTo(attrs);
    }

    @Override
    public Object get(String key) {
        return this.attributes.get(key);
    }

    private MutablePortNode from(Link link) {
        if (link.from instanceof MutablePortNode) {
            MutablePortNode f = (MutablePortNode)link.from;
            return new MutablePortNode().setNode(this).setRecord(f.record()).setCompass(f.compass());
        }
        return new MutablePortNode().setNode(this);
    }

    public Label name() {
        return this.name;
    }

    @Override
    public Collection<Link> links() {
        return this.links;
    }

    @Override
    public Link linkTo() {
        return Link.to(this);
    }

    public MutableAttributed<MutableNode> attrs() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutableNode node = (MutableNode)o;
        if (this.name != null ? !this.name.equals(node.name) : node.name != null) {
            return false;
        }
        if (this.links != null ? !this.links.equals(node.links) : node.links != null) {
            return false;
        }
        return !(this.attributes == null ? node.attributes != null : !this.attributes.equals(node.attributes));
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.links != null ? this.links.hashCode() : 0);
        result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.name + this.attributes.toString() + "->" + this.links.stream().map(l -> l.to.toString()).collect(Collectors.joining(","));
    }
}

