/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.model;

import guru.nidi.graphviz.attribute.Label;
import guru.nidi.graphviz.model.Compass;
import guru.nidi.graphviz.model.CreationContext;
import guru.nidi.graphviz.model.Graph;
import guru.nidi.graphviz.model.ImmutableGraph;
import guru.nidi.graphviz.model.ImmutablePortNode;
import guru.nidi.graphviz.model.Link;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.MutableGraph;
import guru.nidi.graphviz.model.MutableNode;
import guru.nidi.graphviz.model.MutablePortNode;
import guru.nidi.graphviz.model.Node;
import guru.nidi.graphviz.model.PortNode;

public final class Factory {
    private Factory() {
    }

    public static Graph graph() {
        return Factory.graph("");
    }

    public static Graph graph(String name) {
        return new ImmutableGraph().named(name);
    }

    public static Node node(String name) {
        return Factory.node(Label.of(name));
    }

    public static Node node(Label name) {
        return CreationContext.createNode(name);
    }

    public static PortNode port(String record) {
        return Factory.port(record, null);
    }

    public static PortNode port(Compass compass) {
        return Factory.port(null, compass);
    }

    public static PortNode port(String record, Compass compass) {
        return new ImmutablePortNode(null, record, compass);
    }

    public static MutableGraph mutGraph() {
        return new MutableGraph();
    }

    public static MutableGraph mutGraph(String name) {
        return new MutableGraph().setName(name);
    }

    public static MutableNode mutNode(String name) {
        return Factory.mutNode(Label.of(name));
    }

    public static MutableNode mutNode(Label name) {
        return CreationContext.createMutNode(name);
    }

    public static MutablePortNode mutPort(String record) {
        return new MutablePortNode().setRecord(record);
    }

    public static MutablePortNode mutPort(Compass compass) {
        return new MutablePortNode().setCompass(compass);
    }

    public static MutablePortNode mutPort(String record, Compass compass) {
        return new MutablePortNode().setRecord(record).setCompass(compass);
    }

    public static Link to(Node node) {
        return Link.to(node);
    }

    public static Link to(LinkTarget node) {
        return Link.to(node);
    }

    public static Link between(LinkSource from, LinkTarget to) {
        return Link.between(from, to);
    }
}

