/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.AbstractJsGraphvizEngine;
import guru.nidi.graphviz.engine.GraphvizException;
import guru.nidi.graphviz.engine.IoUtils;
import guru.nidi.graphviz.engine.Options;
import guru.nidi.graphviz.engine.ResultHandler;
import java.io.InputStream;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class GraphvizJdkEngine
extends AbstractJsGraphvizEngine {
    private static final ScriptEngine ENGINE = new ScriptEngineManager().getEngineByExtension("js");
    private static final ThreadLocal<ResultHandler> HANDLER = new ThreadLocal();

    public GraphvizJdkEngine() {
        super(false);
        String version = System.getProperty("java.version");
        if (version.startsWith("1.8.0_") && Integer.parseInt(version.substring(6)) < 40) {
            throw new GraphvizException("You are using an old version of java 1.8. Please update it.");
        }
    }

    @Override
    protected String jsExecute(String jsCall) {
        try {
            if (HANDLER.get() == null) {
                HANDLER.set(new ResultHandler());
            }
            ENGINE.eval("var handler = graphviz.resultHandler();" + jsCall);
            return HANDLER.get().waitFor();
        }
        catch (ScriptException e) {
            throw new GraphvizException("Problem executing graphviz", e);
        }
    }

    @Override
    protected void doInit() throws Exception {
        try (InputStream api = this.getClass().getResourceAsStream("/net/arnx/nashorn/lib/promise.js");){
            ENGINE.eval(IoUtils.readStream(api));
        }
        ENGINE.eval(this.jsVizCode("2.0.0"));
        ENGINE.eval("var graphviz = Java.type('guru.nidi.graphviz.engine.GraphvizJdkEngine');function result(r){ handler.setResult(r); }function error(r){ handler.setError(r); }");
        ENGINE.eval(this.jsInitEnv());
        this.execute("digraph g { a -> b; }", Options.create());
    }

    public static ResultHandler resultHandler() {
        return HANDLER.get();
    }
}

