/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.AbstractJavascriptEngine;
import guru.nidi.graphviz.engine.GraphvizException;
import guru.nidi.graphviz.engine.GraphvizLoader;
import guru.nidi.graphviz.engine.ResultHandler;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;

class NashornJavascriptEngine
extends AbstractJavascriptEngine {
    private static final ScriptEngine ENGINE = new ScriptEngineManager(GraphvizLoader.classLoader()).getEngineByExtension("js");
    private static final Pattern JAVA_1_8_PATTERN = Pattern.compile("1.8.0_(\\d+).*");
    private static final Pattern JAVA_MAJOR_PATTERN = Pattern.compile("(\\d+).*");
    private final ScriptContext context = new SimpleScriptContext();
    private final ResultHandler resultHandler = new ResultHandler();

    NashornJavascriptEngine() {
        String version = System.getProperty("java.version");
        Matcher matcher18 = JAVA_1_8_PATTERN.matcher(version);
        if (matcher18.matches() && Integer.parseInt(matcher18.group(1)) < 40) {
            throw new GraphvizException("You are using an old version of java 1.8. Please update it.");
        }
        Matcher matcherMajor = JAVA_MAJOR_PATTERN.matcher(version);
        if (matcherMajor.matches() && Integer.parseInt(matcherMajor.group(1)) >= 15) {
            throw new GraphvizException("You are using a java version of 15 or newer. It does not include the Nashorn javascript engine any more. Use javascript of Graal instead by adding this dependency: org.graalvm.js:js");
        }
        this.context.getBindings(100).put("handler", (Object)this.resultHandler);
        this.eval("function result(r){ handler.setResult(r); }function error(r){ handler.setError(r); }");
    }

    @Override
    protected String execute(String js) {
        this.eval(js);
        return this.resultHandler.waitFor();
    }

    private void eval(String js) {
        try {
            ENGINE.eval(js, this.context);
        }
        catch (ScriptException e) {
            throw new GraphvizException("Problem executing javascript", e);
        }
    }
}

