/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.AbstractJavascriptEngine;
import guru.nidi.graphviz.engine.GraphvizException;
import guru.nidi.graphviz.engine.ResultHandler;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.PolyglotException;

class GraalJavascriptEngine
extends AbstractJavascriptEngine {
    private final ResultHandler resultHandler = new ResultHandler();
    private final Context context = Context.newBuilder((String[])new String[]{"js"}).allowAllAccess(true).build();

    GraalJavascriptEngine() {
        this.context.getPolyglotBindings().putMember("handler", (Object)this.resultHandler);
        this.eval("function result(r){ Polyglot.import('handler').setResult(r); }function error(r){ Polyglot.import('handler').setError(r); }");
    }

    @Override
    protected String execute(String js) {
        try {
            this.eval(js);
            return this.resultHandler.waitFor();
        }
        catch (PolyglotException e) {
            throw new GraphvizException("Problem executing javascript", e);
        }
    }

    private void eval(String code) {
        this.context.eval("js", (CharSequence)code);
    }
}

