/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.EngineResult;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.GraphvizPostProcessor;
import guru.nidi.graphviz.engine.Options;
import guru.nidi.graphviz.engine.ProcessOptions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SvgSizeAdjuster
implements GraphvizPostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SvgSizeAdjuster.class);
    private static final Pattern SVG_PATTERN = Pattern.compile("<svg width=\"(?<width>\\d+)(?<unit>p[tx])\" height=\"(?<height>\\d+)p[tx]\"(?<between>.*?>\\R<g.*?)transform=\"scale\\((?<scaleX>[0-9.]+) (?<scaleY>[0-9.]+)\\)", 32);

    SvgSizeAdjuster() {
    }

    @Override
    public EngineResult postProcess(EngineResult result, Options options, ProcessOptions procOptions) {
        if (options.format != Format.SVG && options.format != Format.SVG_STANDALONE && options.format != Format.PNG) {
            return result;
        }
        return result.mapString(s -> this.doPostProcess((String)s, procOptions, options.format != Format.SVG_STANDALONE));
    }

    private String doPostProcess(String result, ProcessOptions procOptions, boolean prefix) {
        String unprefixed = prefix ? SvgSizeAdjuster.withoutPrefix(result) : result;
        return SvgSizeAdjuster.pointsToPixels(unprefixed, procOptions.dpi, procOptions.width, procOptions.height, procOptions.scale);
    }

    private static String withoutPrefix(String svg) {
        int pos = svg.indexOf("<svg ");
        return pos < 0 ? svg : svg.substring(pos);
    }

    private static String pointsToPixels(String svg, double dpi, int width, int height, double scale) {
        Matcher m = SVG_PATTERN.matcher(svg);
        if (!m.find()) {
            LOG.warn("Generated SVG has not the expected format. There might be image size problems.");
            return svg;
        }
        return m.replaceFirst("<svg " + SvgSizeAdjuster.svgSize(m, width, height, scale) + m.group("between") + SvgSizeAdjuster.svgScale(m, dpi));
    }

    private static String svgSize(Matcher m, int width, int height, double scale) {
        double w = Integer.parseInt(m.group("width"));
        double h = Integer.parseInt(m.group("height"));
        if (width > 0 && height > 0) {
            w = width;
            h = height;
        } else if (width > 0) {
            h *= (double)width / w;
            w = width;
        } else if (height > 0) {
            w *= (double)height / h;
            h = height;
        }
        return "width=\"" + Math.round(w * scale) + "px\" height=\"" + Math.round(h * scale) + "px\"";
    }

    private static String svgScale(Matcher m, double dpi) {
        double pixelScale = m.group("unit").equals("px") ? 1.0 : (double)Math.round(10000.0 * dpi / 72.0) / 10000.0;
        double scaleX = Double.parseDouble(m.group("scaleX")) / pixelScale;
        double scaleY = Double.parseDouble(m.group("scaleY")) / pixelScale;
        return "transform=\"scale(" + scaleX + " " + scaleY + ")";
    }
}

