/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.parse;

import guru.nidi.graphviz.attribute.Attributed;
import guru.nidi.graphviz.attribute.Label;
import guru.nidi.graphviz.attribute.validate.AttributeValidator;
import guru.nidi.graphviz.attribute.validate.ValidatorMessage;
import guru.nidi.graphviz.model.Compass;
import guru.nidi.graphviz.model.CreationContext;
import guru.nidi.graphviz.model.Factory;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.MutableAttributed;
import guru.nidi.graphviz.model.MutableGraph;
import guru.nidi.graphviz.model.MutableNode;
import guru.nidi.graphviz.model.PortNode;
import guru.nidi.graphviz.parse.Lexer;
import guru.nidi.graphviz.parse.ParserException;
import guru.nidi.graphviz.parse.Position;
import guru.nidi.graphviz.parse.Token;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

final class ParserImpl {
    private Token token;
    private final Lexer lexer;
    private final Consumer<ValidatorMessage> messageConsumer;
    private final AttributeValidator validator;

    ParserImpl(Lexer lexer, AttributeValidator validator, Consumer<ValidatorMessage> messageConsumer) throws IOException {
        this.lexer = lexer;
        this.validator = validator;
        this.messageConsumer = messageConsumer;
        this.token = this.nextToken();
    }

    MutableGraph parse() {
        return CreationContext.use(ctx -> {
            MutableGraph graph = Factory.mutGraph();
            if (this.token.type == 9) {
                graph.setStrict(true);
                this.nextToken();
            }
            if (this.token.type == 11) {
                graph.setDirected(true);
            } else if (this.token.type != 10) {
                this.fail("'graph' or 'digraph' expected");
            }
            this.nextToken();
            if (this.token.type == 16) {
                graph.setName(this.label(this.token).toString());
                this.nextToken();
            }
            this.statementList(graph, false);
            this.assertToken(0);
            return this.deduplicateNodes(graph);
        });
    }

    private Label label(Token token) {
        return token.subtype == 4 ? Label.html(token.value) : Label.of(token.value);
    }

    private void statementList(MutableGraph graph, boolean isSub) throws IOException {
        this.assertToken(3);
        while (this.statement(graph, isSub)) {
            if (this.token.type != 1) continue;
            this.nextToken();
        }
        this.assertToken(4);
    }

    private boolean statement(MutableGraph graph, boolean isSub) throws IOException {
        Token base = this.token;
        switch (base.type) {
            case 16: {
                Position pos = this.lexer.pos.copy(-base.value.length());
                this.nextToken();
                if (this.token.type == 5) {
                    Token value = this.nextToken(16);
                    AttributeValidator.Scope scope = isSub ? AttributeValidator.Scope.SUB_GRAPH : AttributeValidator.Scope.GRAPH;
                    this.validate(base, value, scope, pos);
                    this.applyMutableAttributes(graph.graphAttrs(), Arrays.asList(base, value));
                    this.nextToken();
                } else {
                    PortNode nodeId = this.nodeId(base);
                    if (this.token.type == 18 || this.token.type == 19) {
                        this.edgeStatement(graph, nodeId);
                    } else {
                        this.nodeStatement(graph, nodeId);
                    }
                }
                return true;
            }
            case 3: 
            case 14: {
                MutableGraph sub = this.subgraph(graph.isDirected());
                if (this.token.type == 18 || this.token.type == 19) {
                    this.edgeStatement(graph, sub);
                } else {
                    graph.add((LinkSource)sub);
                }
                return true;
            }
            case 10: 
            case 12: 
            case 13: {
                this.attributeStatement(graph, isSub);
                return true;
            }
        }
        return false;
    }

    private MutableGraph subgraph(boolean directed) {
        return CreationContext.use(ctx -> {
            MutableGraph sub = Factory.mutGraph().setDirected(directed);
            if (this.token.type == 14) {
                this.nextToken();
                if (this.token.type == 16) {
                    String name = this.label(this.token).toString();
                    if (name.startsWith("cluster_")) {
                        sub.setName(name.substring(8));
                        sub.setCluster(true);
                    } else {
                        sub.setName(name);
                    }
                    this.nextToken();
                }
            }
            this.statementList(sub, true);
            return this.deduplicateNodes(sub);
        });
    }

    private MutableGraph deduplicateNodes(MutableGraph g) {
        return g.copy();
    }

    private void edgeStatement(MutableGraph graph, LinkSource linkSource) throws IOException {
        ArrayList<LinkSource> points = new ArrayList<LinkSource>();
        points.add(linkSource);
        do {
            if (graph.isDirected() && this.token.type == 18) {
                this.fail("-- used in digraph. Use -> instead.");
            }
            if (!graph.isDirected() && this.token.type == 19) {
                this.fail("-> used in graph. Use -- instead.");
            }
            this.nextToken();
            if (this.token.type == 16) {
                Token id = this.token;
                this.nextToken();
                points.add(this.nodeId(id));
                continue;
            }
            if (this.token.type != 14 && this.token.type != 3) continue;
            points.add(this.subgraph(graph.isDirected()));
        } while (this.token.type == 18 || this.token.type == 19);
        List<Token> attrs = this.token.type == 6 ? this.attributeList(AttributeValidator.Scope.EDGE) : Collections.emptyList();
        for (int i = 0; i < points.size() - 1; ++i) {
            LinkSource from = (LinkSource)points.get(i);
            LinkTarget to = (LinkTarget)points.get(i + 1);
            from.links().add(this.applyAttributes(from.linkTo(to), attrs));
            graph.add(from);
        }
    }

    private Compass compass(String name) {
        return Compass.of(name).orElseThrow(() -> new ParserException(this.lexer.pos, "Invalid compass value '" + name + "'"));
    }

    private void nodeStatement(MutableGraph graph, PortNode nodeId) throws IOException {
        MutableNode node = Factory.mutNode(nodeId.name());
        if (this.token.type == 6) {
            this.applyMutableAttributes(node, this.attributeList(AttributeValidator.Scope.NODE));
        }
        graph.add((LinkSource)node);
    }

    private PortNode nodeId(Token base) throws IOException {
        String record = null;
        Compass compass = null;
        if (this.token.type == 8) {
            String second = this.nextToken((int)16).value;
            this.nextToken();
            if (this.token.type == 8) {
                record = second;
                compass = this.compass(this.nextToken((int)16).value);
                this.nextToken();
            } else if (Compass.of(second).isPresent()) {
                compass = this.compass(second);
            } else {
                record = second;
            }
        }
        return Factory.mutNode(this.label(base)).port(record, compass);
    }

    private void attributeStatement(MutableGraph graph, boolean isSub) throws IOException {
        MutableAttributed<?, ?> target = this.attributes(graph, this.token);
        AttributeValidator.Scope scope = this.scope(this.token, isSub);
        this.nextToken();
        this.applyMutableAttributes(target, this.attributeList(scope));
    }

    private void applyMutableAttributes(MutableAttributed<?, ?> attributed, List<Token> tokens) {
        for (int i = 0; i < tokens.size(); i += 2) {
            String key = tokens.get((int)i).value;
            Token value = tokens.get(i + 1);
            if ("label".equals(key) || "xlabel".equals(key) || "headlabel".equals(key) || "taillabel".equals(key)) {
                attributed.add(key, (Object)this.label(value));
                continue;
            }
            attributed.add(key, value.value);
        }
    }

    private <T extends Attributed<T, ?>> T applyAttributes(T attributed, List<Token> tokens) {
        Object res = attributed;
        for (int i = 0; i < tokens.size(); i += 2) {
            res = (Attributed)res.with(tokens.get((int)i).value, tokens.get((int)(i + 1)).value);
        }
        return res;
    }

    private MutableAttributed<?, ?> attributes(MutableGraph graph, Token token) {
        switch (token.type) {
            case 10: {
                return graph.graphAttrs();
            }
            case 12: {
                return CreationContext.get().nodeAttrs();
            }
            case 13: {
                return CreationContext.get().linkAttrs();
            }
        }
        throw new IllegalArgumentException("Unexpected token " + token);
    }

    private AttributeValidator.Scope scope(Token token, boolean isSub) {
        switch (token.type) {
            case 10: {
                return isSub ? AttributeValidator.Scope.SUB_GRAPH : AttributeValidator.Scope.GRAPH;
            }
            case 12: {
                return AttributeValidator.Scope.NODE;
            }
            case 13: {
                return AttributeValidator.Scope.EDGE;
            }
        }
        throw new IllegalArgumentException("Unexpected token " + token);
    }

    private List<Token> attributeList(AttributeValidator.Scope scope) throws IOException {
        ArrayList<Token> res = new ArrayList<Token>();
        do {
            this.assertToken(6);
            if (this.token.type == 16) {
                res.addAll(this.attrListElement(scope));
            }
            this.assertToken(7);
        } while (this.token.type == 6);
        return res;
    }

    private List<Token> attrListElement(AttributeValidator.Scope scope) throws IOException {
        ArrayList<Token> res = new ArrayList<Token>();
        do {
            Token key = this.token;
            Position pos = this.lexer.pos.copy(-key.value.length());
            this.nextToken(5);
            Token value = this.nextToken(16);
            this.validate(key, value, scope, pos);
            res.add(key);
            res.add(value);
            this.nextToken();
            if (this.token.type != 1 && this.token.type != 2) continue;
            this.nextToken();
        } while (this.token.type == 16);
        return res;
    }

    private void validate(Token key, Token value, AttributeValidator.Scope scope, Position pos) {
        this.validator.validate(key.value, value.value, scope).forEach(msg -> this.messageConsumer.accept(msg.at(pos.getLine(), pos.getCol())));
    }

    private Token nextToken() throws IOException {
        this.token = this.lexer.token();
        return this.token;
    }

    private Token nextToken(int type) throws IOException {
        this.nextToken();
        this.checkToken(type);
        return this.token;
    }

    private Token assertToken(int type) throws IOException {
        this.checkToken(type);
        return this.nextToken();
    }

    private void checkToken(int type) {
        if (this.token.type != type) {
            this.fail("'" + Token.desc(type) + "' expected");
        }
    }

    private void fail(String msg) {
        throw new ParserException(this.lexer.pos, msg);
    }
}

