/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.Engine;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.GraphvizException;
import guru.nidi.graphviz.service.SystemUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;

public final class Options {
    private static final Pattern FORMAT = Pattern.compile("format:'(.*?)'");
    private static final Pattern ENGINE = Pattern.compile("engine:'(.*?)'");
    private static final Pattern MEMORY = Pattern.compile("totalMemory:'(.*?)'");
    private static final Pattern Y_INVERT = Pattern.compile("yInvert:(.*?)[, }]");
    private static final Pattern BASE_DIR = Pattern.compile("basedir:'(.*?)'");
    private static final Pattern IMAGES = Pattern.compile("images:\\[(.*?)]");
    final Engine engine;
    final Format format;
    @Nullable
    final Integer totalMemory;
    @Nullable
    final Boolean yInvert;
    final File basedir;
    final List<Image> images;

    private Options(Engine engine, Format format, @Nullable Integer totalMemory, @Nullable Boolean yInvert, File basedir, List<Image> images) {
        this.engine = engine;
        this.format = format;
        this.totalMemory = totalMemory;
        this.yInvert = yInvert;
        this.basedir = basedir;
        this.images = images;
    }

    public static Options create() {
        return new Options(Engine.DOT, Format.SVG, null, null, new File("."), Collections.emptyList());
    }

    public static Options fromJson(String json) {
        Matcher format = FORMAT.matcher(json);
        format.find();
        Matcher engine = ENGINE.matcher(json);
        engine.find();
        Matcher memory = MEMORY.matcher(json);
        boolean hasMemory = memory.find();
        Matcher yInvert = Y_INVERT.matcher(json);
        boolean hasYInvert = yInvert.find();
        Matcher basedir = BASE_DIR.matcher(json);
        boolean hasBasedir = basedir.find();
        Matcher imgs = IMAGES.matcher(json);
        boolean hasImgs = imgs.find() && imgs.group(1).length() > 0;
        String[] imgList = hasImgs ? imgs.group(1).split("},\\{") : new String[]{};
        return new Options(Engine.valueOf(engine.group(1)), Format.valueOf(format.group(1)), hasMemory ? Integer.valueOf(Integer.parseInt(memory.group(1))) : null, hasYInvert ? Boolean.valueOf(Boolean.parseBoolean(yInvert.group(1))) : null, new File(hasBasedir ? basedir.group(1) : "."), Arrays.stream(imgList).map(Image::fromJson).collect(Collectors.toList()));
    }

    public Options engine(Engine engine) {
        return new Options(engine, this.format, this.totalMemory, this.yInvert, this.basedir, this.images);
    }

    public Options format(Format format) {
        return new Options(this.engine, format, this.totalMemory, this.yInvert, this.basedir, this.images);
    }

    public Options totalMemory(@Nullable Integer totalMemory) {
        return new Options(this.engine, this.format, totalMemory, this.yInvert, this.basedir, this.images);
    }

    public Options yInvert(@Nullable Boolean yInvert) {
        return new Options(this.engine, this.format, this.totalMemory, yInvert, this.basedir, this.images);
    }

    public Options basedir(File basedir) {
        return new Options(this.engine, this.format, this.totalMemory, this.yInvert, basedir, this.images);
    }

    public Options image(String image) {
        ArrayList<Image> imgs = new ArrayList<Image>(this.images);
        imgs.add(this.loadImage(image));
        return new Options(this.engine, this.format, this.totalMemory, this.yInvert, this.basedir, imgs);
    }

    private Image loadImage(String path) {
        if (path.startsWith("http://") || path.startsWith("https://")) {
            try {
                BufferedImage img = ImageIO.read(new URL(path));
                return new Image(path, img.getWidth(), img.getHeight());
            }
            catch (IOException e) {
                throw new GraphvizException("Problem loading image " + path, e);
            }
        }
        File file = new File(path).isAbsolute() ? new File(path) : new File(this.basedir, path);
        try {
            BufferedImage img = ImageIO.read(file);
            return new Image(SystemUtils.uriPathOf(file), img.getWidth(), img.getHeight());
        }
        catch (IOException e) {
            throw new GraphvizException("Problem loading image " + file, e);
        }
    }

    public String toJson(boolean raw) {
        String form = "format:'" + (raw ? this.format : this.format.vizName) + "'";
        String eng = ",engine:'" + (raw ? this.engine : this.engine.toString().toLowerCase(Locale.ENGLISH)) + "'";
        String mem = this.totalMemory == null ? "" : ",totalMemory:'" + this.totalMemory + "'";
        String yInv = this.yInvert == null ? "" : ",yInvert:" + this.yInvert;
        String base = ",basedir:'" + this.basedir.getAbsolutePath() + "'";
        String imgs = ",images:[" + this.images.stream().map(Image::toJson).collect(Collectors.joining(",")) + "]";
        return "{" + form + eng + mem + yInv + base + imgs + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Options options = (Options)o;
        return this.engine == options.engine && this.format == options.format && Objects.equals(this.totalMemory, options.totalMemory) && Objects.equals(this.yInvert, options.yInvert) && this.basedir.equals(options.basedir) && this.images.equals(options.images);
    }

    public String toString() {
        return "Options{engine=" + (Object)((Object)this.engine) + ", format=" + (Object)((Object)this.format) + ", totalMemory=" + this.totalMemory + ", yInvert=" + this.yInvert + ", basedir=" + this.basedir + ", images=" + this.images + '}';
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.engine, this.format, this.totalMemory, this.yInvert, this.basedir, this.images});
    }

    private static class Image {
        private static final Pattern PATH = Pattern.compile("path:'(.*?)'");
        private static final Pattern WIDTH = Pattern.compile("width:'(.*?)px'");
        private static final Pattern HEIGHT = Pattern.compile("height:'(.*?)px'");
        final String path;
        final int width;
        final int height;

        Image(String path, int width, int height) {
            this.path = path;
            this.width = width;
            this.height = height;
        }

        String toJson() {
            return "{path:'" + this.path + "',width:'" + this.width + "px',height:'" + this.height + "px'}";
        }

        static Image fromJson(String json) {
            Matcher path = PATH.matcher(json);
            path.find();
            Matcher width = WIDTH.matcher(json);
            width.find();
            Matcher height = HEIGHT.matcher(json);
            height.find();
            return new Image(path.group(1), Integer.parseInt(width.group(1)), Integer.parseInt(height.group(1)));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Image image = (Image)o;
            return this.width == image.width && this.height == image.height && this.path.equals(image.path);
        }

        public int hashCode() {
            return Objects.hash(this.path, this.width, this.height);
        }

        public String toString() {
            return "Image{path='" + this.path + '\'' + ", width=" + this.width + ", height=" + this.height + '}';
        }
    }
}

