/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.EngineResult;
import guru.nidi.graphviz.engine.Graphviz;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Format {
    PNG("svg", "png", true, true){

        @Override
        String preProcess(String src) {
            return Format.encodeXml(super.preProcess(src));
        }

        @Override
        EngineResult postProcess(Graphviz graphviz, EngineResult result) {
            return result.mapString(s -> Format.postProcessSvg(graphviz, s, true));
        }
    }
    ,
    SVG("svg", "svg", false, true){

        @Override
        String preProcess(String src) {
            return Format.encodeXml(super.preProcess(src));
        }

        @Override
        EngineResult postProcess(Graphviz graphviz, EngineResult result) {
            return result.mapString(s -> Format.postProcessSvg(graphviz, s, true));
        }
    }
    ,
    SVG_STANDALONE("svg", "svg", false, true){

        @Override
        String preProcess(String src) {
            return Format.encodeXml(super.preProcess(src));
        }

        @Override
        EngineResult postProcess(Graphviz graphviz, EngineResult result) {
            return result.mapString(s -> Format.postProcessSvg(graphviz, s, false));
        }
    }
    ,
    DOT("dot", "dot", false, false),
    XDOT("xdot", "xdot", false, false),
    PLAIN("plain", "txt", false, false),
    PLAIN_EXT("plain-ext", "txt", false, false),
    PS("ps", "ps", false, false),
    PS2("ps2", "ps", false, false),
    JSON("json", "json", false, false),
    JSON0("json0", "json", false, false);

    private static final Logger LOG;
    private static final Pattern FONT_PATTERN;
    private static final Pattern SVG_PATTERN;
    final String vizName;
    public final String fileExtension;
    final boolean image;
    final boolean svg;

    private Format(String vizName, String fileExtension, boolean image, boolean svg) {
        this.vizName = vizName;
        this.fileExtension = fileExtension;
        this.image = image;
        this.svg = svg;
    }

    String preProcess(String src) {
        return Format.replaceSubSpaces(src);
    }

    EngineResult postProcess(Graphviz graphviz, EngineResult result) {
        return result;
    }

    private static String replaceSubSpaces(String src) {
        char[] chars = src.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] >= ' ' || chars[i] == '\t' || chars[i] == '\r' || chars[i] == '\n') continue;
            chars[i] = 32;
        }
        return new String(chars);
    }

    private static String encodeXml(String src) {
        return src.replace("&", "&amp;");
    }

    private static String postProcessSvg(Graphviz graphviz, String result, boolean prefix) {
        String unprefixed = prefix ? Format.withoutPrefix(result) : result;
        String pixelSized = Format.pointsToPixels(unprefixed, graphviz.dpi(), graphviz.width, graphviz.height, graphviz.scale);
        return graphviz.fontAdjust == 1.0 ? pixelSized : Format.fontAdjusted(pixelSized, graphviz.fontAdjust);
    }

    private static String withoutPrefix(String svg) {
        int pos = svg.indexOf("<svg ");
        return pos < 0 ? svg : svg.substring(pos);
    }

    private static String pointsToPixels(String svg, double dpi, int width, int height, double scale) {
        Matcher m = SVG_PATTERN.matcher(svg);
        if (!m.find()) {
            LOG.warn("Generated SVG has not the expected format. There might be image size problems.");
            return svg;
        }
        return m.replaceFirst("<svg " + Format.svgSize(m, width, height, scale) + m.group("between") + Format.svgScale(m, dpi));
    }

    private static String svgSize(Matcher m, int width, int height, double scale) {
        double w = Integer.parseInt(m.group("width"));
        double h = Integer.parseInt(m.group("height"));
        if (width > 0 && height > 0) {
            w = width;
            h = height;
        } else if (width > 0) {
            h *= (double)width / w;
            w = width;
        } else if (height > 0) {
            w *= (double)height / h;
            h = height;
        }
        return "width=\"" + Math.round(w * scale) + "px\" height=\"" + Math.round(h * scale) + "px\"";
    }

    private static String svgScale(Matcher m, double dpi) {
        double pixelScale = m.group("unit").equals("px") ? 1.0 : (double)Math.round(10000.0 * dpi / 72.0) / 10000.0;
        double scaleX = Double.parseDouble(m.group("scaleX")) / pixelScale;
        double scaleY = Double.parseDouble(m.group("scaleY")) / pixelScale;
        return "transform=\"scale(" + scaleX + " " + scaleY + ")";
    }

    private static String fontAdjusted(String svg, double fontAdjust) {
        Matcher m = FONT_PATTERN.matcher(svg);
        StringBuffer s = new StringBuffer();
        while (m.find()) {
            String rep;
            try {
                rep = "font-size=\"" + Double.parseDouble(m.group(1)) * fontAdjust + "\"";
            }
            catch (NumberFormatException e) {
                rep = m.group();
            }
            m.appendReplacement(s, rep);
        }
        m.appendTail(s);
        return s.toString();
    }

    static {
        LOG = LoggerFactory.getLogger(Format.class);
        FONT_PATTERN = Pattern.compile("font-size=\"(.*?)\"");
        SVG_PATTERN = Pattern.compile("<svg width=\"(?<width>\\d+)(?<unit>p[tx])\" height=\"(?<height>\\d+)p[tx]\"(?<between>.*?>\\R<g.*?)transform=\"scale\\((?<scaleX>[0-9.]+) (?<scaleY>[0-9.]+)\\)", 32);
    }
}

