/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.GraphvizEngine;
import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGraphvizEngine
implements GraphvizEngine {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractGraphvizEngine.class);
    protected static final Pattern IMG_SRC = Pattern.compile("<img .*?src\\s*=\\s*['\"]([^'\"]*)");
    protected static final Pattern IMAGE_ATTR = Pattern.compile("\"?image\"?\\s*=\\s*\"(.*?)\"");
    private final boolean sync;

    protected AbstractGraphvizEngine(boolean sync) {
        this.sync = sync;
    }

    @Override
    public void init(Consumer<GraphvizEngine> onOk, Consumer<GraphvizEngine> onError) {
        if (this.sync) {
            this.initTask(onOk, onError);
        } else {
            new Thread(() -> this.initTask(onOk, onError)).start();
        }
    }

    private void initTask(Consumer<GraphvizEngine> onOk, Consumer<GraphvizEngine> onError) {
        try {
            this.doInit();
            onOk.accept(this);
        }
        catch (Exception e) {
            LOG.info("Could not initialize {}", (Object)this, (Object)e);
            this.close();
            onError.accept(this);
        }
    }

    protected String replacePaths(String src, Pattern pattern, Function<String, String> replacer) {
        Matcher matcher = pattern.matcher(src);
        StringBuilder s = new StringBuilder();
        int last = 0;
        while (matcher.find()) {
            String attr = matcher.group(1);
            s.append(src, last, matcher.start(1));
            s.append(replacer.apply(attr));
            last = matcher.end(1);
        }
        return s.append(src.substring(last)).toString();
    }

    protected String replacePath(String path, File basedir) {
        return path.startsWith("http://") || path.startsWith("https://") || new File(path).isAbsolute() ? path : new File(basedir, path).getAbsolutePath();
    }

    @Override
    public void close() {
    }

    protected abstract void doInit() throws IOException;

    protected void throwingInit() {
        try {
            this.doInit();
        }
        catch (Exception e) {
            LOG.info("Could not initialize {}", (Object)this, (Object)e);
        }
    }

    public String toString() {
        return this.getClass().getName();
    }
}

