/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.uPnPClient;

import com.github.kilianB.DaemonThread;
import com.github.kilianB.NetworkUtil;
import com.github.kilianB.StringUtil;
import com.github.kilianB.sonos.ParserHelper;
import com.github.kilianB.uPnPClient.Subscription;
import com.github.kilianB.uPnPClient.UPnPEvent;
import com.github.kilianB.uPnPClient.UPnPEventListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.apache.commons.text.StringEscapeUtils;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class UPnPDevice {
    private static final int INCOMPATIBLE_HEADER_FIELDS = 400;
    private static final int PRECONDITION_FAILED = 412;
    private static final String ACKNOWLEDGEMENT = "HTTP/1.1 200 OK\r\nServer: Linux UPnP/1.0 Sonos/42.2-52113 (WDCR:Microsoft Windows NT 10.0.16299)\r\nConnection: close\r\n\r\n";
    private static final String BAD_REQUEST = "HTTP/1.1 400 Bad Request\r\nServer: Linux UPnP/1.0 Sonos/42.2-52113 (WDCR:Microsoft Windows NT 10.0.16299)\r\nConnection: close\r\n\r\n";
    private static final byte[] ACKNOWLEDGEMENT_MESSAGE = "HTTP/1.1 200 OK\r\nServer: Linux UPnP/1.0 Sonos/42.2-52113 (WDCR:Microsoft Windows NT 10.0.16299)\r\nConnection: close\r\n\r\n".getBytes();
    private static final byte[] BAD_REQUEST_MESSAGE = "HTTP/1.1 400 Bad Request\r\nServer: Linux UPnP/1.0 Sonos/42.2-52113 (WDCR:Microsoft Windows NT 10.0.16299)\r\nConnection: close\r\n\r\n".getBytes();
    private static final Logger LOGGER = Logger.getLogger(UPnPDevice.class.getName());
    private InetAddress deviceAddress;
    private HashMap<String, String> deviceInfo;
    private ServerSocket eventCallbackSocket;
    private ConcurrentHashMap<String, Subscription> subscriptions = new ConcurrentHashMap();
    private ScheduledExecutorService scheduler;
    private Thread uPnPEventSocketListener = new DaemonThread(() -> {
        while (!Thread.interrupted() && !this.eventCallbackSocket.isClosed()) {
            try {
                Socket eventSocket = this.eventCallbackSocket.accept();
                new Thread(() -> this.parseUPnPEvent(eventSocket)).start();
            }
            catch (IOException e) {
                if (e instanceof SocketException && e.getMessage().contains("closed")) {
                    LOGGER.info("UPnPEvent socket closed");
                    continue;
                }
                e.printStackTrace();
            }
            catch (Exception exception) {
                LOGGER.severe(MessageFormat.format("An error occured during upnp event callback. Trying to recover: {0}", exception));
            }
        }
    }, "UPnP Event Socket Listener");
    private Thread handleShutdown = new Thread(() -> {
        if (this.eventCallbackSocket != null && !this.eventCallbackSocket.isClosed()) {
            Iterator<Map.Entry<String, Subscription>> keyIter = this.subscriptions.entrySet().iterator();
            while (keyIter.hasNext()) {
                Subscription subscription = keyIter.next().getValue();
                this.unsubscribe(subscription);
            }
            try {
                this.eventCallbackSocket.close();
                this.scheduler.shutdownNow();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }, "UPnP Shutdown");

    public UPnPDevice(InetAddress inetAddress, HashMap<String, String> deviceInfo) {
        this.deviceAddress = inetAddress;
        this.deviceInfo = deviceInfo;
        Runtime.getRuntime().addShutdownHook(this.handleShutdown);
    }

    public InetAddress getIP() {
        return this.deviceAddress;
    }

    public String getLocation() {
        return this.deviceInfo.get("LOCATION");
    }

    public String getServer() {
        return this.deviceInfo.get("SERVER");
    }

    public String getSearchTarget() {
        return this.deviceInfo.get("ST");
    }

    public String getUniqueServiceName() {
        return this.deviceInfo.get("USN");
    }

    public String getField(String fieldID) {
        return this.deviceInfo.get(fieldID);
    }

    public Map<String, String> getFields() {
        return Collections.unmodifiableMap(this.deviceInfo);
    }

    public String subscribe(UPnPEventListener eventHandler, String servicePath) throws IOException {
        return this.subscribe(eventHandler, servicePath, 3600);
    }

    public String subscribe(final UPnPEventListener eventHandler, String servicePath, int renewalPeriod) throws IOException {
        final Subscription subscription = new Subscription(eventHandler, servicePath, renewalPeriod);
        LOGGER.fine(MessageFormat.format("Subscribe to {0}", servicePath));
        this.initSubscription();
        String callbackAddress = "http://" + this.eventCallbackSocket.getInetAddress().getHostAddress() + ":" + this.eventCallbackSocket.getLocalPort();
        StringBuilder eventSubscription = new StringBuilder("SUBSCRIBE ").append(servicePath).append(" HTTP/1.1\r\n").append("HOST: ").append(this.deviceAddress.getHostAddress() + ":1400").append("\r\n").append("USER-AGENT: ").append("Linux UPnP/1.0 Sonos/42.2-52113 (WDCR:Microsoft Windows NT 10.0.16299)").append("\r\n").append("CALLBACK: <").append(callbackAddress).append(">\r\n").append("NT: upnp:event\r\n").append("TIMEOUT: Second-").append(renewalPeriod).append("\r\n\r\n");
        try (Socket socket = new Socket(this.deviceAddress, 1400);){
            InputStream is = socket.getInputStream();
            OutputStream os = socket.getOutputStream();
            os.write(eventSubscription.toString().getBytes());
            os.flush();
            socket.setSoTimeout(30000);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String response = NetworkUtil.dumpReader(br);
            String token = ParserHelper.findOne("SID: (.*)", response);
            String timeout = ParserHelper.findOne("TIMEOOT:(.*)", response);
            LOGGER.fine(MessageFormat.format("Token: {0}", token));
            LOGGER.fine("Actual timeout: " + timeout);
            subscription.setToken(token);
            this.subscriptions.put(token, subscription);
            if (renewalPeriod > 0) {
                int timeoutPeriod = renewalPeriod - 60;
                LOGGER.fine("Schedule renewal interval" + timeoutPeriod);
                if (timeoutPeriod < 0) {
                    LOGGER.severe("Invalid renewal period specified. UPnP Subscription timeout has to be in the range of (60,]");
                    String string = null;
                    return string;
                }
                if (timeoutPeriod < 60) {
                    LOGGER.warning("Short renewal periods are discouraged.");
                }
                ScheduledFuture<?> eventResubscription = this.scheduler.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            UPnPDevice.this.renewSubscription(subscription);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            subscription.getRenewalFuture().cancel(false);
                            eventHandler.renewalFailed(e);
                            UPnPDevice.this.subscriptions.remove(subscription.getToken());
                        }
                    }
                }, timeoutPeriod, timeoutPeriod, TimeUnit.SECONDS);
                subscription.setRenewalFuture(eventResubscription);
            }
            String string = token;
            return string;
        }
    }

    private void initSubscription() throws IOException {
        if (this.eventCallbackSocket == null) {
            InetAddress host = NetworkUtil.resolveSiteLocalAddress();
            this.eventCallbackSocket = new ServerSocket(0, 50, host);
            this.uPnPEventSocketListener.start();
            this.scheduler = Executors.newScheduledThreadPool(1);
        }
    }

    private void renewSubscription(Subscription subscription) throws IOException {
        System.out.println("Renew subscription");
        StringBuilder eventRenewalMessage = new StringBuilder("SUBSCRIBE ").append(subscription.getServicePath()).append(" HTTP/1.1\r\n").append("HOST: ").append(this.deviceAddress.getHostAddress() + ":1400").append("\r\n").append("SID: ").append(subscription.getToken()).append("r\n").append("TIMEOUT: Second-" + subscription.getRenewalInterval()).append("\r\n\r\n");
        try (Socket socket = new Socket(this.deviceAddress, 1400);){
            InputStream is = socket.getInputStream();
            OutputStream os = socket.getOutputStream();
            os.write(eventRenewalMessage.toString().getBytes());
            os.flush();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String response = NetworkUtil.dumpReader(br);
            if (response.contains("200 OK")) {
                String resend = ParserHelper.findOne("SID: (.*)", response);
                System.out.println("Resubscription: " + response);
                LOGGER.fine(MessageFormat.format("Token: {0}", resend));
                System.out.println("Token:" + resend);
            } else if (response.contains("412 Precondition Failed")) {
                UPnPEventListener eventHandler = subscription.getEventListener();
                eventHandler.renewalFailed(new Exception("412 Precondition Failed"));
                subscription.getRenewalFuture().cancel(true);
                eventHandler.eventSubscriptionExpired();
            } else {
                LOGGER.severe("Unspecified error during renew subscription");
            }
        }
    }

    public boolean unsubscribeFromToken(String sid) {
        if (this.subscriptions.containsKey(sid)) {
            return this.unsubscribe(this.subscriptions.get(sid));
        }
        LOGGER.warning(MessageFormat.format("Could not unsubscribe from {0} because no subscription was found fitting this criteria.", sid));
        return false;
    }

    public boolean unsubscribeFromSerice(String servicePath) {
        Optional<Map.Entry> subscriptionEntry = this.subscriptions.entrySet().parallelStream().filter(entry -> ((Subscription)entry.getValue()).getServicePath().equals(servicePath)).findFirst();
        if (subscriptionEntry.isPresent()) {
            return this.unsubscribe((Subscription)subscriptionEntry.get().getValue());
        }
        LOGGER.warning(MessageFormat.format("Could not unsubscribe from {0} because no subscription was found fitting this criteria.", servicePath));
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean unsubscribe(Subscription subscription) {
        StringBuilder eventCancelation = new StringBuilder("UNSUBSCRIBE ").append(subscription.getServicePath()).append(" HTTP/1.1\r\n").append("HOST: ").append(this.deviceAddress.getHostAddress() + ":1400").append("\r\n").append("SID: ").append(subscription.getToken()).append("\r\n\r\n");
        try (Socket socket = new Socket(this.deviceAddress, 1400);){
            InputStream is = socket.getInputStream();
            OutputStream os = socket.getOutputStream();
            os.write(eventCancelation.toString().getBytes());
            os.flush();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String response = NetworkUtil.dumpReader(br);
            if (response.contains("200 OK")) {
                subscription.getRenewalFuture().cancel(false);
                this.subscriptions.remove(subscription.getToken());
                subscription.getEventListener().unsubscribed();
                boolean bl = true;
                return bl;
            }
            LOGGER.severe(MessageFormat.format("failed to unsubscribe: {0}", response));
            return false;
        }
        catch (IOException io) {
            LOGGER.severe("failed to unsubscribe");
            LOGGER.severe(io.toString());
        }
        return false;
    }

    private void parseUPnPEvent(Socket socket) {
        block11: {
            try {
                socket.setSoTimeout(300);
                String event = NetworkUtil.collectSocketWithTimeout(socket, 200);
                OutputStream output = socket.getOutputStream();
                if (StringUtil.isEscaped(event)) {
                    event = StringEscapeUtils.unescapeXml((String)event);
                }
                LOGGER.fine("Event: " + event);
                if (event.length() > 0) {
                    int indexXMLStart = event.indexOf("<e:propertyset");
                    String headers = event.substring(0, indexXMLStart);
                    String bodyContent = event.substring(indexXMLStart);
                    String httpHeader = ParserHelper.findOne("(.*)\\R", headers);
                    String host = ParserHelper.findOne("HOST: (.*)", headers);
                    String connection = ParserHelper.findOne("CONNECTION: (.*)", headers);
                    int contentLength = Integer.parseInt(ParserHelper.findOne("CONTENT-LENGTH: (.*)", headers));
                    String nt = ParserHelper.findOne("NT: (.*)", headers);
                    String nts = ParserHelper.findOne("NTS: (.*)", headers);
                    String sid = ParserHelper.findOne("SID: (.*)", headers);
                    String transferEncoding = ParserHelper.findOne("TRANSFER-ENCODING: \"(.*)\"", headers);
                    int seq = Integer.parseInt(ParserHelper.findOne("SEQ: (.*)", headers));
                    Subscription subscription = this.subscriptions.get(sid);
                    if (subscription == null) {
                        LOGGER.severe("Received UPnP event does not match any expected sid");
                        return;
                    }
                    if (seq <= subscription.getSequenceCount()) {
                        LOGGER.warning("UPnP Event arrived in wrong order.");
                    } else {
                        subscription.setSequenceCount(seq);
                    }
                    if (transferEncoding.contains("chunked")) {
                        LOGGER.warning("implement chunk decoding");
                    }
                    SAXBuilder saxBuilder = new SAXBuilder();
                    try {
                        Document xml = saxBuilder.build((Reader)new StringReader(bodyContent));
                        output.write(ACKNOWLEDGEMENT_MESSAGE);
                        socket.getInputStream().close();
                        output.close();
                        socket.close();
                        if (seq == 0) {
                            UPnPEvent upnpEvent = new UPnPEvent(httpHeader, host, connection, contentLength, nt, nts, sid, seq, xml);
                            subscription.getEventListener().initialEventReceived(upnpEvent);
                            break block11;
                        }
                        UPnPEvent upnpEvent = new UPnPEvent(httpHeader, host, connection, contentLength, nt, nts, sid, seq, xml);
                        subscription.getEventListener().eventReceived(upnpEvent);
                    }
                    catch (JDOMException e) {
                        output.write(BAD_REQUEST_MESSAGE);
                        System.out.println("Malformed answer : " + bodyContent + "\n" + event);
                        output.flush();
                        socket.getInputStream().close();
                        output.close();
                        socket.close();
                        LOGGER.severe(e.toString());
                    }
                    break block11;
                }
                LOGGER.warning("Dropped UDP package. Try again");
                output.write(BAD_REQUEST_MESSAGE);
                output.flush();
                socket.getInputStream().close();
                output.close();
                socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void deinit() {
        this.scheduler.shutdownNow();
    }

    public static UPnPDevice createDummyDevice(String ip) throws UnknownHostException {
        return new UPnPDevice(InetAddress.getByName(ip), null);
    }
}

