/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.sonos;

import com.github.kilianB.exception.SonosControllerException;
import com.github.kilianB.sonos.SonosDevice;
import com.github.kilianB.uPnPClient.SimpleDeviceDiscovery;
import com.github.kilianB.uPnPClient.UPnPDevice;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SonosDiscovery {
    private static final int DEFAULT_SCAN_DURATION = 2;
    private static final String SONOS_URN = "urn:schemas-upnp-org:device:ZonePlayer:1";

    private SonosDiscovery() {
    }

    public static List<SonosDevice> discover() throws IOException {
        return SonosDiscovery.discover(2);
    }

    public static List<SonosDevice> discover(int scanDuration) throws IOException {
        List<UPnPDevice> source = SimpleDeviceDiscovery.discoverDevices(1, scanDuration, SONOS_URN);
        ArrayList<SonosDevice> output = new ArrayList<SonosDevice>();
        for (UPnPDevice device : source) {
            output.add(new SonosDevice(device));
        }
        return Collections.unmodifiableList(output);
    }

    public static void discoverAsynch(int scanDuration, SonosDeviceFoundListener callback) {
        new Thread(() -> {
            ArrayList output = new ArrayList();
            try {
                SimpleDeviceDiscovery.discoverDevices(1, scanDuration, SONOS_URN, upnpDevice -> {
                    SonosDevice sonosDevice = new SonosDevice(upnpDevice);
                    output.add(sonosDevice);
                    callback.deviceFound(sonosDevice);
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }).start();
    }

    public static SonosDevice discoverOne() throws IOException {
        return SonosDiscovery.discoverOne(2);
    }

    public static SonosDevice discoverOne(int scanDuration) throws IOException {
        UPnPDevice source = new SimpleDeviceDiscovery().discoverDevice(scanDuration, SONOS_URN);
        if (source == null) {
            return null;
        }
        return new SonosDevice(source);
    }

    public static SonosDevice discoverByUID(String uid) throws IOException {
        return SonosDiscovery.discoverByUID(uid, 2);
    }

    public static SonosDevice discoverByUID(String uid, int scanDuration) throws IOException {
        UPnPDevice source = new SimpleDeviceDiscovery().discoverDevice(scanDuration, "uuid:" + uid);
        if (source == null) {
            return null;
        }
        return new SonosDevice(source);
    }

    public static SonosDevice discoverByName(String name) throws IOException {
        return SonosDiscovery.discoverByName(name, 2);
    }

    public static SonosDevice discoverByName(String name, int scanDuration) throws IOException {
        List<SonosDevice> sonosDevices = SonosDiscovery.discover(scanDuration);
        for (SonosDevice sonosDevice : sonosDevices) {
            try {
                if (!sonosDevice.getZoneName().equalsIgnoreCase(name)) continue;
                return sonosDevice;
            }
            catch (SonosControllerException sonosControllerException) {
            }
        }
        return null;
    }

    @FunctionalInterface
    public static interface SonosDeviceFoundListener {
        public void deviceFound(SonosDevice var1);
    }
}

