/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.sonos;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class ParserHelper {
    private ParserHelper() {
    }

    public static String findOne(String regex, String content) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(content);
        boolean haveResult = matcher.find();
        if (!haveResult) {
            return "";
        }
        return matcher.group(1);
    }

    public static List<String> findAll(String regex, String content) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(content);
        ArrayList<String> r = new ArrayList<String>();
        while (matcher.find()) {
            r.add(matcher.group(1));
        }
        return Collections.unmodifiableList(r);
    }

    public static int formatedTimestampToSeconds(String durationAsString) {
        if (!durationAsString.isEmpty()) {
            String[] parts = durationAsString.split(":");
            return Integer.parseInt(parts[0]) * 3600 + Integer.parseInt(parts[1]) * 60 + Integer.parseInt(parts[2]);
        }
        return 0;
    }

    public static String secondsToFormatedTimestamp(int seconds) {
        int hours = seconds / 3600;
        int minutes = seconds % 3600 / 60;
        int secs = seconds % 60;
        return String.format("%02d:%02d:%02d", hours, minutes, secs);
    }

    public static Element unwrapSonosEvent(Element e, Namespace namespace) {
        return e.getChild("Event", namespace).getChild("InstanceID", namespace);
    }

    public static String extractEventValue(Element e, String childName) {
        return e.getChild(childName).getAttributeValue("val");
    }

    public static String extractEventValue(Element e, String childName, Namespace namespace) {
        return e.getChild(childName, namespace).getAttributeValue("val");
    }
}

