/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.uPnPClient;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class UPnPEvent {
    private static final Namespace upnpNamespace = Namespace.getNamespace((String)"e", (String)"urn:schemas-upnp-org:event-1-0");
    private String httpHeader;
    private String host;
    private String connection;
    private int contentLength;
    private String nt;
    private String nts;
    private String sid;
    private int seq;
    private HashSet<Element> properties = new HashSet();
    private Document body;

    public UPnPEvent(String httpHeader, String host, String connection, int contentLength, String nt, String nts, String sid, int seq, Document body) {
        this.httpHeader = httpHeader;
        this.host = host;
        this.connection = connection;
        this.contentLength = contentLength;
        this.nt = nt;
        this.nts = nts;
        this.sid = sid;
        this.seq = seq;
        this.body = body;
        List propertyElements = body.getRootElement().getChildren("property", upnpNamespace);
        for (Element property : propertyElements) {
            this.properties.addAll(property.getChildren());
        }
    }

    public String getHttpHeader() {
        return this.httpHeader;
    }

    public String getHost() {
        return this.host;
    }

    public String getConnection() {
        return this.connection;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getNt() {
        return this.nt;
    }

    public String getNts() {
        return this.nts;
    }

    public String getSid() {
        return this.sid;
    }

    public int getSeq() {
        return this.seq;
    }

    public Document getBody() {
        return this.body;
    }

    public String getBodyAsString() {
        XMLOutputter xmlOut = new XMLOutputter();
        xmlOut.setFormat(Format.getPrettyFormat());
        return xmlOut.outputString(this.body);
    }

    public String toString() {
        return "UPnPEvent [httpHeader=" + this.httpHeader + ", host=" + this.host + ", connection=" + this.connection + ", contentLength=" + this.contentLength + ", nt=" + this.nt + ", nts=" + this.nts + ", sid=" + this.sid + ", seq=" + this.seq + ", body=" + this.body + "]";
    }

    public Set<Element> getProperties() {
        return Collections.unmodifiableSet(this.properties);
    }
}

