/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.sonos.listener;

import com.github.kilianB.sonos.ParserHelper;
import com.github.kilianB.sonos.SonosDevice;
import com.github.kilianB.sonos.listener.SonosEventListener;
import com.github.kilianB.uPnPClient.UPnPEvent;
import com.github.kilianB.uPnPClient.UPnPEventAdapterVerbose;
import java.util.List;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class RenderingControlListener
extends UPnPEventAdapterVerbose {
    private static final Namespace upnpRCNamespace = Namespace.getNamespace((String)"urn:schemas-upnp-org:metadata-1-0/RCS/");
    private final List<SonosEventListener> listeners;

    public RenderingControlListener(String servicePath, SonosDevice device) {
        super(servicePath);
        this.listeners = device.getEventListener();
    }

    @Override
    public void eventReceived(UPnPEvent event) {
        for (Element e : event.getProperties()) {
            Element properties = ParserHelper.unwrapSonosEvent(e, upnpRCNamespace);
            block13: for (Element ele : properties.getChildren()) {
                switch (ele.getName()) {
                    case "Volume": {
                        if (!ele.getAttributeValue("channel").equals("Master")) break;
                        int volume = Integer.parseInt(ele.getAttributeValue("val"));
                        for (SonosEventListener listener : this.listeners) {
                            listener.volumeChanged(volume);
                        }
                        continue block13;
                    }
                    case "Treble": {
                        int treble = Integer.parseInt(ele.getAttributeValue("val"));
                        for (SonosEventListener listener : this.listeners) {
                            listener.trebleChanged(treble);
                        }
                        continue block13;
                    }
                    case "Bass": {
                        int bass = Integer.parseInt(ele.getAttributeValue("val"));
                        for (SonosEventListener listener : this.listeners) {
                            listener.bassChanged(bass);
                        }
                        continue block13;
                    }
                    case "Loudness": {
                        boolean loudness = Integer.parseInt(ele.getAttributeValue("val")) != 0;
                        for (SonosEventListener listener : this.listeners) {
                            listener.loudenessChanged(loudness);
                        }
                        break;
                    }
                }
            }
        }
    }
}

