/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.naming.reference;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public abstract class SimpleReference
extends Reference {
    private static final Enumeration EMPTY_ENUMERATION = new Enumeration(){

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return new NoSuchElementException();
        }
    };

    public SimpleReference() {
        super(null);
    }

    public abstract Object getContent() throws NamingException;

    public String getClassName() {
        return "java.lang.Object";
    }

    public final String getFactoryClassName() {
        return SimpleObjectFactory.class.getName();
    }

    public final String getFactoryClassLocation() {
        return null;
    }

    public final RefAddr get(String addrType) {
        return null;
    }

    public final RefAddr get(int posn) {
        throw new ArrayIndexOutOfBoundsException(posn);
    }

    public final Enumeration getAll() {
        return EMPTY_ENUMERATION;
    }

    public final int size() {
        return 0;
    }

    public final void add(RefAddr addr) {
        throw new UnsupportedOperationException("SimpleReference has no addresses so none can be added");
    }

    public final void add(int posn, RefAddr addr) {
        throw new UnsupportedOperationException("SimpleReference has no addresses so none can be added");
    }

    public final Object remove(int posn) {
        throw new ArrayIndexOutOfBoundsException(posn);
    }

    public final void clear() {
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
    }

    public Object clone() {
        throw new UnsupportedOperationException("SimpleReference can not be cloned");
    }

    public static final class SimpleObjectFactory
    implements ObjectFactory {
        public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
            if (obj instanceof SimpleReference) {
                SimpleReference reference = (SimpleReference)obj;
                return reference.getContent();
            }
            return null;
        }
    }
}

