/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.naming.reference;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.naming.reference.SimpleAwareReference;

public class ResourceReference
extends SimpleAwareReference {
    private final String containerId;
    private final Class iface;

    public ResourceReference(String containerId, Class iface) {
        this.containerId = containerId;
        this.iface = iface;
    }

    public String getClassName() {
        return this.iface.getName();
    }

    public Object getContent() {
        Kernel kernel = this.getKernel();
        ObjectName target = null;
        try {
            target = ObjectName.getInstance(this.containerId);
        }
        catch (MalformedObjectNameException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Invalid object name in jmxRefAddr: " + this.containerId).initCause(e);
        }
        Object proxy = null;
        try {
            proxy = kernel.invoke(target, "$getResource");
        }
        catch (Exception e) {
            throw (IllegalStateException)new IllegalStateException("Could not get proxy").initCause(e);
        }
        if (proxy == null) {
            throw new IllegalStateException("Proxy not returned. Target " + this.containerId + " not started");
        }
        if (!this.iface.isAssignableFrom(proxy.getClass())) {
            Class<?> proxyClass = proxy.getClass();
            Class<?>[] interfaces = proxyClass.getInterfaces();
            StringBuffer message = new StringBuffer();
            boolean namesMatch = false;
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> anInterface = interfaces[i];
                if (!this.iface.getName().equals(anInterface.getName())) continue;
                namesMatch = true;
                message.append("Proxy implements correct interface: ").append(this.iface.getName()).append(", but classloaders differ\n");
                message.append("lookup interface classloader: ").append(this.iface.getClassLoader().toString()).append("\n");
                message.append("target interface classloader: ").append(anInterface.getClassLoader().toString()).append("\n");
                message.append("target proxy classloader: ").append(proxy.getClass().getClassLoader());
                break;
            }
            if (!namesMatch) {
                message.append("Proxy does not implement an interface named: ").append(this.iface.getName());
            }
            throw new ClassCastException(message.toString());
        }
        return proxy;
    }
}

