/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.naming.java;

import java.util.HashMap;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;
import org.apache.geronimo.kernel.ClassLoading;
import org.apache.geronimo.naming.reference.GBeanProxyReference;
import org.apache.geronimo.naming.reference.KernelReference;
import org.apache.geronimo.naming.reference.ORBReference;

public class ComponentContextBuilder {
    private static final String ENV = "env/";
    private final Map context = new HashMap();

    public Map getContext() {
        return this.context;
    }

    public void addUserTransaction(UserTransaction userTransaction) {
        this.context.put("UserTransaction", userTransaction);
    }

    public void addORB(ObjectName corbaGBeanObjectName) {
        this.context.put("ORB", new ORBReference(corbaGBeanObjectName));
    }

    public void addHandleDelegateReference(Object handleDelegateReference) {
        this.context.put("HandleDelegate", handleDelegateReference);
    }

    public void bind(String name, Object value) {
        this.context.put(ENV + name, value);
    }

    public void addEnvEntry(String name, String type, String text, ClassLoader classLoader) throws NamingException, NumberFormatException {
        Object value;
        if (text == null) {
            value = "org.apache.geronimo.kernel.Kernel".equals(type) ? new KernelReference() : null;
        } else if ("java.lang.String".equals(type)) {
            value = text;
        } else if ("java.lang.Character".equals(type)) {
            value = new Character(text.charAt(0));
        } else if ("java.lang.Boolean".equals(type)) {
            value = Boolean.valueOf(text);
        } else if ("java.lang.Byte".equals(type)) {
            value = Byte.valueOf(text);
        } else if ("java.lang.Short".equals(type)) {
            value = Short.valueOf(text);
        } else if ("java.lang.Integer".equals(type)) {
            value = Integer.valueOf(text);
        } else if ("java.lang.Long".equals(type)) {
            value = Long.valueOf(text);
        } else if ("java.lang.Float".equals(type)) {
            value = Float.valueOf(text);
        } else if ("java.lang.Double".equals(type)) {
            value = Double.valueOf(text);
        } else {
            Class clazz = null;
            try {
                clazz = ClassLoading.loadClass((String)type, (ClassLoader)classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Could not load class for env-entry " + name + ", " + type);
            }
            ObjectName objectName = null;
            try {
                objectName = ObjectName.getInstance(text);
            }
            catch (MalformedObjectNameException e) {
                throw new IllegalArgumentException("If env-entry type is not String, Character, Byte, Short, Integer, Long, Boolean, Double, or Float, the text value must be a valid ObjectName for use in a GBeanProxy: name= " + name + ", value=" + type + ", text=" + text);
            }
            value = new GBeanProxyReference(objectName, clazz);
        }
        this.context.put(ENV + name, value);
    }
}

