/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.naming.enc;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Context;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.apache.geronimo.naming.enc.AbstractReadOnlyContext;
import org.apache.geronimo.naming.enc.CachingReference;
import org.apache.geronimo.naming.enc.EnterpriseNamingContextNameParser;

public final class EnterpriseNamingContext
extends AbstractReadOnlyContext {
    private final Map localBindings;
    private final Map globalBindings;

    public static Context createEnterpriseNamingContext(Map context) throws NamingException {
        return new EnterpriseNamingContext(context);
    }

    public EnterpriseNamingContext(Map context) throws NamingException {
        super("");
        EnterpriseNamingContext.validateBindings(context);
        EnterpriseNamingContext.preprocessBindings(context);
        Node rootContext = EnterpriseNamingContext.buildTree(context);
        HashMap<String, NestedEnterpriseNamingContext> localBindings = new HashMap<String, NestedEnterpriseNamingContext>(rootContext.size());
        Iterator iterator = rootContext.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Node) {
                NestedEnterpriseNamingContext nestedContext = new NestedEnterpriseNamingContext(name, (Node)value);
                localBindings.put(name, nestedContext);
                continue;
            }
            localBindings.put(name, (NestedEnterpriseNamingContext)value);
        }
        this.localBindings = Collections.unmodifiableMap(localBindings);
        Map globalBindings = EnterpriseNamingContext.buildGlobalBindings("", localBindings);
        this.globalBindings = Collections.unmodifiableMap(globalBindings);
    }

    private static void validateBindings(Map bindings) {
        Iterator iterator = bindings.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Context) {
                throw new IllegalArgumentException("EnterpriseNamingContext can not contain a nested Context object: name=" + name);
            }
            if (!(value instanceof LinkRef)) continue;
            throw new IllegalArgumentException("EnterpriseNamingContext can not contain a nested LinkRef object: name=" + name);
        }
    }

    private static void preprocessBindings(Map bindings) {
        Iterator iterator = new HashMap(bindings).entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof Reference)) continue;
            bindings.put(name, new CachingReference(name, (Reference)value));
        }
    }

    private static Node buildTree(Map context) throws NamingException {
        Node rootContext = new Node();
        rootContext.put("env", new Node());
        Iterator iterator = context.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            Node parentContext = rootContext;
            Name compoundName = EnterpriseNamingContextNameParser.INSTANCE.parse(name);
            Enumeration<String> parts = compoundName.getAll();
            while (parts.hasMoreElements()) {
                String part = parts.nextElement();
                if (!parts.hasMoreElements()) continue;
                Node bindings = (Node)parentContext.get(part);
                if (bindings == null) {
                    bindings = new Node();
                    parentContext.put(part, bindings);
                }
                parentContext = bindings;
            }
            parentContext.put(compoundName.get(compoundName.size() - 1), value);
        }
        return rootContext;
    }

    private static Map buildGlobalBindings(String nameInNamespace, Map context) {
        String path = nameInNamespace;
        if (path.length() > 0) {
            path = path + "/";
        }
        HashMap globalBindings = new HashMap();
        Iterator iterator = context.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof NestedEnterpriseNamingContext) {
                NestedEnterpriseNamingContext nestedContext = (NestedEnterpriseNamingContext)value;
                globalBindings.putAll(EnterpriseNamingContext.buildGlobalBindings(nestedContext.getNameInNamespace(), nestedContext.localBindings));
            }
            globalBindings.put(path + name, value);
        }
        return globalBindings;
    }

    protected Map getGlobalBindings() {
        return this.globalBindings;
    }

    protected Map getLocalBindings() {
        return this.localBindings;
    }

    private static final class Node
    extends HashMap {
        private Node() {
        }
    }

    public final class NestedEnterpriseNamingContext
    extends AbstractReadOnlyContext {
        private final Map localBindings;

        public NestedEnterpriseNamingContext(String nameInNamespace, Node bindings) {
            super(nameInNamespace);
            if (nameInNamespace.length() == 0) {
                throw new IllegalArgumentException("nameInNamespace is empty");
            }
            HashMap<String, NestedEnterpriseNamingContext> localBindings = new HashMap<String, NestedEnterpriseNamingContext>(bindings.size());
            Iterator iterator = bindings.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Node) {
                    NestedEnterpriseNamingContext context = new NestedEnterpriseNamingContext(nameInNamespace + "/" + name, (Node)value);
                    localBindings.put(name, context);
                    continue;
                }
                localBindings.put(name, (NestedEnterpriseNamingContext)value);
            }
            this.localBindings = Collections.unmodifiableMap(localBindings);
        }

        protected Map getGlobalBindings() {
            return EnterpriseNamingContext.this.globalBindings;
        }

        protected Map getLocalBindings() {
            return this.localBindings;
        }
    }
}

