/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.naming.enc;

import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;
import org.apache.geronimo.naming.reference.SimpleReference;

public class CachingReference {
    private final Object lock = new Object();
    private final String fullName;
    private final Reference reference;
    private final String className;
    private Object value;

    public CachingReference(String fullName, Reference reference) {
        this.fullName = fullName;
        this.reference = reference;
        this.className = reference.getClassName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get() throws NamingException {
        Object object = this.lock;
        synchronized (object) {
            if (this.value == null) {
                this.value = this.resolveReference();
            }
            return this.value;
        }
    }

    private Object resolveReference() throws NamingException {
        if (this.reference instanceof SimpleReference) {
            try {
                return ((SimpleReference)this.reference).getContent();
            }
            catch (NamingException e) {
                throw e;
            }
            catch (Exception e) {
                throw (NamingException)new NamingException("Could not look up : " + this.fullName).initCause(e);
            }
        }
        try {
            return NamingManager.getObjectInstance(this.reference, null, null, new Hashtable());
        }
        catch (NamingException e) {
            throw e;
        }
        catch (Exception e) {
            throw (NamingException)new NamingException("Could not look up : " + this.fullName).initCause(e);
        }
    }

    public String getClassName() {
        return this.className;
    }
}

