/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.naming.enc;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import org.apache.geronimo.naming.enc.BindingResolutionException;
import org.apache.geronimo.naming.enc.CachingReference;
import org.apache.geronimo.naming.enc.EnterpriseNamingContextNameParser;

abstract class AbstractReadOnlyContext
implements Context,
Serializable {
    private final String nameInNamespace;
    private final String path;

    protected AbstractReadOnlyContext(String nameInNamespace) {
        if (nameInNamespace == null) {
            throw new NullPointerException("nameInNamespace is null");
        }
        this.nameInNamespace = nameInNamespace;
        this.path = nameInNamespace.length() > 0 ? nameInNamespace + "/" : nameInNamespace;
    }

    protected abstract Map getGlobalBindings();

    protected abstract Map getLocalBindings();

    public final Object lookup(String name) throws NamingException {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (name.length() == 0) {
            return this;
        }
        String fullName = this.path + name;
        Map globalBindings = this.getGlobalBindings();
        Object result = globalBindings.get(fullName);
        if (result == null) {
            if (fullName.indexOf(58) > 0) {
                InitialContext ctx = new InitialContext();
                return ctx.lookup(fullName);
            }
            if (new CompositeName(fullName).size() == 0) {
                return this;
            }
            throw new NameNotFoundException(fullName);
        }
        if (result instanceof CachingReference) {
            result = ((CachingReference)result).get();
        }
        return result;
    }

    public final Object lookup(Name name) throws NamingException {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        return this.lookup(name.toString());
    }

    public final Object lookupLink(Name name) throws NamingException {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        return this.lookupLink(name.toString());
    }

    public final Object lookupLink(String name) throws NamingException {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        return this.lookup(name);
    }

    public final NamingEnumeration list(String name) throws NamingException {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        Object o = this.lookup(name);
        if (o == this) {
            return this.list();
        }
        if (o instanceof AbstractReadOnlyContext) {
            return ((AbstractReadOnlyContext)o).list();
        }
        throw new NotContextException();
    }

    public final NamingEnumeration listBindings(String name) throws NamingException {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        Object o = this.lookup(name);
        if (o == this) {
            return this.listBindings();
        }
        if (o instanceof AbstractReadOnlyContext) {
            return ((AbstractReadOnlyContext)o).listBindings();
        }
        throw new NotContextException();
    }

    private NamingEnumeration list() {
        Map localBindings = this.getLocalBindings();
        return new ListEnumeration(localBindings);
    }

    private NamingEnumeration listBindings() {
        Map localBindings = this.getLocalBindings();
        return new ListBindingEnumeration(localBindings);
    }

    public final NamingEnumeration list(Name name) throws NamingException {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        return this.list(name.toString());
    }

    public final NamingEnumeration listBindings(Name name) throws NamingException {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        return this.listBindings(name.toString());
    }

    public final String getNameInNamespace() {
        return this.nameInNamespace;
    }

    public final NameParser getNameParser(Name name) {
        return EnterpriseNamingContextNameParser.INSTANCE;
    }

    public final NameParser getNameParser(String name) {
        return EnterpriseNamingContextNameParser.INSTANCE;
    }

    public final Name composeName(Name name, Name prefix) throws NamingException {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix is null");
        }
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    public final String composeName(String name, String prefix) throws NamingException {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix is null");
        }
        CompositeName result = new CompositeName(prefix);
        result.addAll(new CompositeName(name));
        return result.toString();
    }

    public final Hashtable getEnvironment() {
        return new Hashtable();
    }

    public final Object addToEnvironment(String propName, Object propVal) throws NamingException {
        throw new OperationNotSupportedException("EnterpriseNamingContext can not be modified");
    }

    public final Object removeFromEnvironment(String propName) throws NamingException {
        throw new OperationNotSupportedException("EnterpriseNamingContext can not be modified");
    }

    public final void bind(Name name, Object obj) throws NamingException {
        throw new OperationNotSupportedException("EnterpriseNamingContext can not be modified");
    }

    public final void bind(String name, Object obj) throws NamingException {
        throw new OperationNotSupportedException("EnterpriseNamingContext can not be modified");
    }

    public final void close() throws NamingException {
        throw new OperationNotSupportedException("EnterpriseNamingContext can not be modified");
    }

    public final Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException("EnterpriseNamingContext can not be modified");
    }

    public final Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("EnterpriseNamingContext can not be modified");
    }

    public final void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException("EnterpriseNamingContext can not be modified");
    }

    public final void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("EnterpriseNamingContext can not be modified");
    }

    public final void rebind(Name name, Object obj) throws NamingException {
        throw new OperationNotSupportedException("EnterpriseNamingContext can not be modified");
    }

    public final void rebind(String name, Object obj) throws NamingException {
        throw new OperationNotSupportedException("EnterpriseNamingContext can not be modified");
    }

    public final void rename(Name oldName, Name newName) throws NamingException {
        throw new OperationNotSupportedException("EnterpriseNamingContext can not be modified");
    }

    public final void rename(String oldName, String newName) throws NamingException {
        throw new OperationNotSupportedException("EnterpriseNamingContext can not be modified");
    }

    public final void unbind(Name name) throws NamingException {
        throw new OperationNotSupportedException("EnterpriseNamingContext can not be modified");
    }

    public final void unbind(String name) throws NamingException {
        throw new OperationNotSupportedException("EnterpriseNamingContext can not be modified");
    }

    private static final class EnterpriseBinding
    extends Binding {
        private final Object value;

        public EnterpriseBinding(String name, Object value) {
            super(name, value);
            this.value = value;
        }

        public void setName(String name) {
            throw new UnsupportedOperationException("EnterpriseNamingContext can not be modified");
        }

        public String getClassName() {
            if (this.value instanceof CachingReference) {
                CachingReference cachingReference = (CachingReference)this.value;
                return cachingReference.getClassName();
            }
            return this.value.getClass().getName();
        }

        public void setClassName(String name) {
            throw new UnsupportedOperationException("EnterpriseNamingContext can not be modified");
        }

        public Object getObject() {
            if (this.value instanceof CachingReference) {
                try {
                    CachingReference cachingReference = (CachingReference)this.value;
                    return cachingReference.get();
                }
                catch (NamingException e) {
                    throw new BindingResolutionException("Unable to resolve binding " + this.getName(), e);
                }
            }
            return this.value;
        }

        public void setObject(Object obj) {
            throw new UnsupportedOperationException("EnterpriseNamingContext can not be modified");
        }

        public boolean isRelative() {
            return false;
        }

        public void setRelative(boolean r) {
            throw new UnsupportedOperationException("EnterpriseNamingContext can not be modified");
        }
    }

    private static final class ListBindingEnumeration
    implements NamingEnumeration {
        private final Iterator iterator;

        public ListBindingEnumeration(Map localBindings) {
            this.iterator = localBindings.entrySet().iterator();
        }

        public boolean hasMore() {
            return this.iterator.hasNext();
        }

        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return this.nextElement();
        }

        public Object nextElement() {
            Map.Entry entry = (Map.Entry)this.iterator.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            return new EnterpriseBinding(name, value);
        }

        public void close() {
        }
    }

    private static final class ListEnumeration
    implements NamingEnumeration {
        private final Iterator iterator;

        public ListEnumeration(Map localBindings) {
            this.iterator = localBindings.entrySet().iterator();
        }

        public boolean hasMore() {
            return this.iterator.hasNext();
        }

        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return this.nextElement();
        }

        public Object nextElement() {
            Map.Entry entry = (Map.Entry)this.iterator.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            String className = null;
            if (value instanceof CachingReference) {
                CachingReference cachingReference = (CachingReference)value;
                className = cachingReference.getClassName();
            } else {
                className = value.getClass().getName();
            }
            return new NameClassPair(name, className);
        }

        public void close() {
        }
    }
}

