/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jmxremoting;

import java.io.IOException;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.NotificationFilterSupport;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.jmxremoting.Authenticator;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.jmx.MBeanServerDelegate;

public class JMXConnector
implements GBeanLifecycle {
    private final Kernel kernel;
    private final Log log;
    private final ClassLoader classLoader;
    private String url;
    private String applicationConfigName;
    private Authenticator authenticator;
    private JMXConnectorServer server;
    public static final GBeanInfo GBEAN_INFO;

    public JMXConnector(Kernel kernel, String objectName, ClassLoader classLoader) {
        this.kernel = kernel;
        this.classLoader = classLoader;
        this.log = LogFactory.getLog((String)objectName);
    }

    public String getApplicationConfigName() {
        return this.applicationConfigName;
    }

    public void setApplicationConfigName(String applicationConfigName) {
        this.applicationConfigName = applicationConfigName;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void doStart() throws Exception {
        JMXServiceURL serviceURL = new JMXServiceURL(this.url);
        HashMap<String, Authenticator> env = new HashMap<String, Authenticator>();
        if (this.applicationConfigName != null) {
            this.authenticator = new Authenticator(this.applicationConfigName, this.classLoader);
            env.put("jmx.remote.authenticator", this.authenticator);
        } else {
            this.log.warn((Object)("Starting unauthenticating JMXConnector for " + serviceURL));
        }
        MBeanServerDelegate mbeanServer = new MBeanServerDelegate(this.kernel);
        this.server = JMXConnectorServerFactory.newJMXConnectorServer(serviceURL, env, (MBeanServer)mbeanServer);
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType("jmx.remote.connection.opened");
        filter.enableType("jmx.remote.connection.closed");
        filter.enableType("jmx.remote.connection.failed");
        this.server.addNotificationListener(this.authenticator, filter, null);
        this.server.start();
        this.log.debug((Object)("Started JMXConnector " + this.server.getAddress()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doStop() throws Exception {
        try {
            try {
                this.server.stop();
            }
            catch (IOException e) {
                Object var3_2 = null;
                this.server = null;
                this.log.debug((Object)("Stopped JMXConnector " + this.url));
                return;
            }
            catch (Exception e) {
                throw e;
            }
            Object var3_1 = null;
            this.server = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.server = null;
            this.log.debug((Object)("Stopped JMXConnector " + this.url));
            throw throwable;
        }
        this.log.debug((Object)("Stopped JMXConnector " + this.url));
    }

    public void doFail() {
        try {
            this.doStop();
            this.log.warn((Object)("Failure in JMXConnector " + this.url));
        }
        catch (Exception e) {
            this.log.warn((Object)"Error stopping JMXConnector after failure", (Throwable)e);
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((Class)JMXConnector.class);
        infoFactory.addAttribute("url", String.class, true, true);
        infoFactory.addAttribute("applicationConfigName", String.class, true, true);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addAttribute("objectName", String.class, false);
        infoFactory.addAttribute("classLoader", ClassLoader.class, false);
        infoFactory.setConstructor(new String[]{"kernel", "objectName", "classLoader"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

