/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.geronimo.validator.ValidationError;
import org.apache.geronimo.validator.ValidationFailure;
import org.apache.geronimo.validator.ValidationWarning;

public class ValidationContext {
    protected ArrayList failures = new ArrayList();
    protected ArrayList warnings = new ArrayList();
    protected ArrayList errors = new ArrayList();
    protected Map attributes = new HashMap();
    protected String jarPath;

    public ValidationContext(String name) {
        this.jarPath = name;
    }

    public Set entrySet() {
        return this.attributes.entrySet();
    }

    public Object remove(Object key) {
        return this.attributes.remove(key);
    }

    public Object put(Object key, Object value) {
        return this.attributes.put(key, value);
    }

    public Object get(Object key) {
        return this.attributes.get(key);
    }

    public boolean containsKey(Object key) {
        return this.attributes.containsKey(key);
    }

    public void addWarning(ValidationWarning warning) {
        this.warnings.add(warning);
    }

    public void addFailure(ValidationFailure failure) {
        this.failures.add(failure);
    }

    public void addError(ValidationError error) {
        this.errors.add(error);
    }

    public ValidationFailure[] getFailures() {
        return this.failures.toArray(new ValidationFailure[0]);
    }

    public ValidationWarning[] getWarnings() {
        return this.failures.toArray(new ValidationWarning[0]);
    }

    public ValidationError[] getErrors() {
        return this.failures.toArray(new ValidationError[0]);
    }

    public boolean hasWarnings() {
        return this.warnings.size() > 0;
    }

    public boolean hasFailures() {
        return this.failures.size() > 0;
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }
}

