/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis.client;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.sf.cglib.proxy.CallbackFilter;

public class NoOverrideCallbackFilter
implements CallbackFilter {
    private Class superClass;

    public NoOverrideCallbackFilter(Class superClass) {
        this.superClass = superClass;
    }

    public int accept(Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            return 0;
        }
        if (method.getName().equals("remove") && Modifier.isAbstract(method.getModifiers())) {
            return 1;
        }
        try {
            this.superClass.getMethod(method.getName(), method.getParameterTypes());
            return 0;
        }
        catch (Throwable e) {
            return 1;
        }
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        NoOverrideCallbackFilter otherFilter = null;
        if (!(other instanceof NoOverrideCallbackFilter)) {
            return false;
        }
        otherFilter = (NoOverrideCallbackFilter)other;
        return this.superClass.equals(otherFilter.superClass);
    }

    public int hashCode() {
        return this.superClass.hashCode();
    }
}

